# Sistema de Notificación de Cambios en Cuentas Maestras

## Descripción

Esta nueva funcionalidad permite detectar automáticamente cuando se realizan cambios importantes en una cuenta maestra y notificar a todos los clientes vinculados a esa cuenta.

## Características

### 🔍 Detección Automática de Cambios
- **Email**: Detecta cuando se cambia el email de la cuenta (muestra anterior → nuevo)
- **Contraseña**: Detecta cuando se cambia la contraseña de la cuenta
- **Plataforma**: Detecta cuando se cambia la plataforma (muestra anterior → nueva)
- **Estado**: Detecta cuando se cambia el estado de la cuenta (muestra anterior → nuevo)

### 📱 Modal de Notificación
- Muestra un resumen de los cambios detectados con emojis y detalles específicos
- Lista todos los clientes afectados con sus datos
- Vista responsiva: tabla en escritorio, tarjetas en móvil
- **Modal inteligente**: Detecta automáticamente el tipo de cambio y genera mensajes personalizados
- **Mensajes automáticos**: Incluye datos reales del cambio (email anterior/nuevo, plataforma anterior/nueva)
- Permite personalizar mensajes según el tipo de cambio
- Botones de WhatsApp para cada cliente
- Función de copiar mensajes personalizados
- Vista previa de mensajes antes de enviar
- Alertas personalizadas con emojis
- **Actualización automática**: La página se recarga automáticamente al cerrar el modal

### ⚙️ Configuración de Mensajes
- Mensajes predefinidos configurables en la sección de configuración
- Variables disponibles: `{nombre_cliente}`, `{plataforma}`, `{nuevo_email}`, `{nueva_plataforma}`
- Diferentes mensajes según el tipo de cambio

## Instalación

### 1. Base de Datos
Ejecutar el archivo SQL para crear las configuraciones:
```sql
-- Ejecutar: config/insert_mensajes_config.sql
```

### 2. Archivos Modificados
- `actions/cuentas_maestras_controlador.php` - Lógica de detección de cambios
- `includes/message_helper.php` - Funciones helper para mensajes
- `pages/cuentas_maestras.php` - Modal de notificación
- `js/notificacion_cambios.js` - Funciones JavaScript
- `css/notificacion_cambios.css` - Estilos personalizados

## Uso

### Flujo de Trabajo
1. **Editar Cuenta Maestra**: El usuario edita una cuenta maestra existente
2. **Detección Automática**: El sistema detecta si hay cambios importantes
3. **Modal de Notificación**: Si hay cambios y clientes vinculados, se muestra el modal
4. **Personalización**: El usuario puede personalizar el mensaje
5. **Envío**: Se pueden enviar mensajes individuales o masivos por WhatsApp

### Configuración de Mensajes
1. Ir a **Configuración del Sistema**
2. Buscar la sección **"Mensajes de Cambio"**
3. Editar los mensajes según las necesidades
4. Guardar cambios

### Tipos de Mensajes Disponibles
- **Cambio de Email**: Para notificar cambios de email por seguridad
- **Cambio de Contraseña**: Para notificar cambios de contraseña
- **Cambio de Plataforma**: Para notificar migraciones de plataforma
- **Cambio de Estado**: Para notificar cambios de estado de cuenta
- **Cambio General**: Para otros tipos de cambios

## Funciones JavaScript

### `mostrarModalNotificacion(data)`
Muestra el modal con la información de cambios y clientes afectados.

### `abrirWhatsApp(telefono, nombreCliente)`
Abre WhatsApp con el mensaje personalizado para un cliente específico.

### `copiarMensajeCliente(nombreCliente)`
Copia el mensaje personalizado para un cliente al portapapeles.

### `enviarMensajesATodos(clientes, mensaje)`
Abre WhatsApp para todos los clientes con teléfono disponible.

### `mostrarVistaPrevia(mensaje, clientes)`
Muestra una vista previa de cómo se verá el mensaje para cada cliente.

### `mostrarAlerta(mensaje, tipo)`
Muestra alertas personalizadas con emojis y auto-ocultado.

## Variables de Mensaje

| Variable | Descripción | Ejemplo |
|----------|-------------|---------|
| `{nombre_cliente}` | Nombre del cliente | "Juan Pérez" |
| `{plataforma}` | Nombre de la plataforma | "Netflix" |
| `{nuevo_email}` | Nuevo email de la cuenta | "nuevo@email.com" |
| `{nueva_plataforma}` | Nueva plataforma | "Disney+" |

## Personalización

### Estilos CSS
El modal incluye estilos personalizados en `css/notificacion_cambios.css`:
- Gradientes en header y botones
- Sombras y efectos hover
- Scrollbar personalizado
- Animaciones suaves
- Diseño completamente responsivo
- Colores modernos y atractivos

### Mensajes por Defecto
Los mensajes por defecto están en `js/notificacion_cambios.js` y se pueden modificar directamente o a través de la configuración del sistema.

## Requisitos

- PHP 7.4+
- MySQL 5.7+
- Bootstrap 5.3+
- Font Awesome 6.5+
- Navegador con soporte para Clipboard API

## Solución de Problemas

### Modal no se muestra
- Verificar que el archivo `notificacion_cambios.js` esté incluido
- Revisar la consola del navegador para errores JavaScript
- Verificar que la respuesta del controlador incluya `cambios_detectados` y `clientes_vinculados`

### WhatsApp no se abre
- Verificar que el teléfono esté en formato internacional
- Asegurar que el mensaje no esté vacío
- Verificar permisos del navegador para abrir enlaces externos

### Mensajes no se copian
- Verificar que el navegador soporte Clipboard API
- Usar HTTPS en producción (requerido para Clipboard API)

## Contribución

Para agregar nuevos tipos de cambios:
1. Modificar la función `getDescripcionCambio()` en `notificacion_cambios.js`
2. Agregar el nuevo tipo en `obtenerMensajePredefinido()`
3. Actualizar la configuración de la base de datos
4. Probar la funcionalidad

## Licencia

Esta funcionalidad es parte del sistema DigitalPremium y sigue las mismas condiciones de licencia.
