<?php
if (session_status() === PHP_SESSION_NONE) session_start();

// Autorización básica
if (!isset($_SESSION['id_usuario'])) {
    http_response_code(401);
    echo '<div class="alert alert-warning">Sesión expirada. Vuelve a iniciar sesión.</div>';
    exit;
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/tenant_helper.php';

$id_usuario_sesion = (int)($_SESSION['id_usuario'] ?? 0);
$rol_usuario_sesion = $_SESSION['rol'] ?? 'ventas';

// Entrada
$q = isset($_POST['q']) ? trim((string)$_POST['q']) : '';
$page = isset($_POST['page']) ? max(1, (int)$_POST['page']) : 1;
$pageSize = isset($_POST['pageSize']) ? max(5, min(50, (int)$_POST['pageSize'])) : 12;
$offset = ($page - 1) * $pageSize;

// Seguridad: evitar wildcard costoso si cadena vacía
if ($q === '') {
    echo '';
    exit;
}

// Normalizar búsqueda: si es teléfono, comparar sin símbolos
$qLike = '%' . $q . '%';

// WHERE por rol (multiusuario)
$where = [];
$params = [];
if (strtolower($rol_usuario_sesion) !== 'superadmin') {
    $where[] = 'cm.id_usuario = :uid';
    $params[':uid'] = $id_usuario_sesion;
}

// Filtro por texto (email cuenta, proveedor, plataforma, perfil, cliente, teléfono, email cliente)
$where[] = '(
    cm.email_cuenta LIKE :q
    OR cm.nombre_proveedor LIKE :q
    OR p.nombre_plataforma LIKE :q
    OR pv.nombre_perfil_cliente LIKE :q
    OR c.nombre_completo LIKE :q
    OR REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(c.telefono,"+",''),'-',''),' ',''),'(',''),')',''),'.','') LIKE REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(:q2,"+",''),'-',''),' ',''),'(',''),')',''),'.','')
    OR c.email LIKE :q
)';
$params[':q'] = $qLike;
$params[':q2'] = $qLike;

$whereSql = empty($where) ? '' : (' WHERE ' . implode(' AND ', $where));

// Consulta: resultados "tarjetas" por cuenta maestra, con perfiles agrupados (limit/pagination)
$sql = "
    SELECT
        cm.id_cuenta_maestra, cm.id_plataforma, cm.email_cuenta, cm.password_cuenta,
        cm.perfiles_total, cm.perfiles_disponibles, cm.estado_cuenta, cm.fecha_vencimiento_proveedor,
        cm.nombre_proveedor, cm.costo_compra,
        p.nombre_plataforma, p.max_perfiles_cuenta,
        DATEDIFF(cm.fecha_vencimiento_proveedor, CURDATE()) as dias_restantes_cm,
        GROUP_CONCAT(
            DISTINCT CONCAT_WS('|',
                pv.id_perfil_vendido,
                pv.nombre_perfil_cliente,
                COALESCE(pv.pin_perfil_cliente, ''),
                pv.fecha_inicio_servicio,
                pv.fecha_fin_servicio,
                pv.precio_venta,
                pv.estado_suscripcion,
                c.nombre_completo,
                COALESCE(c.telefono, '')
            ) ORDER BY pv.nombre_perfil_cliente ASC SEPARATOR '###'
        ) AS perfiles_vendidos_data
    FROM cuentas_maestras cm
    JOIN plataformas p ON cm.id_plataforma = p.id_plataforma
    LEFT JOIN perfiles_vendidos pv ON cm.id_cuenta_maestra = pv.id_cuenta_maestra AND pv.estado_suscripcion != 2
    LEFT JOIN clientes c ON pv.id_cliente = c.id_cliente
    $whereSql
    GROUP BY cm.id_cuenta_maestra
    ORDER BY p.nombre_plataforma ASC, cm.estado_cuenta DESC, cm.perfiles_disponibles DESC
    LIMIT :limit OFFSET :offset
";

$stmt = $pdo->prepare($sql);
foreach ($params as $k => $v) { $stmt->bindValue($k, $v, PDO::PARAM_STR); }
$stmt->bindValue(':limit', $pageSize, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Verificar si hay más páginas
$sqlCount = "SELECT COUNT(DISTINCT cm.id_cuenta_maestra) AS total FROM cuentas_maestras cm
             JOIN plataformas p ON cm.id_plataforma = p.id_plataforma
             LEFT JOIN perfiles_vendidos pv ON cm.id_cuenta_maestra = pv.id_cuenta_maestra AND pv.estado_suscripcion != 2
             LEFT JOIN clientes c ON pv.id_cliente = c.id_cliente
             $whereSql";
$stmtC = $pdo->prepare($sqlCount);
foreach ($params as $k => $v) { $stmtC->bindValue($k, $v, PDO::PARAM_STR); }
$stmtC->execute();
$total = (int)($stmtC->fetchColumn() ?: 0);
$canMore = ($offset + $pageSize) < $total;

// Renderizado HTML de tarjetas (mismo estilo de dashboard)
ob_start();
if (!$rows) {
    echo '';
} else {
    foreach ($rows as $cm) {
        $profiles = [];
        if (!empty($cm['perfiles_vendidos_data'])) {
            foreach (explode('###', $cm['perfiles_vendidos_data']) as $pData) {
                $parts = explode('|', $pData);
                if (count($parts) === 9) {
                    $profiles[] = [
                        'id' => $parts[0],
                        'nombre' => $parts[1],
                        'pin' => $parts[2],
                        'ini' => $parts[3],
                        'fin' => $parts[4],
                        'precio' => (float)$parts[5],
                        'estado' => (int)$parts[6],
                        'cliente' => $parts[7],
                        'tel' => $parts[8],
                    ];
                }
            }
        }

        $status_class = 'account-status-active';
        $status_text = 'Activa';
        if ((int)$cm['estado_cuenta'] === 0) { $status_class = 'account-status-inactive'; $status_text = 'Inactiva/Vencida'; }
        elseif ((int)$cm['estado_cuenta'] === 2) { $status_class = 'account-status-problem'; $status_text = 'Con Problemas'; }

        $dias = (int)$cm['dias_restantes_cm'];
        $expiry_class = 'bg-success';
        $expiry_value = 100;
        $expiry_text = '';
        if ((int)$cm['estado_cuenta'] == 1) {
            if ($dias < 0) { $expiry_text = 'Vencida hace ' . abs($dias) . ' día(s)'; $expiry_class = 'bg-danger'; $expiry_value = 0; }
            elseif ($dias == 0) { $expiry_text = 'Vence HOY'; $expiry_class = 'bg-danger'; $expiry_value = 5; }
            elseif ($dias <= 15) { $expiry_text = 'Vence en ' . $dias . ' día(s)'; $expiry_class = 'bg-warning'; $expiry_value = max(5, ($dias / 15) * 100); }
            else { $expiry_text = 'Activa'; $expiry_class = 'bg-success'; $expiry_value = min(100, ($dias / 30) * 100); }
        } else { $expiry_text = ((int)$cm['estado_cuenta'] === 0 ? 'Inactiva' : 'Con Problemas'); $expiry_class = 'bg-secondary'; $expiry_value = 100; }

        echo '<div class="row g-4" data-can-more="' . ($canMore ? '1' : '0') . '">';
        echo '  <div class="col-xl-4 col-lg-6 col-md-6">';
        echo '    <div class="account-card ' . htmlspecialchars(getPlatformCardColorClass($cm['nombre_plataforma'])) . '">';
        echo '      <span class="account-status-badge ' . $status_class . '">' . $status_text . '</span>';
        echo '      <div class="card-header">';
        echo '        <span class="text-truncate" title="' . htmlspecialchars($cm['email_cuenta']) . '">' . htmlspecialchars($cm['email_cuenta']) . '</span>';
        echo '        <div class="d-flex align-items-center gap-2">';
        echo '          <a href="/digitalpremium/pages/cuentas_maestras.php?editar_id=' . htmlspecialchars($cm['id_cuenta_maestra']) . '" class="btn-icon" data-bs-toggle="tooltip" title="Configurar Cuenta"><i class="fas fa-cog"></i></a>';
        echo '        </div>';
        echo '      </div>';
        echo '      <div class="card-body">';
        echo '        <div class="account-details">';
        echo '          <div class="detail-item"><span>Vencimiento:</span> <strong>' . (!empty($cm['fecha_vencimiento_proveedor']) ? date('d/m/Y', strtotime($cm['fecha_vencimiento_proveedor'])) : 'N/A') . '</strong></div>';
        echo '          <div class="account-expiry-bar-container">';
        echo '            <div class="d-flex justify-content-between small text-muted mb-1">';
        echo '              <span>Estado Vencimiento:</span>';
        echo '              <span class="fw-bold ' . ($expiry_class == 'bg-danger' ? 'text-danger' : ($expiry_class == 'bg-warning' ? 'text-warning' : 'text-success')) . '">' . $expiry_text . '</span>';
        echo '            </div>';
        echo '            <div class="progress" title="' . $expiry_text . '" data-bs-toggle="tooltip">';
        echo '              <div class="progress-bar ' . $expiry_class . '" role="progressbar" style="width: ' . (int)$expiry_value . '%;" aria-valuenow="' . (int)$expiry_value . '" aria-valuemin="0" aria-valuemax="100"></div>';
        echo '            </div>';
        echo '          </div>';
        echo '          <div class="detail-item mt-3">';
        echo '            <span>Contraseña:</span>';
        echo '            <div class="password-wrapper">';
        echo '              <input type="password" readonly class="form-control-plaintext p-0 border-0 fw-bold text-dark" value="' . htmlspecialchars($cm['password_cuenta']) . '" style="width: 100%;">';
        echo '            </div>';
        echo '          </div>';
        echo '          <div class="detail-item"><span>Proveedor:</span> <strong>' . htmlspecialchars($cm['nombre_proveedor'] ?? 'N/A') . '</strong></div>';
        echo '          <div class="detail-item"><span>Costo Compra:</span> <strong>' . htmlspecialchars('S/') . number_format((float)$cm['costo_compra'], 2) . '</strong></div>';
        echo '        </div>';

        if (!empty($profiles)) {
            echo '  <div class="profiles-list-wrapper">';
            echo '    <h6 class="small fw-bold text-uppercase text-muted mb-3"><i class="fas fa-user-tag me-2"></i>Perfiles Asignados</h6>';
            echo '    <div class="profiles-list">';
            foreach ($profiles as $pf) {
                $status_badge = ($pf['estado'] == 1 ? 'status-badge-profile active' : 'status-badge-profile inactive');
                $status_text  = ($pf['estado'] == 1 ? 'Activa' : 'Inactiva');
                echo '  <div class="profile-item">';
                echo '    <div class="d-flex align-items-center mb-2">';
                echo '      <div class="profile-status-dot ' . ($pf['estado'] == 1 ? 'profile-status-active' : 'profile-status-inactive') . '"></div>';
                echo '      <strong class="ms-2">' . htmlspecialchars($pf['nombre']) . '</strong>';
                echo '      <span class="ms-auto badge ' . $status_badge . '">' . $status_text . '</span>';
                echo '    </div>';
                echo '    <div class="row g-2 small">';
                echo '      <div class="col-6"><span class="text-muted">Cliente:</span><div class="fw-semibold text-truncate" title="' . htmlspecialchars($pf['cliente']) . '">' . htmlspecialchars($pf['cliente']) . '</div></div>';
                echo '      <div class="col-6"><span class="text-muted">Teléfono:</span><div class="fw-semibold text-truncate">' . htmlspecialchars($pf['tel']) . '</div></div>';
                echo '      <div class="col-6"><span class="text-muted">Precio:</span><div class="fw-semibold">S/' . number_format($pf['precio'], 2) . '</div></div>';
                echo '      <div class="col-6"><span class="text-muted">Fin:</span><div class="fw-semibold">' . (!empty($pf['fin']) ? date('d/m/Y', strtotime($pf['fin'])) : 'N/A') . '</div></div>';
                echo '    </div>';
                echo '  </div>';
            }
            echo '    </div>';
            echo '  </div>';
        }

        echo '      </div>';
        echo '    </div>';
        echo '  </div>';
        echo '</div>';
    }
}

$html = ob_get_clean();
echo $html;
exit;
<?php



