<?php
// FILE: /digitalpremium/actions/configuracion_controlador.php

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Verificación de autenticación al principio
if (!isset($_SESSION['id_usuario'])) {
    header("Location: /digitalpremium/login.php?error=" . urlencode("Acceso no autorizado. Por favor, inicie sesión."));
    exit();
}

require_once '../config/db.php'; // Incluir la conexión a la base de datos

$accion = $_POST['accion'] ?? null;
$mensaje = '';
$tipo_mensaje = 'danger';
$id_usuario_sesion = $_SESSION['id_usuario']; // Obtener el ID del usuario de la sesión

// --- ATENCIÓN: VERIFICACIÓN DE ROL ---
// Decide si todos los usuarios pueden guardar sus configuraciones o solo 'superadmin'/'admin'.
// Si todos pueden, puedes eliminar o comentar este bloque.
// Si solo ciertos roles pueden acceder a esta funcionalidad, mantén el bloque.
/*
if ($_SESSION['rol'] !== 'superadmin' && $_SESSION['rol'] !== 'admin') {
    header("Location: /digitalpremium/pages/dashboard.php?mensaje=" . urlencode("Acceso denegado. No tienes permisos para guardar configuraciones.") . "&tipo=danger");
    exit();
}
*/

if ($accion == 'guardar_configuraciones') {
    if (isset($_POST['config']) && is_array($_POST['config'])) {
        $procesados = 0; // Contará tanto actualizaciones como inserciones

        if (!$pdo) {
            $mensaje = "Error crítico: No se pudo establecer la conexión a la base de datos.";
        } else {
            $pdo->beginTransaction(); // Iniciar transacción

            try {
                // Preparamos la consulta para obtener los valores por defecto de la configuración global
                // Esto es necesario para copiar los metadatos (nombre_visible, tipo_input, etc.)
                // cuando se inserta una nueva configuración por usuario.
                $sql_get_default_config = "SELECT nombre_visible, descripcion_config, tipo_input, opciones_select, grupo_config, orden_grupo FROM configuraciones WHERE clave_config = :clave_default AND id_usuario IS NULL";
                $stmt_get_default_config = $pdo->prepare($sql_get_default_config);

                // --- CLAVE: Sentencia INSERT ... ON DUPLICATE KEY UPDATE para UPSERT ---
                // Esta sentencia intentará insertar una nueva configuración para el usuario.
                // Si ya existe una configuración para ese (id_usuario, clave_config) (debido a la clave única 'usuario_clave_unica'),
                // entonces actualizará el valor_config (y otros metadatos si fuera necesario, aunque usualmente no cambian).
                $sql_upsert = "
                    INSERT INTO configuraciones 
                        (id_usuario, clave_config, valor_config, nombre_visible, descripcion_config, tipo_input, opciones_select, grupo_config, orden_grupo) 
                    VALUES 
                        (:id_usuario, :clave, :valor, :nombre_visible, :descripcion_config, :tipo_input, :opciones_select, :grupo_config, :orden_grupo)
                    ON DUPLICATE KEY UPDATE 
                        valor_config = VALUES(valor_config),
                        nombre_visible = VALUES(nombre_visible),        -- Se actualizan también los metadatos por si cambian en la global
                        descripcion_config = VALUES(descripcion_config),
                        tipo_input = VALUES(tipo_input),
                        opciones_select = VALUES(opciones_select),
                        grupo_config = VALUES(grupo_config),
                        orden_grupo = VALUES(orden_grupo)
                ";
                $stmt_upsert = $pdo->prepare($sql_upsert);

                // Recorremos cada configuración enviada desde el formulario
                foreach ($_POST['config'] as $clave_config => $valor_form) {
                    $valor_a_guardar = trim((string)$valor_form); // Asegura que el valor sea string para trim()

                    // Obtener los detalles de la configuración global para esa clave
                    $stmt_get_default_config->execute([':clave_default' => $clave_config]);
                    $default_config_details = $stmt_get_default_config->fetch(PDO::FETCH_ASSOC);

                    if (!$default_config_details) {
                        // Si la clave de configuración no existe ni siquiera globalmente (con id_usuario IS NULL),
                        // no podemos insertarla para el usuario porque nos faltarían los metadatos.
                        error_log("Advertencia: Clave de configuración '{$clave_config}' no encontrada como global por defecto (id_usuario IS NULL). No se pudo guardar para el usuario {$id_usuario_sesion}.");
                        continue; // Saltar a la siguiente configuración en el bucle
                    }

                    // Ejecutar la sentencia UPSERT con los valores específicos del usuario
                    // y los metadatos copiados de la configuración global.
                    $stmt_upsert->execute([
                        ':id_usuario' => $id_usuario_sesion,
                        ':clave' => $clave_config,
                        ':valor' => $valor_a_guardar,
                        // Usar los metadatos obtenidos de la configuración global por defecto
                        ':nombre_visible' => $default_config_details['nombre_visible'],
                        ':descripcion_config' => $default_config_details['descripcion_config'],
                        ':tipo_input' => $default_config_details['tipo_input'],
                        ':opciones_select' => $default_config_details['opciones_select'],
                        ':grupo_config' => $default_config_details['grupo_config'],
                        ':orden_grupo' => $default_config_details['orden_grupo']
                    ]);
                    
                    // rowCount() para ON DUPLICATE KEY UPDATE:
                    // Es 1 si se insertó una nueva fila.
                    // Es 2 si se actualizó una fila existente (y el valor fue diferente).
                    // Es 0 si el valor era el mismo y no hubo cambio real.
                    // En cualquier caso > 0, significa que se procesó correctamente.
                    $rows_affected = $stmt_upsert->rowCount();
                    if ($rows_affected > 0) {
                        $procesados++;
                    }
                }

                $pdo->commit(); // Confirmar la transacción si todo fue bien
                $mensaje = "Configuraciones guardadas exitosamente. " . $procesados . " valor(es) procesado(s) (insertado o actualizado).";
                $tipo_mensaje = 'success';

            } catch (PDOException $e) {
                $pdo->rollBack(); // Si ocurre cualquier error, revertir todos los cambios
                $mensaje = "Error de base de datos al guardar configuraciones: " . $e->getMessage();
                error_log("Error PDO en configuracion_controlador para usuario {$id_usuario_sesion}: " . $e->getMessage()); // Para depuración del lado del servidor
            }
        }
    } else {
        $mensaje = "No se recibieron datos de configuración válidos para guardar.";
        $tipo_mensaje = 'warning';
    }
} else {
    $mensaje = "Acción no reconocida.";
    $tipo_mensaje = 'warning';
}

// Redirigir de vuelta a la página de configuraciones con el mensaje de resultado
header("Location: /digitalpremium/pages/configuracion.php?mensaje=" . urlencode($mensaje) . "&tipo=" . urlencode($tipo_mensaje));
exit();
?>