<?php
if (session_status() === PHP_SESSION_NONE) session_start();

// Autorización básica
if (!isset($_SESSION['id_usuario'])) {
    http_response_code(401);
    exit('Acceso no autorizado');
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/tenant_helper.php';

$id_usuario_sesion = (int)($_SESSION['id_usuario'] ?? 0);
$rol_usuario_sesion = $_SESSION['rol'] ?? 'ventas';

// Parámetros de filtros
$search_query = $_GET['search_query'] ?? '';
$filtro_plataforma = $_GET['filtro_plataforma'] ?? '';
$filtro_estado = $_GET['filtro_estado'] ?? '';
$filtro_perfiles_disponibles = $_GET['filtro_perfiles_disponibles'] ?? '';

// WHERE por rol (multiusuario)
$where = [];
$params = [];
if (strtolower($rol_usuario_sesion) !== 'superadmin') {
    $where[] = 'cm.id_usuario = :uid';
    $params[':uid'] = $id_usuario_sesion;
}

// Aplicar filtros
if (!empty($filtro_plataforma)) {
    $where[] = 'p.id_plataforma = :id_plataforma';
    $params[':id_plataforma'] = $filtro_plataforma;
}

if ($filtro_estado !== '') {
    $where[] = 'cm.estado_cuenta = :estado_cuenta';
    $params[':estado_cuenta'] = $filtro_estado;
}

if ($filtro_perfiles_disponibles === 'si') {
    $where[] = 'cm.perfiles_disponibles > 0';
}

if (!empty($search_query)) {
    $search_query_param = '%' . trim($search_query) . '%';
    $where[] = '(
        cm.email_cuenta LIKE :search_query 
        OR cm.nombre_proveedor LIKE :search_query 
        OR p.nombre_plataforma LIKE :search_query 
        OR pv.nombre_perfil_cliente LIKE :search_query 
        OR c.nombre_completo LIKE :search_query_client_name
        OR REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(c.telefono,"+",""),"-","")," ",""),"(",""),")",""),".","") LIKE :search_query_tel
        OR c.email LIKE :search_query
    )';
    $params[':search_query'] = $search_query_param;
    $params[':search_query_client_name'] = $search_query_param;
    $params[':search_query_tel'] = preg_replace('/[^0-9]/', '', $search_query);
}

$whereSql = empty($where) ? '' : (' WHERE ' . implode(' AND ', $where));

// Consulta para exportar
$sql = "
    SELECT
        p.nombre_plataforma,
        cm.email_cuenta,
        cm.password_cuenta,
        cm.nombre_proveedor,
        cm.costo_compra,
        cm.perfiles_total,
        cm.perfiles_disponibles,
        CASE 
            WHEN cm.estado_cuenta = 1 THEN 'Activa'
            WHEN cm.estado_cuenta = 0 THEN 'Inactiva/Vencida'
            WHEN cm.estado_cuenta = 2 THEN 'Con Problemas'
            ELSE 'Desconocido'
        END as estado_cuenta,
        cm.fecha_vencimiento_proveedor,
        DATEDIFF(cm.fecha_vencimiento_proveedor, CURDATE()) as dias_restantes,
        GROUP_CONCAT(
            DISTINCT CONCAT_WS(' - ',
                pv.nombre_perfil_cliente,
                c.nombre_completo,
                c.telefono,
                pv.precio_venta,
                CASE WHEN pv.estado_suscripcion = 1 THEN 'Activo' ELSE 'Inactivo' END
            ) ORDER BY pv.nombre_perfil_cliente ASC SEPARATOR ' | '
        ) AS perfiles_asignados
    FROM cuentas_maestras cm
    JOIN plataformas p ON cm.id_plataforma = p.id_plataforma
    LEFT JOIN perfiles_vendidos pv ON cm.id_cuenta_maestra = pv.id_cuenta_maestra AND pv.estado_suscripcion != 2
    LEFT JOIN clientes c ON pv.id_cliente = c.id_cliente
    $whereSql
    GROUP BY cm.id_cuenta_maestra
    ORDER BY p.nombre_plataforma ASC, cm.estado_cuenta DESC, cm.perfiles_disponibles DESC
";

$stmt = $pdo->prepare($sql);
foreach ($params as $k => $v) {
    $stmt->bindValue($k, $v, PDO::PARAM_STR);
}
$stmt->execute();
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Configurar headers para descarga CSV
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="dashboard_results_' . date('Y-m-d_H-i-s') . '.csv"');

// Crear archivo CSV
$output = fopen('php://output', 'w');

// BOM para UTF-8 en Excel
fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));

// Headers del CSV
$headers = [
    'Plataforma',
    'Email Cuenta',
    'Contraseña',
    'Proveedor',
    'Costo Compra',
    'Perfiles Totales',
    'Perfiles Disponibles',
    'Estado Cuenta',
    'Fecha Vencimiento',
    'Días Restantes',
    'Perfiles Asignados'
];
fputcsv($output, $headers);

// Datos
foreach ($rows as $row) {
    $csvRow = [
        $row['nombre_plataforma'],
        $row['email_cuenta'],
        $row['password_cuenta'],
        $row['nombre_proveedor'],
        $row['costo_compra'],
        $row['perfiles_total'],
        $row['perfiles_disponibles'],
        $row['estado_cuenta'],
        $row['fecha_vencimiento_proveedor'],
        $row['dias_restantes'],
        $row['perfiles_asignados'] ?: 'Ninguno'
    ];
    fputcsv($output, $csvRow);
}

fclose($output);
exit;

