<?php
/**
 * ANÁLISIS DE MIGRACIÓN ENTRE BASES DE DATOS
 * Compara la estructura de la BD antigua vs la nueva
 */

// Configuración de ambas bases de datos
$config_antigua = [
    'host' => '127.0.0.1',
    'port' => 3306,
    'dbname' => 'digitalpremium', // Base de datos antigua
    'username' => 'root',
    'password' => ''
];

$config_nueva = [
    'host' => '127.0.0.1',
    'port' => 3306,
    'dbname' => 'digitalpremiumnueva', // Base de datos nueva
    'username' => 'root',
    'password' => ''
];

echo "🔍 ANÁLISIS DE MIGRACIÓN DE BASES DE DATOS\n";
echo "==========================================\n\n";

try {
    // Conexión a BD antigua
    $dsn_antigua = "mysql:host={$config_antigua['host']};port={$config_antigua['port']};dbname={$config_antigua['dbname']};charset=utf8mb4";
    $pdo_antigua = new PDO($dsn_antigua, $config_antigua['username'], $config_antigua['password']);
    $pdo_antigua->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "✅ Conexión exitosa a BD ANTIGUA: {$config_antigua['dbname']}\n";
    
    // Conexión a BD nueva
    $dsn_nueva = "mysql:host={$config_nueva['host']};port={$config_nueva['port']};dbname={$config_nueva['dbname']};charset=utf8mb4";
    $pdo_nueva = new PDO($dsn_nueva, $config_nueva['username'], $config_nueva['password']);
    $pdo_nueva->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "✅ Conexión exitosa a BD NUEVA: {$config_nueva['dbname']}\n\n";
    
    // 1. ANALIZAR TABLAS DE BD ANTIGUA
    echo "📋 TABLAS EN BD ANTIGUA ({$config_antigua['dbname']}):\n";
    echo "------------------------------------------------\n";
    $stmt = $pdo_antigua->query("SHOW TABLES");
    $tablas_antigua = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    if (empty($tablas_antigua)) {
        echo "❌ No hay tablas en la BD antigua\n\n";
    } else {
        foreach ($tablas_antigua as $tabla) {
            echo "• $tabla\n";
        }
        echo "\n";
    }
    
    // 2. ANALIZAR TABLAS DE BD NUEVA
    echo "📋 TABLAS EN BD NUEVA ({$config_nueva['dbname']}):\n";
    echo "------------------------------------------------\n";
    $stmt = $pdo_nueva->query("SHOW TABLES");
    $tablas_nueva = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    if (empty($tablas_nueva)) {
        echo "❌ No hay tablas en la BD nueva\n\n";
    } else {
        foreach ($tablas_nueva as $tabla) {
            echo "• $tabla\n";
        }
        echo "\n";
    }
    
    // 3. ANALIZAR ESTRUCTURA DE TABLAS CLAVE
    echo "🔍 ANÁLISIS DETALLADO DE TABLAS CLAVE:\n";
    echo "======================================\n\n";
    
    // Mapeo sugerido basado en nombres comunes
    $mapeo_sugerido = [
        'productos' => 'cuentas_maestras',
        'usuarios' => 'usuarios',
        'ventas' => 'perfiles_vendidos',
        'clientes' => 'clientes',
        'proveedores' => 'proveedores',
        'categorias' => 'categorias',
        'configuracion' => 'configuraciones',
        'auditoria' => 'auditoria_acciones',
        'logs' => 'auditoria_acciones'
    ];
    
    foreach ($mapeo_sugerido as $tabla_antigua => $tabla_nueva) {
        if (in_array($tabla_antigua, $tablas_antigua)) {
            echo "📊 TABLA ANTIGUA: $tabla_antigua\n";
            echo "   Estructura:\n";
            
            try {
                $stmt = $pdo_antigua->query("DESCRIBE $tabla_antigua");
                $columnas_antigua = $stmt->fetchAll(PDO::FETCH_ASSOC);
                
                foreach ($columnas_antigua as $col) {
                    echo "     • {$col['Field']} - {$col['Type']} - {$col['Null']} - {$col['Key']} - {$col['Default']}\n";
                }
                
                // Contar registros
                $stmt = $pdo_antigua->query("SELECT COUNT(*) as total FROM $tabla_antigua");
                $total_antigua = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
                echo "     📈 Total de registros: $total_antigua\n";
                
            } catch (Exception $e) {
                echo "     ❌ Error al analizar: " . $e->getMessage() . "\n";
            }
            
            // Verificar si existe la tabla nueva correspondiente
            if (in_array($tabla_nueva, $tablas_nueva)) {
                echo "   ✅ TABLA NUEVA CORRESPONDIENTE: $tabla_nueva\n";
                echo "   Estructura:\n";
                
                try {
                    $stmt = $pdo_nueva->query("DESCRIBE $tabla_nueva");
                    $columnas_nueva = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    
                    foreach ($columnas_nueva as $col) {
                        echo "     • {$col['Field']} - {$col['Type']} - {$col['Null']} - {$col['Key']} - {$col['Default']}\n";
                    }
                    
                    // Contar registros
                    $stmt = $pdo_nueva->query("SELECT COUNT(*) as total FROM $tabla_nueva");
                    $total_nueva = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
                    echo "     📈 Total de registros: $total_nueva\n";
                    
                } catch (Exception $e) {
                    echo "     ❌ Error al analizar: " . $e->getMessage() . "\n";
                }
                
            } else {
                echo "   ❌ TABLA NUEVA NO ENCONTRADA: $tabla_nueva\n";
            }
            
            echo "\n";
        }
    }
    
    // 4. ANALIZAR TABLAS NO MAPEADAS
    echo "🔍 TABLAS NO MAPEADAS:\n";
    echo "=======================\n";
    
    $tablas_no_mapeadas = array_diff($tablas_antigua, array_keys($mapeo_sugerido));
    if (!empty($tablas_no_mapeadas)) {
        echo "📋 Tablas en BD antigua que no tienen mapeo:\n";
        foreach ($tablas_no_mapeadas as $tabla) {
            echo "• $tabla\n";
        }
        echo "\n";
    }
    
    $tablas_nuevas_sin_mapeo = array_diff($tablas_nueva, array_values($mapeo_sugerido));
    if (!empty($tablas_nuevas_sin_mapeo)) {
        echo "📋 Tablas en BD nueva que no tienen mapeo:\n";
        foreach ($tablas_nuevas_sin_mapeo as $tabla) {
            echo "• $tabla\n";
        }
        echo "\n";
    }
    
    // 5. RECOMENDACIONES DE MIGRACIÓN
    echo "💡 RECOMENDACIONES DE MIGRACIÓN:\n";
    echo "================================\n";
    
    echo "1. 🔄 Mapeo sugerido:\n";
    foreach ($mapeo_sugerido as $antigua => $nueva) {
        if (in_array($antigua, $tablas_antigua)) {
            echo "   • $antigua → $nueva\n";
        }
    }
    
    echo "\n2. ⚠️ Consideraciones:\n";
    echo "   • Verificar que los tipos de datos sean compatibles\n";
    echo "   • Mapear campos con nombres diferentes\n";
    echo "   • Preservar claves foráneas y relaciones\n";
    echo "   • Hacer backup antes de la migración\n";
    
    echo "\n3. 🚀 Próximos pasos:\n";
    echo "   • Confirmar el mapeo de tablas\n";
    echo "   • Crear script de migración personalizado\n";
    echo "   • Ejecutar migración en modo de prueba\n";
    
} catch (PDOException $e) {
    echo "❌ ERROR DE CONEXIÓN: " . $e->getMessage() . "\n";
} catch (Exception $e) {
    echo "❌ ERROR GENERAL: " . $e->getMessage() . "\n";
}

echo "\n🔍 ANÁLISIS COMPLETADO\n";
echo "=======================\n";
?>
