<?php
// FILE: /digitalpremium/auth/logout.php
declare(strict_types=1);
if (session_status() === PHP_SESSION_NONE) session_start();

// Guardar quién cierra sesión (antes de destruirla)
$uid = $_SESSION['id_usuario'] ?? null;
$rol = $_SESSION['rol'] ?? null;

require_once __DIR__ . '/../config/db.php';

// Auditoría (best-effort; no bloquea el logout si falla)
if ($uid) {
    try {
        require_once __DIR__ . '/../includes/audit_helper.php';
        $db = function_exists('db') ? db() : $pdo;
        auditarLogout($db, (int)$uid, (string)$rol);
    } catch (Throwable $e) {
        // silencioso
    }
}

// Limpiar sesión
$_SESSION = [];
if (ini_get('session.use_cookies')) {
    $p = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $p['path'], $p['domain'], $p['secure'], $p['httponly']);
}
session_destroy();

// Redirigir al login
header('Location: /digitalpremium/login.php?logout_success=1');
exit;
