<?php
$id_usuario_a_clonar = 1; // ID de tu usuario Super Admin

require_once 'config/db.php';

echo "<h3>Clonando configuraciones para el Usuario ID: {$id_usuario_a_clonar}</h3>";

try {
    $pdo->beginTransaction();

    // Primero, borramos configuraciones viejas de este usuario para evitar duplicados
    $stmt_delete = $pdo->prepare("DELETE FROM configuraciones WHERE id_usuario = ?");
    $stmt_delete->execute([$id_usuario_a_clonar]);

    // Obtenemos la plantilla
    $stmt_plantilla = $pdo->query("SELECT * FROM configuraciones WHERE id_usuario IS NULL");
    $plantilla_configs = $stmt_plantilla->fetchAll(PDO::FETCH_ASSOC);

    if (empty($plantilla_configs)) {
        die("<p style='color:red;'><strong>Error:</strong> No se encontró la plantilla de configuraciones maestras.</p>");
    }

    // Preparamos la inserción
    $sql_insert = "INSERT INTO configuraciones (id_usuario, clave_config, valor_config, nombre_visible, descripcion_config, tipo_input, opciones_select, grupo_config, orden_grupo) 
                   VALUES (:id_usuario, :clave, :valor, :nombre, :desc, :tipo, :opciones, :grupo, :orden)";
    $stmt_insert = $pdo->prepare($sql_insert);

    $clonados = 0;
    foreach ($plantilla_configs as $config) {
        $stmt_insert->execute([
            ':id_usuario' => $id_usuario_a_clonar, ':clave' => $config['clave_config'],
            ':valor' => $config['valor_config'], ':nombre' => $config['nombre_visible'],
            ':desc' => $config['descripcion_config'], ':tipo' => $config['tipo_input'],
            ':opciones' => $config['opciones_select'], ':grupo' => $config['grupo_config'],
            ':orden' => $config['orden_grupo']
        ]);
        $clonados++;
    }

    $pdo->commit();

    echo "<p style='color:green;'><strong>Éxito:</strong> Se han clonado/restablecido {$clonados} configuraciones para el usuario ID {$id_usuario_a_clonar}.</p>";
    echo "<p><strong>Importante:</strong> Ahora puedes eliminar este archivo (clonar_config.php) de tu servidor por seguridad.</p>";

} catch (Exception $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    die("<p style='color:red;'><strong>Error Crítico:</strong> " . $e->getMessage() . "</p>");
}