<?php
// Configurar zona horaria de PHP para Perú (UTC-5)
date_default_timezone_set('America/Lima');

/**
 * FILE: /digitalpremium/config/db.php
 * Conexión PDO — Entorno LOCAL (XAMPP)
 *
 * - Por defecto usa:
 *   host: 127.0.0.1
 *   port: 3306
 *   user: root
 *   pass: (vacío)
 *   dbname: digitalpremium_local  ← cámbialo al nombre que importes en tu XAMPP
 *
 * Sugerencia: crea la BD en XAMPP con el mismo nombre que pongas aquí.
 */

if (!isset($pdo) || !($pdo instanceof PDO)) {

    /* ---------- Ajustes de entorno (local por defecto) ---------- */
    // Cambia DP_ENV a 'prod' cuando migres; aquí lo dejamos en 'local'.
    $ENV = getenv('DP_ENV') ?: 'local';

    $CONFIG = [
        'local' => [
            'DB_HOST' => '127.0.0.1',   // usar 127.0.0.1 evita temas de sockets con "localhost"
            'DB_PORT' => 3306,
            'DB_NAME' => 'kreativo_digitalpremium', // <-- CAMBIA al nombre de tu BD importada
            'DB_USER' => 'kreativo_digitalpremium',
            'DB_PASS' => 'Paranormal#2808',
        ],
        // Puedes completar esta sección cuando configures producción.
        'prod' => [
            'DB_HOST' => '127.0.0.1',
            'DB_PORT' => 3306,
            'DB_NAME' => '',
            'DB_USER' => '',
            'DB_PASS' => '',
        ],
    ];

    $cfg = $CONFIG[$ENV];

    /* ---------- Construcción de DSN ---------- */
    $dsn = sprintf(
        'mysql:host=%s;port=%d;dbname=%s;charset=utf8mb4',
        $cfg['DB_HOST'],
        (int)$cfg['DB_PORT'],
        $cfg['DB_NAME']
    );

    /* ---------- Atributos recomendados ---------- */
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION, // errores como excepciones
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,       // fetch asociativo
        PDO::ATTR_EMULATE_PREPARES   => false,                  // usa prepares nativos
        PDO::ATTR_PERSISTENT         => false,                  // NO conexión persistente
    ];

    try {
        $pdo = new PDO($dsn, $cfg['DB_USER'], $cfg['DB_PASS'], $options);

        // Opcional: fija zona horaria de la sesión SQL (Perú, UTC-5)
        $pdo->exec("SET time_zone = '-05:00'");

        // (Opcional) Si tuvieras problemas con ONLY_FULL_GROUP_BY en MySQL 8, descomenta:
        // $pdo->exec(\"SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''))\");

    } catch (PDOException $e) {
        // En local, mostrar mensaje ayuda a depurar. En prod, registra y muestra genérico.
        if ($ENV === 'local') {
            die('Error de conexión a la base de datos (local): ' . $e->getMessage());
        } else {
            error_log('DB ERROR: ' . $e->getMessage());
            die('Lo sentimos, ocurrió un problema técnico.');
        }
    }
}

/**
 * Helper opcional para obtener el PDO en otros archivos:
 *   $db = db();
 *   $stmt = $db->prepare('SELECT 1');
 */
if (!function_exists('db')) {
    function db(): PDO {
        global $pdo;
        return $pdo;
    }
}
