<?php
// Configurar zona horaria de PHP para Perú (UTC-5)
date_default_timezone_set('America/Lima');

/**
 * FILE: /digitalpremium/config/db_prod.php
 * Conexión PDO — Entorno PRODUCCIÓN (Hosting)
 *
 * Configuración específica para el hosting digitalpremiumtv.com
 */

if (!isset($pdo) || !($pdo instanceof PDO)) {

    /* ---------- Configuración de PRODUCCIÓN ---------- */
    $CONFIG = [
        'DB_HOST' => 'localhost',   // Usar 'localhost' en hosting
        'DB_PORT' => 3306,
        'DB_NAME' => 'kreativo_digitalpremium', // Nombre de tu BD en el hosting
        'DB_USER' => 'kreativo_digitalpremium',       // CAMBIAR por tu usuario de BD del hosting
        'DB_PASS' => 'Paranormal#2808',      // CAMBIAR por tu password de BD del hosting
    ];

    /* ---------- Construcción de DSN ---------- */
    $dsn = sprintf(
        'mysql:host=%s;port=%d;dbname=%s;charset=utf8mb4',
        $CONFIG['DB_HOST'],
        (int)$CONFIG['DB_PORT'],
        $CONFIG['DB_NAME']
    );

    /* ---------- Atributos recomendados para producción ---------- */
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
        PDO::ATTR_PERSISTENT         => false,
    ];

    try {
        $pdo = new PDO($dsn, $CONFIG['DB_USER'], $CONFIG['DB_PASS'], $options);

        // Fija zona horaria de la sesión SQL (Perú, UTC-5)
        $pdo->exec("SET time_zone = '-05:00'");

    } catch (PDOException $e) {
        // En producción, solo registrar el error y mostrar mensaje genérico
        error_log('DB ERROR: ' . $e->getMessage());
        die('Lo sentimos, ocurrió un problema técnico. Por favor, inténtelo más tarde.');
    }
}

/**
 * Helper para obtener el PDO en otros archivos
 */
if (!function_exists('db')) {
    function db(): PDO {
        global $pdo;
        return $pdo;
    }
}
