<?php
// /config/functions.php

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

/**
 * Obtiene un valor de configuración específico para un usuario desde la base de datos.
 * Primero busca una configuración para el usuario, si no la encuentra, busca una global (id_usuario IS NULL).
 *
 * @param string $key La clave de la configuración que se quiere obtener (ej. 'moneda_simbolo').
 * @param int $id_usuario El ID del usuario para el que se busca la configuración.
 * @param mixed $default El valor a devolver si no se encuentra la clave.
 * @return mixed El valor de la configuración o el valor por defecto.
 */
function getConfigValue($key, $id_usuario, $default = null) {
    global $pdo; // Usa la conexión a la base de datos que ya está definida en db.php

    try {
        // 1. Intenta obtener la configuración específica del usuario
        $stmt = $pdo->prepare("SELECT valor_config FROM configuraciones WHERE clave_config = :key AND id_usuario = :id_usuario");
        $stmt->execute([':key' => $key, ':id_usuario' => $id_usuario]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            return $result['valor_config'];
        }

        // 2. Si no hay específica, busca la configuración global (para administradores o por defecto)
        $stmt = $pdo->prepare("SELECT valor_config FROM configuraciones WHERE clave_config = :key AND id_usuario IS NULL");
        $stmt->execute([':key' => $key]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            return $result['valor_config'];
        }

    } catch (PDOException $e) {
        // En caso de error de base de datos, lo registra y devuelve el valor por defecto
        error_log("Error en getConfigValue(): " . $e->getMessage());
        return $default;
    }

    // 3. Si no encuentra ninguna de las dos, devuelve el valor por defecto
    return $default;
}

// Aquí puedes añadir más funciones que uses en varias partes de tu sitio en el futuro.