<?php
/**
 * Script de debug final para identificar el problema exacto en dashboard2
 */

echo "<h2>🔍 Debug Final - Dashboard2</h2>";

// Simular el problema exacto
echo "<h3>📋 Simulación del Problema</h3>";

// Simular diferentes escenarios de filtros
$test_scenarios = [
    'filtro_email_simple' => [
        'GET' => ['search_query_profit' => 'test@example.com'],
        'rol_usuario_sesion' => 'admin',
        'id_usuario_sesion' => 1
    ],
    'filtro_email_con_plataforma' => [
        'GET' => [
            'search_query_profit' => 'netflix@example.com',
            'filtro_plataforma_profit' => '1'
        ],
        'rol_usuario_sesion' => 'admin',
        'id_usuario_sesion' => 1
    ],
    'filtro_email_con_estado' => [
        'GET' => [
            'search_query_profit' => 'test@example.com',
            'filtro_estado_profit' => '1'
        ],
        'rol_usuario_sesion' => 'admin',
        'id_usuario_sesion' => 1
    ]
];

foreach ($test_scenarios as $nombre => $scenario) {
    echo "<h4>🔍 Escenario: $nombre</h4>";
    
    // Simular la lógica exacta de dashboard2
    $cm_profit_where_clauses = [];
    $cm_profit_params = [];
    
    // Siempre agregar el filtro de usuario si no es superadmin
    if ($scenario['rol_usuario_sesion'] !== 'superadmin') {
        $cm_profit_where_clauses[] = "cm.id_usuario = :id_usuario_sesion";
        $cm_profit_params[':id_usuario_sesion'] = $scenario['id_usuario_sesion'];
    }
    
    // Add optional filters from GET parameters for profitability section
    if (!empty($scenario['GET']['filtro_plataforma_profit'])) { 
        $cm_profit_where_clauses[] = "p.id_plataforma = :id_plataforma_profit"; 
        $cm_profit_params[':id_plataforma_profit'] = $scenario['GET']['filtro_plataforma_profit']; 
    }
    if (isset($scenario['GET']['filtro_estado_profit']) && ($scenario['GET']['filtro_estado_profit'] !== '')) { 
        $cm_profit_where_clauses[] = "cm.estado_cuenta = :estado_cuenta_profit"; 
        $cm_profit_params[':estado_cuenta_profit'] = $scenario['GET']['filtro_estado_profit']; 
    }
    if (($scenario['GET']['filtro_perfiles_disponibles_profit'] ?? '') === 'si') { 
        $cm_profit_where_clauses[] = "cm.perfiles_disponibles > 0"; 
    }
    if (!empty($scenario['GET']['search_query_profit'])) {
        $search_query_param_profit = '%' . trim($scenario['GET']['search_query_profit']) . '%';
        // Qualified all ambiguous columns in the search query.
        $cm_profit_where_clauses[] = "(cm.email_cuenta LIKE :search_query_profit OR cm.nombre_proveedor LIKE :search_query_profit OR p.nombre_plataforma LIKE :search_query_profit OR pv.nombre_perfil_cliente LIKE :search_query_profit_pv OR c.nombre_completo LIKE :search_query_profit_c)";
        $cm_profit_params[':search_query_profit'] = $search_query_param_profit;
        $cm_profit_params[':search_query_profit_pv'] = $search_query_param_profit;
        $cm_profit_params[':search_query_profit_c'] = $search_query_param_profit;
    }
    
    echo "<p><strong>Después de agregar filtros:</strong></p>";
    echo "<p>Cláusulas WHERE: " . json_encode($cm_profit_where_clauses) . "</p>";
    echo "<p>Parámetros: " . json_encode($cm_profit_params) . "</p>";
    
    // Verificar que siempre haya parámetros válidos
    if (empty($cm_profit_params)) {
        $cm_profit_params = [];
    }
    
    // Verificar que no haya cláusulas WHERE sin parámetros correspondientes
    if (empty($cm_profit_params) && !empty($cm_profit_where_clauses)) {
        echo "<p style='color: red;'><strong>⚠️ PROBLEMA DETECTADO:</strong> Hay cláusulas WHERE pero no hay parámetros</p>";
        $cm_profit_where_clauses = [];
        $cm_profit_sql_where = "";
        echo "<p><strong>✅ CORREGIDO:</strong> Cláusulas WHERE limpiadas</p>";
    }
    
    // Verificar que todas las cláusulas WHERE tengan parámetros correspondientes
    $clauses_without_params = [];
    foreach ($cm_profit_where_clauses as $clause) {
        if (strpos($clause, ':') !== false) {
            preg_match_all('/:([a-zA-Z_][a-zA-Z0-9_]*)/', $clause, $matches);
            foreach ($matches[1] as $param_name) {
                $full_param = ':' . $param_name;
                if (!isset($cm_profit_params[$full_param])) {
                    $clauses_without_params[] = $clause;
                    break;
                }
            }
        }
    }
    
    // Si hay cláusulas sin parámetros, limpiarlas
    if (!empty($clauses_without_params)) {
        echo "<p style='color: orange;'><strong>⚠️ PROBLEMA DETECTADO:</strong> Hay cláusulas WHERE sin parámetros correspondientes</p>";
        echo "<p>Cláusulas problemáticas: " . json_encode($clauses_without_params) . "</p>";
        $cm_profit_where_clauses = array_filter($cm_profit_where_clauses, function($clause) use ($clauses_without_params) {
            return !in_array($clause, $clauses_without_params);
        });
        echo "<p><strong>✅ CORREGIDO:</strong> Cláusulas problemáticas eliminadas</p>";
    }
    
    $cm_profit_sql_where = !empty($cm_profit_where_clauses) ? " WHERE " . implode(" AND ", $cm_profit_where_clauses) : "";
    
    echo "<p><strong>Resultado final:</strong></p>";
    echo "<p>Cláusulas WHERE: " . json_encode($cm_profit_where_clauses) . "</p>";
    echo "<p>Parámetros: " . json_encode($cm_profit_params) . "</p>";
    echo "<p>SQL WHERE: " . $cm_profit_sql_where . "</p>";
    
    // Simular la consulta SQL
    $sql_master_account_profitability = "
        SELECT
            cm.id_cuenta_maestra, cm.email_cuenta, cm.costo_compra, cm.perfiles_total, cm.perfiles_disponibles,
            cm.estado_cuenta, cm.fecha_vencimiento_proveedor, cm.nombre_proveedor,
            p.id_plataforma, p.nombre_plataforma, p.max_perfiles_cuenta,
            COALESCE(SUM(pv.precio_venta), 0) AS total_revenue_generated,
            DATEDIFF(cm.fecha_vencimiento_proveedor, CURDATE()) as dias_restantes_cm,
            GROUP_CONCAT(
                DISTINCT
                CASE WHEN pv.estado_suscripcion != 2 THEN
                    CONCAT_WS('|',
                        pv.id_perfil_vendido,
                        pv.nombre_perfil_cliente,
                        COALESCE(pv.pin_perfil_cliente, ''),
                        pv.fecha_inicio_servicio,
                        pv.fecha_fin_servicio,
                        pv.precio_venta,
                        pv.estado_suscripcion,
                        c.nombre_completo,
                        COALESCE(c.telefono, '')
                    )
                ELSE NULL END
                ORDER BY pv.nombre_perfil_cliente ASC SEPARATOR '###'
            ) AS perfiles_data
        FROM
            cuentas_maestras cm
        JOIN
            plataformas p ON cm.id_plataforma = p.id_plataforma
        LEFT JOIN
            perfiles_vendidos pv ON cm.id_cuenta_maestra = pv.id_cuenta_maestra
        LEFT JOIN
            clientes c ON pv.id_cliente = c.id_cliente
        {$cm_profit_sql_where}
        GROUP BY
            cm.id_cuenta_maestra, cm.email_cuenta, cm.costo_compra, cm.perfiles_total, cm.perfiles_disponibles,
            cm.estado_cuenta, cm.fecha_vencimiento_proveedor, cm.nombre_proveedor, p.id_plataforma, p.nombre_plataforma, p.max_perfiles_cuenta
        ORDER BY
            total_revenue_generated DESC, cm.perfiles_disponibles DESC
    ";
    
    echo "<p><strong>SQL completo:</strong></p>";
    echo "<pre style='background-color: #f8f9fa; padding: 10px; border-radius: 5px; font-size: 12px;'>" . htmlspecialchars($sql_master_account_profitability) . "</pre>";
    
    // Verificar consistencia final
    $errores = [];
    foreach ($cm_profit_where_clauses as $clause) {
        if (strpos($clause, ':') !== false) {
            preg_match_all('/:([a-zA-Z_][a-zA-Z0-9_]*)/', $clause, $matches);
            foreach ($matches[1] as $param_name) {
                $full_param = ':' . $param_name;
                if (!isset($cm_profit_params[$full_param])) {
                    $errores[] = "Parámetro faltante: $full_param en cláusula: $clause";
                }
            }
        }
    }
    
    if (!empty($errores)) {
        echo "<div style='background-color: #f8d7da; padding: 10px; border-radius: 5px; margin: 10px 0; border: 1px solid #f5c6cb;'>";
        echo "<strong>❌ Errores detectados:</strong><br>";
        foreach ($errores as $error) {
            echo "- $error<br>";
        }
        echo "</div>";
    } else {
        echo "<div style='background-color: #d4edda; padding: 10px; border-radius: 5px; margin: 10px 0; border: 1px solid #c3e6cb;'>";
        echo "<strong>✅ Sin errores detectados</strong>";
        echo "</div>";
    }
    
    echo "<hr>";
}

echo "<h3>🎯 Análisis del Problema</h3>";
echo "<div style='background-color: #fff3cd; padding: 15px; border-radius: 8px; margin: 15px 0; border: 1px solid #ffeaa7;'>";
echo "<h4>🔍 Posibles causas del error:</h4>";
echo "<ol>";
echo "<li><strong>Parámetros duplicados:</strong> El mismo parámetro se está agregando múltiples veces</li>";
echo "<li><strong>Cláusulas WHERE inconsistentes:</strong> Cláusulas que se agregan pero no tienen parámetros</li>";
echo "<li><strong>Problema en la lógica de filtros:</strong> Los filtros se están aplicando incorrectamente</li>";
echo "<li><strong>Conflicto entre filtros:</strong> Los filtros se están sobrescribiendo entre sí</li>";
echo "</ol>";
echo "</div>";

echo "<p><a href='pages/dashboard2.php' class='btn btn-primary'>🚀 Ir a Dashboard2</a></p>";
?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; }
.btn { display: inline-block; padding: 8px 16px; text-decoration: none; border-radius: 4px; margin: 5px; background-color: #007bff; color: white; }
pre { white-space: pre-wrap; word-wrap: break-word; }
</style>
