<?php
// Script de debug específico para verificar filtros en la página real
// Agregar ?debug=1 a la URL de perfiles_vendidos.php

echo "<h2>🔍 Debug de Filtros en Página Real</h2>";

// Simular exactamente lo que pasa en la página
$_GET = [
    'buscar' => 'Netflix',
    'filtro_estado' => '1',
    'mensaje' => 'Suscripción renovada exitosamente.'
];

echo "<h3>📋 Parámetros GET Simulados:</h3>";
echo "<pre>" . print_r($_GET, true) . "</pre>";

// Simular la lógica exacta de la página
$where_clauses_pv = [];
$params_pv = [];
$filtros_aplicados_pv = false;

echo "<h3>🔧 Aplicando Filtros:</h3>";

// Filtro de búsqueda
if (!empty($_GET['buscar'])) {
    $buscar_param = '%' . trim($_GET['buscar']) . '%';
    $where_clauses_pv[] = "(c.nombre_completo LIKE :buscar_cliente OR p.nombre_plataforma LIKE :buscar_plataforma OR cm.email_cuenta LIKE :buscar_email OR pv.nombre_perfil_cliente LIKE :buscar_perfil OR c.telefono LIKE :buscar_telefono)";
    $params_pv[':buscar_cliente'] = $buscar_param;
    $params_pv[':buscar_plataforma'] = $buscar_param;
    $params_pv[':buscar_email'] = $buscar_param;
    $params_pv[':buscar_perfil'] = $buscar_param;
    $params_pv[':buscar_telefono'] = $buscar_param;
    $filtros_aplicados_pv = true;
    echo "✅ <strong>buscar:</strong> '$buscar_param' → Filtro aplicado<br>";
} else {
    echo "❌ <strong>buscar:</strong> No hay valor<br>";
}

// Filtro de estado
if (isset($_GET['filtro_estado']) && $_GET['filtro_estado'] !== '') {
    $where_clauses_pv[] = "pv.estado_suscripcion = :estado_suscripcion";
    $params_pv[':estado_suscripcion'] = $_GET['filtro_estado'];
    $filtros_aplicados_pv = true;
    echo "✅ <strong>filtro_estado:</strong> '{$_GET['filtro_estado']}' → Filtro aplicado<br>";
} else {
    $where_clauses_pv[] = "pv.estado_suscripcion != 2";
    echo "ℹ️ <strong>filtro_estado:</strong> Valor por defecto aplicado<br>";
}

// Construir SQL WHERE
$sql_where_pv = $where_clauses_pv ? ' WHERE ' . implode(' AND ', $where_clauses_pv) : '';

echo "<h3>📊 Estado Final:</h3>";
echo "<ul>";
echo "<li><strong>Filtros aplicados:</strong> " . ($filtros_aplicados_pv ? 'SÍ' : 'NO') . "</li>";
echo "<li><strong>Cláusulas WHERE:</strong> " . count($where_clauses_pv) . "</li>";
echo "<li><strong>Parámetros SQL:</strong> " . count($params_pv) . "</li>";
echo "</ul>";

echo "<h3>📝 Cláusulas WHERE Generadas:</h3>";
if (!empty($where_clauses_pv)) {
    echo "<pre>" . implode(" AND ", $where_clauses_pv) . "</pre>";
} else {
    echo "<em>No hay cláusulas WHERE</em>";
}

echo "<h3>🔑 Parámetros Preparados:</h3>";
if (!empty($params_pv)) {
    echo "<pre>" . print_r($params_pv, true) . "</pre>";
} else {
    echo "<em>No hay parámetros</em>";
}

echo "<h3>🌐 SQL WHERE Final:</h3>";
echo "<pre><code>" . htmlspecialchars($sql_where_pv) . "</code></pre>";

echo "<h3>🎯 Verificación:</h3>";
if ($filtros_aplicados_pv) {
    echo "🎉 <strong>ÉXITO: Los filtros se están aplicando correctamente</strong><br>";
    echo "La consulta SQL incluye las cláusulas WHERE necesarias.";
} else {
    echo "❌ <strong>ERROR: Los filtros NO se están aplicando</strong><br>";
    echo "Revisar la lógica de filtrado.";
}

echo "<br><br><strong>Para probar en la página real:</strong>";
echo "<br>1. Ve a perfiles_vendidos.php";
echo "<br>2. Aplica filtros (ej: buscar 'Netflix')";
echo "<br>3. Edita o renueva un perfil";
echo "<br>4. Agrega <code>&debug=1</code> a la URL";
echo "<br>5. Verifica que los filtros se mantengan";
?>
