<?php
/**
 * SCRIPT DE DIAGNÓSTICO DE BASE DE DATOS
 * Ejecutar desde línea de comandos: php diagnostico_bd.php
 */

// Configuración de la base de datos
$host = '127.0.0.1';
$port = 3306;
$dbname = 'digitalpremiumnueva';
$username = 'root';
$password = '';

echo "🔍 DIAGNÓSTICO DE BASE DE DATOS: $dbname\n";
echo "==========================================\n\n";

try {
    // Conexión a la base de datos
    $dsn = "mysql:host=$host;port=$port;dbname=$dbname;charset=utf8mb4";
    $pdo = new PDO($dsn, $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "✅ Conexión exitosa a la base de datos\n\n";
    
    // 1. LISTAR TODAS LAS TABLAS
    echo "📋 TABLAS EXISTENTES:\n";
    echo "----------------------\n";
    $stmt = $pdo->query("SHOW TABLES");
    $tablas = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    if (empty($tablas)) {
        echo "❌ No hay tablas en la base de datos\n\n";
    } else {
        foreach ($tablas as $tabla) {
            echo "• $tabla\n";
        }
        echo "\n";
    }
    
    // 2. VERIFICAR TABLA USUARIOS
    echo "👥 VERIFICACIÓN TABLA USUARIOS:\n";
    echo "-------------------------------\n";
    
    if (in_array('usuarios', $tablas)) {
        echo "✅ Tabla 'usuarios' existe\n";
        
        // Verificar estructura
        $stmt = $pdo->query("DESCRIBE usuarios");
        $columnas = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "📊 Estructura de la tabla:\n";
        foreach ($columnas as $col) {
            echo "  • {$col['Field']} - {$col['Type']} - {$col['Null']} - {$col['Key']} - {$col['Default']}\n";
        }
        
        // Verificar si hay usuarios
        $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios");
        $total_usuarios = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
        echo "\n👤 Total de usuarios: $total_usuarios\n";
        
        if ($total_usuarios > 0) {
            echo "📋 Usuarios existentes:\n";
            $stmt = $pdo->query("SELECT id_usuario, username, rol, estado, nombre_completo FROM usuarios ORDER BY id_usuario");
            $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            foreach ($usuarios as $user) {
                $estado = $user['estado'] ? '✅ Activo' : '❌ Inactivo';
                echo "  • ID: {$user['id_usuario']} | Username: {$user['username']} | Rol: {$user['rol']} | Estado: $estado | Nombre: {$user['nombre_completo']}\n";
            }
        }
        
    } else {
        echo "❌ Tabla 'usuarios' NO existe\n";
    }
    
    echo "\n";
    
    // 3. VERIFICAR TABLA AUDITORIA_ACCIONES
    echo "📝 VERIFICACIÓN TABLA AUDITORIA_ACCIONES:\n";
    echo "----------------------------------------\n";
    
    if (in_array('auditoria_acciones', $tablas)) {
        echo "✅ Tabla 'auditoria_acciones' existe\n";
        
        // Verificar estructura
        $stmt = $pdo->query("DESCRIBE auditoria_acciones");
        $columnas = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "📊 Estructura de la tabla:\n";
        foreach ($columnas as $col) {
            echo "  • {$col['Field']} - {$col['Type']} - {$col['Null']} - {$col['Key']} - {$col['Default']}\n";
        }
        
    } else {
        echo "❌ Tabla 'auditoria_acciones' NO existe\n";
    }
    
    echo "\n";
    
    // 4. VERIFICAR TABLA CONFIGURACIONES
    echo "⚙️ VERIFICACIÓN TABLA CONFIGURACIONES:\n";
    echo "-------------------------------------\n";
    
    if (in_array('configuraciones', $tablas)) {
        echo "✅ Tabla 'configuraciones' existe\n";
        
        // Verificar estructura
        $stmt = $pdo->query("DESCRIBE configuraciones");
        $columnas = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "📊 Estructura de la tabla:\n";
        foreach ($columnas as $col) {
            echo "  • {$col['Field']} - {$col['Type']} - {$col['Null']} - {$col['Key']} - {$col['Default']}\n";
        }
        
    } else {
        echo "❌ Tabla 'configuraciones' NO existe\n";
    }
    
    echo "\n";
    
    // 5. VERIFICAR CONEXIÓN DESDE CONFIG/DB.PHP
    echo "🔧 VERIFICACIÓN CONFIG/DB.PHP:\n";
    echo "-------------------------------\n";
    
    // Simular la conexión desde config/db.php
    try {
        // Incluir el archivo de configuración
        if (file_exists('config/db.php')) {
            echo "✅ Archivo config/db.php existe\n";
            
            // Crear una conexión de prueba
            $pdo_test = new PDO($dsn, $username, $password);
            $pdo_test->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Probar consulta simple
            $stmt = $pdo_test->query("SELECT 1 as test");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($result && $result['test'] == 1) {
                echo "✅ Conexión desde config/db.php funciona correctamente\n";
            } else {
                echo "❌ Conexión desde config/db.php falló\n";
            }
            
        } else {
            echo "❌ Archivo config/db.php NO existe\n";
        }
        
    } catch (Exception $e) {
        echo "❌ Error en config/db.php: " . $e->getMessage() . "\n";
    }
    
    echo "\n";
    
    // 6. RECOMENDACIONES
    echo "💡 RECOMENDACIONES:\n";
    echo "-------------------\n";
    
    if (!in_array('usuarios', $tablas)) {
        echo "• Crear la tabla 'usuarios' con la estructura correcta\n";
    }
    
    if (!in_array('auditoria_acciones', $tablas)) {
        echo "• Crear la tabla 'auditoria_acciones' para el sistema de auditoría\n";
    }
    
    if (!in_array('configuraciones', $tablas)) {
        echo "• Crear la tabla 'configuraciones' para las configuraciones del sistema\n";
    }
    
    if (in_array('usuarios', $tablas)) {
        $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios WHERE rol = 'superadmin' AND estado = 1");
        $superadmins = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
        
        if ($superadmins == 0) {
            echo "• Crear al menos un usuario con rol 'superadmin' y estado activo\n";
        }
    }
    
    echo "\n";
    
} catch (PDOException $e) {
    echo "❌ ERROR DE CONEXIÓN: " . $e->getMessage() . "\n";
    echo "\n💡 VERIFICAR:\n";
    echo "• Que XAMPP esté ejecutándose\n";
    echo "• Que MySQL esté activo en el puerto 3306\n";
    echo "• Que la base de datos 'digitalpremiumnueva' exista\n";
    echo "• Que el usuario 'root' tenga permisos\n";
} catch (Exception $e) {
    echo "❌ ERROR GENERAL: " . $e->getMessage() . "\n";
}

echo "\n🔍 DIAGNÓSTICO COMPLETADO\n";
echo "==========================\n";
?>
