<?php
/**
 * /includes/header.php (VERSIÓN FINAL CON CONSULTA DIRECTA A LA BD Y SOPORTE SELECT2)
 */

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Cargar la base de datos es ahora el primer paso crítico.
require_once __DIR__ . '/../config/db.php';

// --- INICIO: LÓGICA DE SEGURIDAD MEJORADA ---
$dias_restantes = null;
$nombre_negocio_global = 'DigitalPremium'; 

if (isset($_SESSION['id_usuario'])) {
    $id_usuario_actual = $_SESSION['id_usuario'];
    $rol_usuario = $_SESSION['rol'] ?? 'usuario';

    // El Super Admin siempre tiene acceso ilimitado.
    if ($rol_usuario !== 'superadmin') {
        
        // **MEJORA CRUCIAL: Se consulta la BD en cada carga para tener la fecha más reciente**
        $stmt = $pdo->prepare("SELECT fecha_fin_membresia FROM usuarios WHERE id_usuario = ?");
        $stmt->execute([$id_usuario_actual]);
        $fecha_fin_db = $stmt->fetchColumn();

        if (!empty($fecha_fin_db)) {
            try {
                $zona_horaria = new DateTimeZone('America/Lima');
                $fecha_fin = new DateTime($fecha_fin_db, $zona_horaria);
                $hoy = new DateTime('now', $zona_horaria);

                // LÓGICA DE BLOQUEO: Solo bloquea si la fecha de hoy es ESTRICTAMENTE MAYOR a la de fin.
                if ($hoy->format('Y-m-d') > $fecha_fin->format('Y-m-d')) {
                    // Si ya venció, se bloquea y redirige.
                    if (basename($_SERVER['PHP_SELF']) !== 'membresia_expirada.php') {
                        header("Location: /digitalpremium/pages/membresia_expirada.php");
                        exit();
                    }
                } else {
                    // Si aún no vence, se calcula los días restantes para el aviso.
                    $diff = $hoy->diff($fecha_fin);
                    $dias_restantes = (int)$diff->format('%a');
                }
            } catch (Exception $e) {
                error_log('Error en header.php al procesar fecha: ' . $e->getMessage());
            }
        } else {
            // Si es un usuario normal y no tiene fecha en la BD, se bloquea.
            if (basename($_SERVER['PHP_SELF']) !== 'membresia_expirada.php') {
                header("Location: /digitalpremium/pages/membresia_expirada.php");
                exit();
            }
        }
    }
    
    // Se obtiene el nombre del negocio
    if (function_exists('getConfigValue')) {
        $nombre_negocio_global = getConfigValue('nombre_negocio', $id_usuario_actual, 'DigitalPremium');
    }
} else {
    // Si no hay sesión y no estamos en login, redirigir
    if (basename($_SERVER['PHP_SELF']) !== 'login.php') {
        header("Location: /digitalpremium/login.php");
        exit();
    }
}

// Se prepara el título de la página
$page_title_final = isset($page_title) ? htmlspecialchars($page_title) . ' - ' . htmlspecialchars($nombre_negocio_global) : htmlspecialchars($nombre_negocio_global);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <title><?php echo $page_title_final; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&family=Titillium+Web:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <style>
    .select2-container .select2-selection--single {
        height: calc(1.5em + 1.5rem + 2px) !important;
        padding: 0.75rem 1rem;
        font-size: 1rem;
        line-height: 1.5;
        border-radius: 0.25rem;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: calc(1.5em + 1.5rem + 2px) !important;
        top: 1px !important;
    }
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 1.5 !important;
        padding-left: 0 !important;
        color: #495057 !important;
    }
    .select2-container--default .select2-selection--single {
        border: 1px solid #ced4da !important;
    }
    .select2-container--default .select2-selection--single:focus {
        border-color: #80bdff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }
    </style>
    
    <link rel="stylesheet" href="/digitalpremium/css/style.css"> 
    <script src="/digitalpremium/js/script.js"></script>
</head>
<body>

    <nav class="mobile-top-navbar d-lg-none">
        <button class="sidebar-toggle-btn-mobile" type="button" id="sidebarToggleBtnMobile" aria-label="Toggle navigation">
            <i class="fas fa-bars"></i>
        </button>
        <a href="/digitalpremium/index.php" class="mobile-navbar-brand">
            <i class="fas fa-compact-disc"></i> <?php echo htmlspecialchars($nombre_negocio_global); ?>
        </a>
        <div style="width: 40px;"></div> 
    </nav>
    
<?php
$current_page_basename = basename($_SERVER['PHP_SELF']);
if (!in_array($current_page_basename, ['login.php', 'membresia_expirada.php'])) :
?>
    <?php include_once 'sidebar.php'; ?>
    <div class="main-content">
        <div class="container-fluid px-lg-4 px-3 py-3">
            
            <?php
            // Este aviso se muestra solo si quedan 7 días o menos, pero la cuenta AÚN NO ha vencido.
            if ($dias_restantes !== null && $dias_restantes <= 7) {
                echo '
                <div class="alert alert-warning d-flex align-items-center shadow-sm mb-4" role="alert">
                    <i class="fas fa-exclamation-triangle fa-2x me-3"></i>
                    <div>
                        <strong>¡Atención!</strong> Tu membresía está por vencer. Te quedan solo <strong>' . $dias_restantes . ' día(s)</strong> para renovar y continuar usando el sistema sin interrupciones.
                    </div>
                </div>';
            }
            ?>
            <?php endif; ?>