<?php
// /digitalpremium/includes/tenant_helper.php
if (!function_exists('get_data_owner_id')) {
    /**
     * Devuelve el id del "dueño de la data" (primer superadmin activo).
     * Se cachea en sesión para no consultar siempre.
     */
    function get_data_owner_id(PDO $pdo): int {
        if (!empty($_SESSION['data_owner_id'])) {
            return (int)$_SESSION['data_owner_id'];
        }

        // 1) Primer superadmin activo
        $id = (int)$pdo->query("SELECT id_usuario FROM usuarios WHERE rol='superadmin' AND estado=1 ORDER BY id_usuario ASC LIMIT 1")->fetchColumn();

        // 2) Fallback: primer usuario
        if ($id <= 0) {
            $id = (int)$pdo->query("SELECT id_usuario FROM usuarios ORDER BY id_usuario ASC LIMIT 1")->fetchColumn();
        }

        // 3) Último fallback: el de la sesión
        if ($id <= 0 && isset($_SESSION['id_usuario'])) {
            $id = (int)$_SESSION['id_usuario'];
        }

        $_SESSION['data_owner_id'] = $id ?: 1;
        return $_SESSION['data_owner_id'];
    }
}
