<?php
// FILE: /digitalpremium/index.php
declare(strict_types=1);
if (session_status() === PHP_SESSION_NONE) session_start();

/* Evita cachear la redirección */
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

/* 1) Verifica sesión */
if (!isset($_SESSION['id_usuario'])) {
    header("Location: /digitalpremium/login.php");
    exit();
}

/* 2) Redirección por rol */
$rol = $_SESSION['rol'] ?? 'admin';

$pathDashboard = '/digitalpremium/pages/dashboard.php';
$pathPerfiles  = '/digitalpremium/pages/perfiles_vendidos.php';

switch ($rol) {
    case 'ventas':
    case 'cortes':
        $target = $pathPerfiles;
        break;
    case 'super_admin':
    case 'admin':
    default:
        $target = $pathDashboard;
        break;
}

/* 3) Redirige */
header("Location: {$target}");
exit;
