<?php
/**
 * INSPECCIÓN DETALLADA DE LA TABLA cuentas_maestras
 * Ejecutar: php inspeccion_cuentas_maestras.php
 */

$configs = [
	['name' => 'ANTIGUA', 'dbname' => 'digitalpremium'],
	['name' => 'NUEVA',   'dbname' => 'digitalpremiumnueva'],
];

$host = '127.0.0.1';
$port = 3306;
$username = 'root';
$password = '';

function println($msg = '') { echo $msg . "\n"; }

function checkColumnExists(array $columns, string $columnName): bool {
	foreach ($columns as $c) {
		if (isset($c['Field']) && $c['Field'] === $columnName) return true;
	}
	return false;
}

println("🔍 INSPECCIÓN DE TABLA: cuentas_maestras");
println("=======================================\n");

foreach ($configs as $cfg) {
	try {
		$dsn = "mysql:host={$GLOBALS['host']};port={$GLOBALS['port']};dbname={$cfg['dbname']};charset=utf8mb4";
		$pdo = new PDO($dsn, $GLOBALS['username'], $GLOBALS['password']);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		
		println("📦 Base de datos ({$cfg['name']}): {$cfg['dbname']}");
		println(str_repeat('-', 60));
		
		// ¿Existe la tabla?
		$stmt = $pdo->query("SHOW TABLES LIKE 'cuentas_maestras'");
		if ($stmt->rowCount() === 0) {
			println("❌ La tabla 'cuentas_maestras' NO existe en {$cfg['dbname']}\n");
			continue;
		}
		println("✅ La tabla 'cuentas_maestras' existe");
		
		// Estructura de la tabla
		println("\n📊 Estructura:");
		$columns = $pdo->query("DESCRIBE cuentas_maestras")->fetchAll(PDO::FETCH_ASSOC);
		foreach ($columns as $col) {
			println("  • {$col['Field']} - {$col['Type']} - {$col['Null']} - {$col['Key']} - " . ($col['Default'] === null ? 'NULL' : $col['Default']));
		}
		
		// Índices
		println("\n🔑 Índices:");
		$indexes = $pdo->query("SHOW INDEX FROM cuentas_maestras")->fetchAll(PDO::FETCH_ASSOC);
		if (empty($indexes)) {
			println("  • (Sin índices)");
		} else {
			foreach ($indexes as $idx) {
				println("  • {$idx['Key_name']} (" . ($idx['Non_unique'] == 0 ? 'UNIQUE' : 'NON-UNIQUE') . ") -> Columna: {$idx['Column_name']}");
			}
		}
		
		// Conteo total
		$total = (int)$pdo->query("SELECT COUNT(*) AS c FROM cuentas_maestras")->fetch(PDO::FETCH_ASSOC)['c'];
		println("\n🧮 Total de registros: {$total}");
		
		// Campos opcionales a verificar
		$hasId = checkColumnExists($columns, 'id_cuenta_maestra');
		$hasUsuario = checkColumnExists($columns, 'id_usuario');
		$hasPlataforma = checkColumnExists($columns, 'id_plataforma');
		$hasFechaCompra = checkColumnExists($columns, 'fecha_compra');
		$hasFechaVence = checkColumnExists($columns, 'fecha_vencimiento');
		
		// Rango de fechas si existen
		if ($hasFechaCompra) {
			$minmax = $pdo->query("SELECT MIN(fecha_compra) AS minc, MAX(fecha_compra) AS maxc FROM cuentas_maestras")->fetch(PDO::FETCH_ASSOC);
			println("📆 Rango fecha_compra: " . ($minmax['minc'] ?: 'N/A') . " → " . ($minmax['maxc'] ?: 'N/A'));
		}
		if ($hasFechaVence) {
			$minmax = $pdo->query("SELECT MIN(fecha_vencimiento) AS minv, MAX(fecha_vencimiento) AS maxv FROM cuentas_maestras")->fetch(PDO::FETCH_ASSOC);
			println("⏳ Rango fecha_vencimiento: " . ($minmax['minv'] ?: 'N/A') . " → " . ($minmax['maxv'] ?: 'N/A'));
		}
		
		// Validación FK id_plataforma
		if ($hasPlataforma) {
			println("\n🔗 Validación FK id_plataforma → plataformas.id_plataforma:");
			$sql = "SELECT COUNT(*) AS faltantes FROM cuentas_maestras cm LEFT JOIN plataformas p ON cm.id_plataforma = p.id_plataforma WHERE cm.id_plataforma IS NOT NULL AND p.id_plataforma IS NULL";
			$faltantes = (int)$pdo->query($sql)->fetch(PDO::FETCH_ASSOC)['faltantes'];
			println("  • Registros con plataforma inexistente: {$faltantes}");
			
			if ($faltantes > 0) {
				println("  • Top plataformas faltantes:");
				$sql = "SELECT cm.id_plataforma, COUNT(*) AS cnt FROM cuentas_maestras cm LEFT JOIN plataformas p ON cm.id_plataforma = p.id_plataforma WHERE cm.id_plataforma IS NOT NULL AND p.id_plataforma IS NULL GROUP BY cm.id_plataforma ORDER BY cnt DESC LIMIT 5";
				foreach ($pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC) as $r) {
					println("    - id_plataforma=" . ($r['id_plataforma'] === null ? 'NULL' : $r['id_plataforma']) . " | registros=" . $r['cnt']);
				}
			}
		}
		
		// Validación FK id_usuario
		if ($hasUsuario) {
			println("\n🔗 Validación FK id_usuario → usuarios.id_usuario:");
			$sql = "SELECT COUNT(*) AS faltantes FROM cuentas_maestras cm LEFT JOIN usuarios u ON cm.id_usuario = u.id_usuario WHERE cm.id_usuario IS NOT NULL AND u.id_usuario IS NULL";
			$faltantes = (int)$pdo->query($sql)->fetch(PDO::FETCH_ASSOC)['faltantes'];
			println("  • Registros con usuario inexistente: {$faltantes}");
		}
		
		// Muestra de registros
		println("\n🔎 Muestra de registros (hasta 5):");
		$order = $hasId ? 'ORDER BY id_cuenta_maestra' : '';
		$sample = $pdo->query("SELECT * FROM cuentas_maestras {$order} LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
		if (empty($sample)) {
			println("  • (Sin datos)");
		} else {
			foreach ($sample as $row) {
				println('  • ' . json_encode($row, JSON_UNESCAPED_UNICODE));
			}
		}
		
		println("\n");
	} catch (Throwable $e) {
		println("❌ Error inspeccionando {$cfg['dbname']}: " . $e->getMessage());
		println("");
	}
}

println("✅ INSPECCIÓN FINALIZADA");
?>
