// Funciones para el modal de notificación de cambios en cuentas maestras

// Función principal para mostrar el modal de notificación
function mostrarModalNotificacion(data) {
    const modal = document.getElementById('modalNotificacionCambios');
    if (!modal) return;

    // Llenar lista de cambios con emojis y mejor formato
    const listaCambios = document.getElementById('lista-cambios');
    if (listaCambios) {
        listaCambios.innerHTML = '';
        data.cambios_detectados.forEach(cambio => {
            const li = document.createElement('li');
            li.className = 'mb-2';
            li.innerHTML = `<span class="badge bg-warning text-dark me-2">${getEmojiCambio(cambio)}</span>${getDescripcionCambio(cambio, data)}`;
            listaCambios.appendChild(li);
        });
    }

    // Llenar tabla de clientes (vista escritorio)
    const tablaClientes = document.getElementById('tabla-clientes');
    if (tablaClientes) {
        tablaClientes.innerHTML = '';
        data.clientes_vinculados.forEach(cliente => {
            const tr = document.createElement('tr');
            tr.innerHTML = `
                <td>
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 40px; height: 40px;">
                            <span class="fw-bold">${cliente.nombre_completo.charAt(0).toUpperCase()}</span>
                        </div>
                        <div>
                            <div class="fw-bold text-primary">${cliente.nombre_completo}</div>
                            <small class="text-muted">${cliente.nombre_perfil_cliente}</small>
                        </div>
                    </div>
                </td>
                <td>
                    <div class="d-flex align-items-center gap-2">
                        <span class="fw-semibold">${cliente.telefono || 'N/A'}</span>
                        ${cliente.telefono ? `<button class="btn btn-sm btn-outline-secondary" onclick="copiarTelefono('${cliente.telefono}', this)" data-bs-toggle="tooltip" title="Copiar teléfono">
                            <i class="fas fa-copy"></i>
                        </button>` : ''}
                    </div>
                </td>
                <td><span class="badge bg-info fs-6">${cliente.nombre_perfil_cliente}</span></td>
                <td>
                    <span class="badge bg-${getVencimientoBadgeClass(cliente.fecha_fin_servicio)} fs-6">
                        ${formatearFecha(cliente.fecha_fin_servicio)}
                    </span>
                </td>
                <td>
                    <div class="d-flex gap-1 flex-wrap">
                        ${cliente.telefono ? `<button class="btn btn-sm btn-success" onclick="abrirWhatsApp('${cliente.telefono}', '${cliente.nombre_completo}')" title="Enviar WhatsApp">
                            <i class="fab fa-whatsapp"></i> WhatsApp
                        </button>` : ''}
                        <button class="btn btn-sm btn-outline-primary" onclick="copiarMensajeCliente('${cliente.nombre_completo}')" title="Copiar mensaje">
                            <i class="fas fa-copy"></i> Copiar
                        </button>
                    </div>
                </td>
            `;
            tablaClientes.appendChild(tr);
        });
    }

    // Llenar vista móvil
    const clientesMobile = document.getElementById('clientes-mobile');
    if (clientesMobile) {
        clientesMobile.innerHTML = '';
        data.clientes_vinculados.forEach(cliente => {
            const col = document.createElement('div');
            col.className = 'col-12';
            col.innerHTML = `
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="avatar-sm bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                <span class="fw-bold fs-5">${cliente.nombre_completo.charAt(0).toUpperCase()}</span>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-1 text-primary">${cliente.nombre_completo}</h6>
                                <p class="card-text text-muted mb-0">
                                    <i class="fas fa-tag me-1"></i>${cliente.nombre_perfil_cliente}
                                </p>
                            </div>
                        </div>
                        
                        <div class="row g-2 mb-3">
                            <div class="col-12">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-phone text-success me-2"></i>
                                        <span class="fw-semibold">${cliente.telefono || 'N/A'}</span>
                                    </div>
                                    ${cliente.telefono ? `
                                        <button class="btn btn-sm btn-outline-secondary" onclick="copiarTelefono('${cliente.telefono}', this)" data-bs-toggle="tooltip" title="Copiar teléfono">
                                            <i class="fas fa-copy"></i>
                                        </button>
                                    ` : ''}
                                </div>
                            </div>
                        </div>
                        
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="badge bg-${getVencimientoBadgeClass(cliente.fecha_fin_servicio)} fs-6">
                                <i class="fas fa-calendar me-1"></i>${formatearFecha(cliente.fecha_fin_servicio)}
                            </span>
                            ${cliente.telefono ? `
                                <button class="btn btn-sm btn-success" onclick="abrirWhatsApp('${cliente.telefono}', '${cliente.nombre_completo}')" title="Enviar WhatsApp">
                                    <i class="fab fa-whatsapp"></i> WhatsApp
                                </button>
                            ` : ''}
                        </div>
                        
                        <div class="d-grid">
                            <button class="btn btn-outline-primary btn-sm" onclick="copiarMensajeCliente('${cliente.nombre_completo}')" title="Copiar mensaje">
                                <i class="fas fa-copy me-1"></i>Copiar Mensaje
                            </button>
                        </div>
                    </div>
                </div>
            `;
            clientesMobile.appendChild(col);
        });
    }

    // Configurar eventos del modal
    configurarEventosModalNotificacion(data);

    // Detectar automáticamente el tipo de cambio principal y generar mensaje
    if (data.cambios_detectados && data.cambios_detectados.length > 0) {
        const cambioPrincipal = data.cambios_detectados[0]; // Tomar el primer cambio
        const selectTipoCambio = document.getElementById('tipo-cambio-select');
        if (selectTipoCambio) {
            selectTipoCambio.value = cambioPrincipal;
            // Generar mensaje automáticamente
            const mensaje = obtenerMensajePredefinido(cambioPrincipal, data);
            document.getElementById('mensaje-personalizado').value = mensaje;
        }
    }

    // Mostrar modal
    const modalInstance = new bootstrap.Modal(modal);
    modalInstance.show();
}

// Obtener emoji para el tipo de cambio
function getEmojiCambio(tipo) {
    const emojis = {
        'email': '📧',
        'password': '🔐',
        'correo_password': '🔑',
        'plataforma': '🖥️',
        'estado': '⚡',
        'general': '🔄'
    };
    return emojis[tipo] || '📝';
}

// Obtener descripción legible del tipo de cambio
function getDescripcionCambio(tipo, data) {
    const descripciones = {
        'email': `📧 Cambio de Email de la Cuenta 🔄
            <br><small class="text-muted">Se actualizó el email de acceso a la cuenta</small>`,
        'password': `🔐 Cambio de Contraseña de la Cuenta 🔒
            <br><small class="text-muted">Se generó una nueva contraseña por seguridad</small>`,
        'correo_password': `🔑 Cambio Completo de Credenciales 🔄
            <br><small class="text-muted">Se actualizaron tanto el email como la contraseña de la cuenta</small>`,
        'plataforma': `🖥️ Migración de Plataforma 🚀
            <br><small class="text-muted">${data.datos_cambios?.plataforma_anterior || 'anterior'} → ${data.datos_cambios?.plataforma_nueva || 'nueva'}</small>`,
        'estado': `⚡ Actualización de Estado de la Cuenta ✅
            <br><small class="text-muted">${data.datos_cambios?.estado_anterior || 'anterior'} → ${data.datos_cambios?.estado_nuevo || 'nuevo'}</small>`,
        'general': `🔄 Actualizaciones Generales en la Cuenta ✨
            <br><small class="text-muted">Mejoras y optimizaciones aplicadas</small>`
    };
    return descripciones[tipo] || '📝 Cambio en la Cuenta 🔧';
}

// Determinar la clase CSS del badge según la fecha de vencimiento
function getVencimientoBadgeClass(fecha) {
    if (!fecha) return 'secondary';
    const hoy = new Date();
    const vencimiento = new Date(fecha);
    const diffDias = Math.floor((vencimiento - hoy) / (1000 * 60 * 60 * 24));
    
    if (diffDias < 0) return 'danger';
    if (diffDias <= 7) return 'warning';
    return 'success';
}

// Formatear fecha en formato legible
function formatearFecha(fecha) {
    if (!fecha) return 'N/A';
    return new Date(fecha).toLocaleDateString('es-ES', {
        day: '2-digit',
        month: '2-digit',
        year: 'numeric'
    });
}

// Configurar todos los eventos del modal de notificación
function configurarEventosModalNotificacion(data) {
    // Botón cargar mensaje predefinido
    const btnCargarMensaje = document.getElementById('btn-cargar-mensaje');
    if (btnCargarMensaje) {
        btnCargarMensaje.onclick = () => {
            const tipoCambio = document.getElementById('tipo-cambio-select').value;
            const mensaje = obtenerMensajePredefinido(tipoCambio, data);
            document.getElementById('mensaje-personalizado').value = mensaje;
        };
    }

    // Botón copiar mensaje
    const btnCopiarMensaje = document.getElementById('btn-copiar-mensaje');
    if (btnCopiarMensaje) {
        btnCopiarMensaje.onclick = () => {
            const mensaje = document.getElementById('mensaje-personalizado').value;
            if (mensaje.trim()) {
                navigator.clipboard.writeText(mensaje).then(() => {
                    btnCopiarMensaje.innerHTML = '<i class="fas fa-check me-2"></i>Copiado';
                    setTimeout(() => {
                        btnCopiarMensaje.innerHTML = '<i class="fas fa-copy me-2"></i>📋 Copiar Mensaje';
                    }, 2000);
                });
            }
        };
    }

    // Botón enviar a todos
    const btnEnviarTodos = document.getElementById('btn-enviar-todos');
    if (btnEnviarTodos) {
        btnEnviarTodos.onclick = () => {
            const mensaje = document.getElementById('mensaje-personalizado').value;
            if (!mensaje.trim()) {
                mostrarAlerta('⚠️ Por favor, escribe un mensaje antes de enviar.', 'warning');
                return;
            }
            enviarMensajesATodos(data.clientes_vinculados, mensaje);
        };
    }

    // Botón vista previa
    const btnPreview = document.getElementById('btn-preview-mensaje');
    if (btnPreview) {
        btnPreview.onclick = () => {
            const mensaje = document.getElementById('mensaje-personalizado').value;
            if (!mensaje.trim()) {
                mostrarAlerta('⚠️ Por favor, escribe un mensaje antes de ver la vista previa.', 'warning');
                return;
            }
            mostrarVistaPrevia(mensaje, data.clientes_vinculados);
        };
    }

    // Cambio de tipo de cambio
    const selectTipoCambio = document.getElementById('tipo-cambio-select');
    if (selectTipoCambio) {
        selectTipoCambio.onchange = () => {
            const tipoCambio = selectTipoCambio.value;
            const mensaje = obtenerMensajePredefinido(tipoCambio, data);
            document.getElementById('mensaje-personalizado').value = mensaje;
        };
    }

    // Configurar evento para actualizar página al cerrar modal
    const modal = document.getElementById('modalNotificacionCambios');
    if (modal) {
        modal.addEventListener('hidden.bs.modal', () => {
            // Actualizar la página después de cerrar el modal
            setTimeout(() => {
                window.location.reload();
            }, 500);
        });
    }
}

// Obtener mensaje predefinido según el tipo de cambio
function obtenerMensajePredefinido(tipoCambio, data) {
    // Obtener los valores actuales de email y contraseña de la respuesta
    const emailActual = data.datos_cambios?.email_nuevo || data.datos_cambios?.email_actual || data.email || 'tu correo actual';
    const passwordActual = data.datos_cambios?.password_nueva || data.datos_cambios?.password_actual || 'tu contraseña actual';
    
    // Mensajes inteligentes con emojis basados en los datos reales de cambios
    const mensajes = {
        'email': `👋 ¡Hola {nombre_cliente}! 📧

🔒 Te informamos que hemos actualizado el email de tu cuenta ${data.plataforma || 'la plataforma'} por motivos de seguridad.

📝 El nuevo email es: ${emailActual}

⚠️ Por favor, actualiza tus credenciales de acceso lo antes posible.

💬 Si tienes alguna pregunta, no dudes en contactarnos. ¡Estamos aquí para ayudarte! 🚀`,
        
        'password': `👋 ¡Hola {nombre_cliente}! 🔐

🔒 Hemos actualizado la contraseña de tu cuenta ${data.plataforma || 'la plataforma'} por motivos de seguridad.

📧 Tu correo de acceso es: ${emailActual}

🔑 Tu nueva contraseña es: ${passwordActual}

⚠️ Por favor, guarda esta información en un lugar seguro.

💬 Si tienes alguna pregunta, no dudes en contactarnos. ¡Estamos aquí para ayudarte! 🚀`,
        
        'correo_password': `👋 ¡Hola {nombre_cliente}! 🔑

🔒 Hemos actualizado completamente las credenciales de tu cuenta ${data.plataforma || 'la plataforma'} por motivos de seguridad.

📧 Tu nuevo correo de acceso es: ${emailActual}

🔑 Tu nueva contraseña es: ${passwordActual}

⚠️ Por favor, actualiza tus credenciales de acceso lo antes posible.

💬 Si tienes alguna pregunta, no dudes en contactarnos. ¡Estamos aquí para ayudarte! 🚀`,
        
        'plataforma': `👋 ¡Hola {nombre_cliente}! 🖥️

🔄 Hemos migrado tu cuenta de ${data.datos_cambios?.plataforma_anterior || 'la plataforma anterior'} a ${data.datos_cambios?.plataforma_nueva || 'una nueva plataforma'} para mejorar tu experiencia.

📧 Tu correo de acceso es: ${emailActual}

🔑 Tu contraseña de acceso es: ${passwordActual}

✅ Tus datos y configuraciones se han transferido correctamente.

🎯 Disfruta de todas las nuevas funcionalidades disponibles.

💬 Si tienes alguna pregunta, no dudes en contactarnos. ¡Estamos aquí para ayudarte! 🚀`,
        
        'estado': `👋 ¡Hola {nombre_cliente}! ⚡

🔄 Tu cuenta ${data.plataforma || 'la plataforma'} ha sido actualizada exitosamente.

📧 Tu correo de acceso es: ${emailActual}

🔑 Tu contraseña de acceso es: ${passwordActual}

✅ Todos los servicios están funcionando correctamente.

⚠️ Si experimentas algún problema de acceso, por favor contáctanos inmediatamente.

💬 Estamos aquí para ayudarte en todo momento. ¡Gracias por tu confianza! 🚀`,
        
        'general': `👋 ¡Hola {nombre_cliente}! 🔄

✨ Hemos realizado actualizaciones importantes en tu cuenta ${data.plataforma || 'la plataforma'}.

📧 Tu correo de acceso es: ${emailActual}

🔑 Tu contraseña de acceso es: ${passwordActual}

✅ Todos los cambios han sido aplicados exitosamente.

⚠️ Si experimentas algún problema, no dudes en contactarnos.

💬 Estamos aquí para ayudarte en todo momento. ¡Gracias por tu confianza! 🚀`
    };
    return mensajes[tipoCambio] || mensajes.general;
}

// Abrir WhatsApp con el mensaje personalizado
function abrirWhatsApp(telefono, nombreCliente) {
    const mensaje = document.getElementById('mensaje-personalizado').value;
    if (!mensaje.trim()) {
        mostrarAlerta('⚠️ Por favor, escribe un mensaje antes de enviar WhatsApp.', 'warning');
        return;
    }
    
    const mensajePersonalizado = mensaje.replace('{nombre_cliente}', nombreCliente);
    const url = `https://wa.me/${telefono.replace(/\D/g, '')}?text=${encodeURIComponent(mensajePersonalizado)}`;
    window.open(url, '_blank');
}

// Copiar mensaje personalizado para un cliente específico
function copiarMensajeCliente(nombreCliente) {
    const mensaje = document.getElementById('mensaje-personalizado').value;
    if (!mensaje.trim()) {
        mostrarAlerta('⚠️ Por favor, escribe un mensaje antes de copiar.', 'warning');
        return;
    }
    
    const mensajePersonalizado = mensaje.replace('{nombre_cliente}', nombreCliente);
    navigator.clipboard.writeText(mensajePersonalizado).then(() => {
        mostrarAlerta('✅ Mensaje copiado al portapapeles', 'success');
    });
}

// Enviar mensajes a todos los clientes con teléfono disponible
function enviarMensajesATodos(clientes, mensaje) {
    let enviados = 0;
    const total = clientes.length;
    
    clientes.forEach(cliente => {
        if (cliente.telefono) {
            const mensajePersonalizado = mensaje.replace('{nombre_cliente}', cliente.nombre_completo);
            const url = `https://wa.me/${cliente.telefono.replace(/\D/g, '')}?text=${encodeURIComponent(mensajePersonalizado)}`;
            window.open(url, '_blank');
            enviados++;
        }
    });
    
    if (enviados > 0) {
        mostrarAlerta(`✅ Se abrieron ${enviados} conversaciones de WhatsApp de ${total} clientes.`, 'success');
    } else {
        mostrarAlerta('⚠️ No hay clientes con teléfono disponible para enviar WhatsApp.', 'warning');
    }
}

// Mostrar alerta personalizada
function mostrarAlerta(mensaje, tipo = 'info') {
    const alertDiv = document.createElement('div');
    alertDiv.className = `alert alert-${tipo} alert-dismissible fade show position-fixed`;
    alertDiv.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px; box-shadow: 0 4px 12px rgba(0,0,0,0.15);';
    
    const iconos = {
        'success': '✅',
        'warning': '⚠️',
        'danger': '❌',
        'info': 'ℹ️'
    };
    
    alertDiv.innerHTML = `
        ${iconos[tipo] || 'ℹ️'} ${mensaje}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(alertDiv);
    
    // Auto-ocultar después de 5 segundos
    setTimeout(() => {
        if (alertDiv.parentNode) {
            alertDiv.remove();
        }
    }, 5000);
}

// Mostrar vista previa del mensaje
function mostrarVistaPrevia(mensaje, clientes) {
    const modalVistaPrevia = document.createElement('div');
    modalVistaPrevia.className = 'modal fade';
    modalVistaPrevia.id = 'modalVistaPrevia';
    modalVistaPrevia.innerHTML = `
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-eye me-2"></i>👁️ Vista Previa del Mensaje
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info">
                        <h6><i class="fas fa-info-circle me-2"></i>📝 Mensaje Base:</h6>
                        <div class="bg-white p-3 rounded border">
                            <p class="mb-0 fst-italic" style="white-space: pre-line;">${mensaje}</p>
                        </div>
                    </div>
                    
                    <h6 class="fw-bold mb-3">📱 Mensajes Personalizados por Cliente:</h6>
                    <div class="row g-3">
                        ${clientes.map(cliente => `
                            <div class="col-12">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center mb-2">
                                            <div class="avatar-sm bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 35px; height: 35px;">
                                                <span class="fw-bold small">${cliente.nombre_completo.charAt(0).toUpperCase()}</span>
                                            </div>
                                            <h6 class="card-title mb-0 text-primary">${cliente.nombre_completo}</h6>
                                        </div>
                                                                <div class="bg-light p-3 rounded">
                            <small class="text-muted d-block mb-1">💬 Mensaje personalizado:</small>
                            <div class="bg-white p-2 rounded border">
                                <p class="mb-0 fw-semibold" style="white-space: pre-line;">${mensaje.replace('{nombre_cliente}', cliente.nombre_completo)}</p>
                            </div>
                        </div>
                                        ${cliente.telefono ? `
                                            <div class="mt-2">
                                                <small class="text-success">
                                                    <i class="fas fa-phone me-1"></i>${cliente.telefono}
                                                </small>
                                            </div>
                                        ` : ''}
                                    </div>
                                </div>
                            </div>
                        `).join('')}
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="button" class="btn btn-success" onclick="enviarMensajesATodos(${JSON.stringify(clientes)}, '${mensaje}')">
                        <i class="fas fa-paper-plane me-2"></i>📤 Enviar a Todos
                    </button>
                </div>
            </div>
        </div>
    `;
    
    document.body.appendChild(modalVistaPrevia);
    
    const modal = new bootstrap.Modal(modalVistaPrevia);
    modal.show();
    
    // Limpiar modal cuando se cierre
    modalVistaPrevia.addEventListener('hidden.bs.modal', () => {
        modalVistaPrevia.remove();
    });
}

// Función para copiar teléfono con feedback visual
function copiarTelefono(telefono, boton) {
    navigator.clipboard.writeText(telefono).then(() => {
        // Cambiar ícono a check
        const icono = boton.querySelector('i');
        const iconoOriginal = icono.className;
        icono.className = 'fas fa-check text-success';
        
        // Cambiar tooltip
        boton.setAttribute('data-bs-original-title', '¡Copiado!');
        const tooltip = bootstrap.Tooltip.getInstance(boton);
        if (tooltip) {
            tooltip.show();
        }
        
        // Restaurar después de 1.5 segundos
        setTimeout(() => {
            icono.className = iconoOriginal;
            boton.setAttribute('data-bs-original-title', 'Copiar teléfono');
            if (tooltip) {
                tooltip.hide();
            }
        }, 1500);
    }).catch(err => {
        console.error('Error al copiar:', err);
        // Fallback para navegadores que no soportan clipboard API
        const textArea = document.createElement('textarea');
        textArea.value = telefono;
        document.body.appendChild(textArea);
        textArea.select();
        document.execCommand('copy');
        document.body.removeChild(textArea);
        
        // Mostrar feedback visual
        const icono = boton.querySelector('i');
        const iconoOriginal = icono.className;
        icono.className = 'fas fa-check text-success';
        setTimeout(() => {
            icono.className = iconoOriginal;
        }, 1500);
    });
}
