document.addEventListener('DOMContentLoaded', function() {
    console.log('🚀 SCRIPT.JS CARGADO - DOMContentLoaded ejecutado');
    
    // ==================================================
    // 1. MANEJO DEL SIDEBAR MÓVIL - SIMPLIFICADO Y MEJORADO
    // ==================================================
    const sidebar = document.getElementById('mainSidebar');
    const sidebarToggleBtnMobile = document.getElementById('sidebarToggleBtnMobile');
    const sidebarCloseBtn = document.getElementById('sidebarCloseBtn');
    const overlay = document.getElementById('sidebar-overlay');

    console.log('=== INICIALIZANDO SIDEBAR MÓVIL ===');
    console.log('Elementos encontrados:', {
        sidebar: sidebar,
        toggleBtn: sidebarToggleBtnMobile,
        closeBtn: sidebarCloseBtn,
        overlay: overlay
    });

    function openSidebar() {
        console.log('🟢 Abriendo sidebar...');
        if (sidebar) {
            sidebar.classList.add('expanded');
            sidebar.style.transform = 'translateX(0)';
            console.log('✅ Sidebar abierto - Clases:', sidebar.className);
            console.log('✅ Sidebar transform:', sidebar.style.transform);
        } else {
            console.log('❌ Error: No se encontró el sidebar');
        }
        if (overlay) {
            overlay.style.display = 'block';
            console.log('✅ Overlay mostrado');
        } else {
            console.log('❌ Error: No se encontró el overlay');
        }
    }

    function closeSidebar() {
        console.log('🔴 Cerrando sidebar...');
        if (sidebar) {
            sidebar.classList.remove('expanded');
            sidebar.style.transform = 'translateX(-100%)';
            console.log('✅ Sidebar cerrado');
        }
        if (overlay) {
            overlay.style.display = 'none';
            console.log('✅ Overlay oculto');
        }
    }

    // Event listeners
    if (sidebarToggleBtnMobile) {
        console.log('🎯 Añadiendo evento al botón toggle');
        sidebarToggleBtnMobile.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            console.log('🖱️ Botón toggle clickeado');
            console.log('Estado actual del sidebar:', sidebar.classList.contains('expanded'));
            openSidebar();
        });
        
        // Evento adicional para debug
        sidebarToggleBtnMobile.addEventListener('mousedown', function() {
            console.log('🖱️ Botón presionado (mousedown)');
        });
        
        sidebarToggleBtnMobile.addEventListener('mouseup', function() {
            console.log('🖱️ Botón liberado (mouseup)');
        });
    } else {
        console.log('❌ ERROR: No se encontró el botón toggle');
    }

    if (sidebarCloseBtn) {
        console.log('🎯 Añadiendo evento al botón cerrar');
        sidebarCloseBtn.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            console.log('🖱️ Botón cerrar clickeado');
            closeSidebar();
        });
    } else {
        console.log('❌ ERROR: No se encontró el botón cerrar');
    }

    if (overlay) {
        console.log('🎯 Añadiendo evento al overlay');
        overlay.addEventListener('click', function(e) {
            e.preventDefault();
            console.log('🖱️ Overlay clickeado');
            closeSidebar();
        });
    } else {
        console.log('❌ ERROR: No se encontró el overlay');
    }

    // Cerrar sidebar al hacer clic en enlaces (móviles)
    if (sidebar) {
        const navLinks = sidebar.querySelectorAll('.nav-link');
        navLinks.forEach(link => {
            link.addEventListener('click', function() {
                if (window.innerWidth <= 991.98) {
                    console.log('🔗 Enlace clickeado, cerrando sidebar');
                    closeSidebar();
                }
            });
        });
    }

    // ==================================================
    // 2. LIMPIEZA DE MENSAJES EN LA URL
    // ==================================================
    if (window.location.search.includes('mensaje=')) {
        setTimeout(function() {
            const currentUrl = new URL(window.location.href);
            const params = new URLSearchParams(currentUrl.search);
            params.delete('mensaje');
            params.delete('tipo');
            
            let newPath = currentUrl.pathname;
            if (params.toString() !== '') {
                newPath += '?' + params.toString();
            }
            window.history.replaceState({}, '', newPath);
        }, 5000);
    }

    // ==================================================
    // 3. NUEVO: MANEJO DEL TEMA (MODO OSCURO)
    // ==================================================
    const themeToggleBtn = document.getElementById('theme-toggle');
    
    // Verifica si el botón existe antes de añadirle eventos
    if (themeToggleBtn) {
        const moonIcon = themeToggleBtn.querySelector('.fa-moon');
        const sunIcon = themeToggleBtn.querySelector('.fa-sun');

        // Función para aplicar el tema y actualizar el icono
        const applyTheme = (theme) => {
            document.documentElement.setAttribute('data-theme', theme);
            if (theme === 'dark') {
                if(moonIcon) moonIcon.style.display = 'none';
                if(sunIcon) sunIcon.style.display = 'inline-block';
            } else {
                if(moonIcon) moonIcon.style.display = 'inline-block';
                if(sunIcon) sunIcon.style.display = 'none';
            }
        };

        // Al cargar la página, aplica el tema guardado en localStorage o el predeterminado (claro)
        const savedTheme = localStorage.getItem('theme') || 'light';
        applyTheme(savedTheme);

        // Evento 'click' para el botón que cambia el tema
        themeToggleBtn.addEventListener('click', (e) => {
            e.preventDefault(); // Previene que el enlace '#' navegue
            let currentTheme = document.documentElement.getAttribute('data-theme');
            let newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            
            // Guarda la nueva preferencia en localStorage
            localStorage.setItem('theme', newTheme);
            // Aplica el nuevo tema
            applyTheme(newTheme);
        });
    }
});