<?php
/**
 * MIGRACIÓN COMPLETA DE BASE DE DATOS
 * Migra todos los datos de digitalpremium a digitalpremiumnueva
 */

// Configuración de ambas bases de datos
$config_antigua = [
    'host' => '127.0.0.1',
    'port' => 3306,
    'dbname' => 'digitalpremium',
    'username' => 'root',
    'password' => ''
];

$config_nueva = [
    'host' => '127.0.0.1',
    'port' => 3306,
    'dbname' => 'digitalpremiumnueva',
    'username' => 'root',
    'password' => ''
];

echo "🚀 MIGRACIÓN COMPLETA DE BASE DE DATOS\n";
echo "=====================================\n";
echo "📤 Origen: {$config_antigua['dbname']}\n";
echo "📥 Destino: {$config_nueva['dbname']}\n\n";

try {
    // Conexión a BD antigua (origen)
    $dsn_antigua = "mysql:host={$config_antigua['host']};port={$config_antigua['port']};dbname={$config_antigua['dbname']};charset=utf8mb4";
    $pdo_antigua = new PDO($dsn_antigua, $config_antigua['username'], $config_antigua['password']);
    $pdo_antigua->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Conexión a BD nueva (destino)
    $dsn_nueva = "mysql:host={$config_nueva['host']};port={$config_nueva['port']};dbname={$config_nueva['dbname']};charset=utf8mb4";
    $pdo_nueva = new PDO($dsn_nueva, $config_nueva['username'], $config_nueva['password']);
    $pdo_nueva->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "✅ Conexiones establecidas correctamente\n\n";
    
    // Lista de tablas a migrar (en orden de dependencias)
    $tablas_migrar = [
        'usuarios',           // Primero usuarios (referenciada por otras)
        'clientes',           // Depende de usuarios
        'proveedores',        // Depende de usuarios
        'cuentas_maestras',   // Depende de usuarios
        'perfiles_vendidos',  // Depende de usuarios y cuentas_maestras
        'auditoria_acciones', // Logs del sistema
        'configuraciones',    // Configuraciones
        'modulos',            // Módulos del sistema
        'plataformas',        // Plataformas
        'rol_accesos',        // Accesos por rol
        'usuario_accesos'     // Accesos por usuario
    ];
    
    $total_migrado = 0;
    $errores = [];
    
    foreach ($tablas_migrar as $tabla) {
        echo "🔄 Migrando tabla: $tabla\n";
        echo "   └─ ";
        
        try {
            // Verificar si la tabla existe en origen
            $stmt = $pdo_antigua->query("SHOW TABLES LIKE '$tabla'");
            if ($stmt->rowCount() == 0) {
                echo "❌ Tabla no existe en origen\n";
                continue;
            }
            
            // Contar registros en origen
            $stmt = $pdo_antigua->query("SELECT COUNT(*) as total FROM $tabla");
            $total_origen = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
            
            if ($total_origen == 0) {
                echo "ℹ️ Sin datos para migrar\n";
                continue;
            }
            
            // Obtener estructura de la tabla
            $stmt = $pdo_antigua->query("DESCRIBE $tabla");
            $columnas = $stmt->fetchAll(PDO::FETCH_COLUMN);
            $campos = implode(', ', $columnas);
            
            // Obtener todos los datos de la tabla origen
            $stmt = $pdo_antigua->query("SELECT * FROM $tabla");
            $datos = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // Limpiar tabla destino (si tiene datos)
            $pdo_nueva->exec("DELETE FROM $tabla");
            
            // Migrar datos registro por registro
            $migrados = 0;
            foreach ($datos as $fila) {
                $placeholders = ':' . implode(', :', array_keys($fila));
                $sql = "INSERT INTO $tabla ($campos) VALUES ($placeholders)";
                
                $stmt_insert = $pdo_nueva->prepare($sql);
                $stmt_insert->execute($fila);
                $migrados++;
            }
            
            $total_migrado += $migrados;
            echo "✅ $migrados registros migrados\n";
            
        } catch (Exception $e) {
            $error_msg = $e->getMessage();
            echo "❌ Error: $error_msg\n";
            $errores[] = "Tabla $tabla: $error_msg";
        }
        
        echo "\n";
    }
    
    // Resumen de la migración
    echo "📊 RESUMEN DE MIGRACIÓN\n";
    echo "=======================\n";
    echo "✅ Total de registros migrados: $total_migrado\n";
    
    if (!empty($errores)) {
        echo "❌ Errores encontrados:\n";
        foreach ($errores as $error) {
            echo "   • $error\n";
        }
    } else {
        echo "🎉 ¡Migración completada sin errores!\n";
    }
    
    // Verificar datos migrados
    echo "\n🔍 VERIFICACIÓN DE DATOS MIGRADOS\n";
    echo "==================================\n";
    
    foreach ($tablas_migrar as $tabla) {
        try {
            $stmt = $pdo_nueva->query("SELECT COUNT(*) as total FROM $tabla");
            $total_nueva = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
            
            $stmt = $pdo_antigua->query("SELECT COUNT(*) as total FROM $tabla");
            $total_antigua = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
            
            $estado = ($total_nueva == $total_antigua) ? "✅" : "❌";
            echo "$estado $tabla: $total_antigua → $total_nueva\n";
            
        } catch (Exception $e) {
            echo "❌ $tabla: Error al verificar\n";
        }
    }
    
    // Verificar usuario admin
    echo "\n👤 VERIFICACIÓN USUARIO ADMIN\n";
    echo "==============================\n";
    
    try {
        $stmt = $pdo_nueva->query("SELECT username, rol, estado FROM usuarios WHERE username = 'admin'");
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($admin) {
            echo "✅ Usuario admin encontrado:\n";
            echo "   • Username: {$admin['username']}\n";
            echo "   • Rol: {$admin['rol']}\n";
            echo "   • Estado: " . ($admin['estado'] ? 'Activo' : 'Inactivo') . "\n";
        } else {
            echo "❌ Usuario admin NO encontrado\n";
        }
        
    } catch (Exception $e) {
        echo "❌ Error al verificar usuario admin: " . $e->getMessage() . "\n";
    }
    
} catch (PDOException $e) {
    echo "❌ ERROR DE CONEXIÓN: " . $e->getMessage() . "\n";
} catch (Exception $e) {
    echo "❌ ERROR GENERAL: " . $e->getMessage() . "\n";
}

echo "\n🚀 MIGRACIÓN COMPLETADA\n";
echo "=======================\n";
?>
