<?php
// /pages/clientes.php (VERSIÓN FINAL COMPLETA)

if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['id_usuario'])) { header("Location: /digitalpremium/login.php"); exit(); }

require_once '../config/db.php';
$page_title = "Gestión de Clientes";
include_once '../includes/header.php';

// --- LÓGICA DE FILTROS MEJORADA ---
$where_clauses_cli = [];
$params_cli = [];
$filtros_aplicados = false;
$rol_usuario = $_SESSION['rol'] ?? 'admin';

// Filtro por nombre O teléfono en el mismo campo
if (!empty($_GET['filtro_nombre_cliente'])) {
    $where_clauses_cli[] = "(c.nombre_completo LIKE :nombre_cliente OR c.telefono LIKE :telefono_cliente)";
    $params_cli[':nombre_cliente'] = '%' . trim($_GET['filtro_nombre_cliente']) . '%';
    $params_cli[':telefono_cliente'] = '%' . trim($_GET['filtro_nombre_cliente']) . '%';
    $filtros_aplicados = true;
}

// Filtro por estado
if (isset($_GET['filtro_estado_cliente']) && $_GET['filtro_estado_cliente'] !== '') {
    $where_clauses_cli[] = "c.estado_cliente = :estado_cliente";
    $params_cli[':estado_cliente'] = $_GET['filtro_estado_cliente'];
    $filtros_aplicados = true;
}

$sql_where_cli = !empty($where_clauses_cli) ? " WHERE " . implode(" AND ", $where_clauses_cli) : "";

// --- SISTEMA DE CARGA DIFERIDA (LAZY LOADING) ---
$registros_por_carga = 50;
$registros_cargados = isset($_GET['cargar_mas']) ? (int)$_GET['cargar_mas'] : $registros_por_carga;

// Si hay filtros aplicados, mostrar todos los resultados
if ($filtros_aplicados) {
    $registros_cargados = 999999; // Número muy alto para mostrar todos
}

// --- SQL CON CARGA DIFERIDA Y CAMPOS NECESARIOS ---
$sql_clientes = "
    SELECT 
        c.*, 
        COALESCE((SELECT COUNT(*) FROM perfiles_vendidos pv_count WHERE pv_count.id_cliente = c.id_cliente AND pv_count.estado_suscripcion = 1), 0) as total_suscripciones,
        COALESCE((SELECT SUM(pv_sum.precio_venta) FROM perfiles_vendidos pv_sum WHERE pv_sum.id_cliente = c.id_cliente AND pv_sum.estado_suscripcion = 1), 0) as total_gastado,
        COALESCE((SELECT GROUP_CONCAT(DISTINCT p.nombre_plataforma SEPARATOR ',') 
                   FROM perfiles_vendidos pv_plat 
                   JOIN cuentas_maestras cm ON pv_plat.id_cuenta_maestra = cm.id_cuenta_maestra 
                   JOIN plataformas p ON cm.id_plataforma = p.id_plataforma 
                   WHERE pv_plat.id_cliente = c.id_cliente AND pv_plat.estado_suscripcion = 1), '') as plataformas_activas,
        COALESCE((SELECT MIN(pv_venc.fecha_fin_servicio) 
                   FROM perfiles_vendidos pv_venc 
                   WHERE pv_venc.id_cliente = c.id_cliente AND pv_venc.estado_suscripcion = 1 
                   AND pv_venc.fecha_fin_servicio > CURDATE()), NULL) as proximo_vencimiento
    FROM clientes c
    $sql_where_cli
    ORDER BY c.nombre_completo ASC
    LIMIT $registros_cargados";



$stmt_clientes = $pdo->prepare($sql_clientes);
$stmt_clientes->execute($params_cli);
$clientes = $stmt_clientes->fetchAll(PDO::FETCH_ASSOC);







// Contar total de registros para la paginación
$sql_count = "SELECT COUNT(DISTINCT c.id_cliente) as total FROM clientes c $sql_where_cli";
$stmt_count = $pdo->prepare($sql_count);
$stmt_count->execute($params_cli);
$total_clientes = $stmt_count->fetchColumn();
$estados_cliente_filtro = ["1" => "Activo", "0" => "Inactivo"];

// Función para construir URLs preservando filtros existentes
function buildUrlWithParams($new_params = []) {
    $current_params = $_GET;
    
    // Remover cargar_mas del current_params para evitar conflictos
    unset($current_params['cargar_mas']);
    
    $merged_params = array_merge($current_params, $new_params);
    
    // Remover parámetros vacíos
    $merged_params = array_filter($merged_params, function($value) {
        return $value !== '' && $value !== null;
    });
    
    return '?' . http_build_query($merged_params);
}
?>

<style>
    /* --- TEMA VISUAL --- */
    :root {
        --primary-color: #6a11cb;
        --secondary-color: #2575fc;
        --primary-gradient: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        --background-color: #f0f2f5;
        --card-bg: #FFFFFF;
        --card-shadow: 0 10px 30px rgba(0, 0, 0, 0.07);
        --card-shadow-hover: 0 15px 40px rgba(37, 117, 252, 0.2);
        --text-dark: #333;
        --text-light: #888;
        --border-color: #e9ecef;
        --success-color: #20c997;
        --danger-color: #e74c3c;
        --card-border-radius: 1rem;
    }
    body { background-color: var(--background-color); }
    .card { border: none; }
    .client-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
        gap: 2rem;
    }
    .client-card {
        background-color: var(--card-bg);
        border-radius: var(--card-border-radius);
        box-shadow: var(--card-shadow);
        transition: all .3s ease;
        overflow: hidden;
        display: flex;
        flex-direction: column;
    }
    .client-card:hover {
        transform: translateY(-10px);
        box-shadow: var(--card-shadow-hover);
    }
    .card-header-custom {
        background: var(--primary-gradient);
        color: white;
        padding: 1.5rem;
        display: flex;
        align-items: center;
        position: relative;
    }
    .client-avatar {
        width: 60px; height: 60px;
        background-color: rgba(255, 255, 255, 0.2);
        color: white;
        display: flex; align-items: center; justify-content: center;
        border-radius: 50%;
        font-weight: 700; font-size: 1.8rem;
        margin-right: 1rem;
        border: 3px solid white;
        flex-shrink: 0;
    }
    .client-name { font-weight: 600; font-size: 1.3rem; }
    .client-contact { font-size: 0.9rem; opacity: 0.8; }
    .client-contact a { color: white !important; text-decoration: none; }
    .btn-copy-phone {
        background: none; border: none; color: white; opacity: 0.7;
        cursor: pointer; transition: all 0.2s ease;
    }
    .btn-copy-phone:hover { opacity: 1; transform: scale(1.1); }
    .status-badge {
        position: absolute; top: 1rem; right: 1rem;
        font-size: .7rem; font-weight: 700; padding: .3em .8em;
        border-radius: 50px; background-color: rgba(255,255,255,0.2);
        text-transform: uppercase; letter-spacing: .5px;
    }
    .card-body-custom {
        padding: 1.5rem;
        display: flex;
        flex-direction: column;
        gap: 1.25rem;
        flex-grow: 1;
    }
    .info-block { display: flex; justify-content: space-between; align-items: flex-start; gap: 1rem; }
    .info-label { color: var(--text-light); font-size: 0.8rem; text-transform: uppercase; margin-bottom: 0.25rem; }
    .info-value { font-weight: 600; font-size: 0.95rem; color: var(--text-dark); }
    
    .info-block-main {
        flex-grow: 1;
        min-width: 0;
    }
    .vencimiento-block {
        text-align: right;
        flex-shrink: 0;
    }

    .platforms-list {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
        align-items: center;
    }
    .platform-tag {
        background-color: #e9ecef;
        color: #495057;
        padding: 0.3em 0.75em;
        border-radius: 50px;
        font-size: 0.8rem;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        /* Se eliminó 'white-space: nowrap;' para que el texto largo se ajuste */
    }
    .platform-tag .count {
        background-color: var(--secondary-color);
        color: white;
        border-radius: 50%;
        font-size: 0.75em;
        font-weight: 700;
        min-width: 1.5em;
        height: 1.5em;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }
    
    .financial-summary { display: flex; gap: 1rem; }
    .financial-item {
        flex: 1; padding: 1rem; background-color: #f8f9fa;
        border-radius: 0.75rem;
        text-align: center;
    }
    .financial-item .amount { display: block; font-weight: 700; font-size: 1.3rem; }
    .financial-item .amount.positive { color: var(--success-color); }
    .financial-item .amount.negative { color: var(--danger-color); }
    /* Estilos para las notas - VERSIÓN MEJORADA */
    .notes-section {
        border-top: 1px solid #e9ecef;
        padding-top: 1rem;
        margin-top: 1rem;
        margin-bottom: 1rem;
    }
    
    .notes-toggle {
        font-weight: 600; 
        color: var(--secondary-color);
        text-decoration: none; 
        font-size: 0.9rem;
        display: flex;
        align-items: center;
        justify-content: space-between;
        width: 100%;
        padding: 0.75rem 1rem;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-radius: 0.5rem;
        border: 1px solid #dee2e6;
        transition: all 0.3s ease;
        margin-bottom: 0.75rem;
    }
    
    .notes-toggle:hover { 
        text-decoration: none; 
        background: linear-gradient(135deg, #e9ecef 0%, #dee2e6 100%);
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    
    .notes-toggle .transition-transform {
        transition: transform 0.3s ease;
    }
    
    .notes-toggle[aria-expanded="true"] .transition-transform {
        transform: rotate(180deg);
    }
    
    .notes-content {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-left: 4px solid var(--secondary-color);
        padding: 1rem 1.25rem; 
        border-radius: 0.75rem; 
        font-size: 0.9rem;
        max-height: 120px; 
        overflow-y: auto; 
        overflow-x: hidden;
        white-space: normal;
        word-wrap: break-word;
        word-break: break-word;
        box-shadow: inset 0 2px 4px rgba(0,0,0,0.05);
        line-height: 1.5;
    }
    
    .notes-content::-webkit-scrollbar {
        width: 6px;
    }
    
    .notes-content::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 3px;
    }
    
    .notes-content::-webkit-scrollbar-thumb {
        background: var(--secondary-color);
        border-radius: 3px;
    }
    
    .notes-content::-webkit-scrollbar-thumb:hover {
        background: var(--primary-color);
    }
    
    .notes-header {
        color: var(--text-dark);
        font-size: 0.85rem;
        border-bottom: 1px solid #dee2e6;
        padding-bottom: 0.5rem;
        margin-bottom: 0.75rem;
    }
    
    .notes-text {
        color: var(--text-dark);
        font-size: 0.9rem;
        line-height: 1.6;
        word-wrap: break-word;
        word-break: break-word;
        overflow-wrap: break-word;
        white-space: normal;
        max-width: 100%;
    }
    
    /* Mejorar la responsividad de las notas */
    @media (max-width: 768px) {
        .notes-toggle {
            padding: 0.6rem 0.8rem;
            font-size: 0.85rem;
        }
        
        .notes-content {
            padding: 0.8rem 1rem;
            font-size: 0.85rem;
            max-height: 100px;
        }
        
        .notes-header {
            font-size: 0.8rem;
        }
        
        .notes-text {
            font-size: 0.85rem;
            line-height: 1.5;
        }
    }
    
    /* Asegurar que el texto se ajuste correctamente en todos los dispositivos */
    .notes-content, .notes-text {
        box-sizing: border-box;
        width: 100%;
    }
    .card-footer-custom {
        background-color: #f8f9fa; padding: 1rem 1.5rem;
        border-top: 1px solid var(--border-color);
    }
    .card-footer-custom .btn { border-radius: 50px; font-weight: 600; }
    .modal-content { border-radius: var(--card-border-radius); border: none; box-shadow: 0 10px 40px rgba(0,0,0,0.1); }
    .modal-header { background: var(--primary-gradient); color: white; border-top-left-radius: var(--card-border-radius); border-top-right-radius: var(--card-border-radius); border-bottom: none; }
    .modal-header .btn-close { filter: invert(1) grayscale(100%) brightness(200%); }
    .modal-body .form-label { color: var(--text-dark) !important; font-weight: 600; }
    .modal-body .form-control { border-radius: 0.5rem; border: 1px solid var(--border-color); padding: 0.75rem 1rem; }
    .modal-body .form-control:focus { border-color: var(--secondary-color); box-shadow: 0 0 0 3px rgba(37, 117, 252, 0.15); }
    .modal-footer { border-top: 1px solid var(--border-color); }

    /* Diseño responsivo para apilar elementos en pantallas muy estrechas */
    @media (max-width: 420px) {
        .info-block {
            flex-direction: column;
            align-items: stretch;
            gap: 0.5rem;
        }
        .vencimiento-block {
            text-align: left;
            background-color: #f8f9fa;
            padding: 0.5rem 0.75rem;
            border-radius: 0.5rem;
            margin-top: 0.5rem;
        }
    }

    /* ==========================================================================
       ESTILOS PARA EL CAMPO DE BÚSQUEDA NOMBRE/TELÉFONO
       ========================================================================== */
    
    /* Campo de búsqueda principal */
    input[name="filtro_nombre_cliente"] {
        border: 2px solid #e9ecef;
        border-radius: 0.75rem;
        padding: 0.75rem 1rem;
        transition: all 0.3s ease;
        font-size: 0.95rem;
        background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    }
    
    input[name="filtro_nombre_cliente"]:focus {
        border-color: var(--secondary-color);
        box-shadow: 0 0 0 0.2rem rgba(37, 117, 252, 0.15);
        transform: translateY(-1px);
        background: #ffffff;
    }
    
    input[name="filtro_nombre_cliente"]::placeholder {
        color: #6c757d;
        font-style: italic;
    }
    
    /* Mensaje informativo */
    .alert-info {
        border: none;
        box-shadow: 0 4px 15px rgba(33, 150, 243, 0.1);
    }
    
    .alert-info .fas {
        color: #2196f3;
    }
    
    /* Mejoras para el label */
    .form-label-sm.fw-bold {
        color: var(--text-dark);
        font-size: 0.9rem;
        margin-bottom: 0.5rem;
    }
    
    /* Texto de ayuda */
    .form-text {
        font-size: 0.8rem;
        color: #6c757d;
        margin-top: 0.25rem;
    }
    
    /* Hover effect para el campo */
    input[name="filtro_nombre_cliente"]:hover {
        border-color: #adb5bd;
        background: #ffffff;
    }
    
    /* Estado activo */
    input[name="filtro_nombre_cliente"]:not(:placeholder-shown) {
        border-color: var(--success-color);
        background: linear-gradient(135deg, #f8fff9 0%, #ffffff 100%);
    }
    
    /* Indicador de Rendimiento y Controles de Carga */
    .performance-indicator {
        background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
        padding: 0.5rem 1rem;
        border-radius: 0.75rem;
        border: 1px solid #e9ecef;
        font-size: 0.9rem;
    }
    
    .performance-indicator i {
        font-size: 1rem;
    }
    
    /* Botones de carga diferida */
    .btn-outline-primary.btn-sm,
    .btn-outline-success.btn-sm {
        font-size: 0.8rem;
        padding: 0.4rem 0.8rem;
        border-radius: 0.5rem;
        transition: all 0.3s ease;
    }
    
    .btn-outline-primary.btn-sm:hover,
    .btn-outline-success.btn-sm:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }
    
    /* Mensaje informativo de carga */
    .card[style*="grid-column: 1 / -1"] {
        border: 2px dashed #dee2e6;
        background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%) !important;
    }
    
    .card[style*="grid-column: 1 / -1"]:hover {
        border-color: var(--primary-color);
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
    }
    
    /* Responsive para móviles */
    @media (max-width: 768px) {
        input[name="filtro_nombre_cliente"] {
            padding: 0.6rem 0.8rem;
            font-size: 0.9rem;
        }
        
        .alert-info {
            padding: 1rem;
        }
        
        .alert-info h6 {
            font-size: 1rem;
        }
        
        .alert-info p {
            font-size: 0.9rem;
        }
        
        /* Responsive para controles de carga */
        .performance-indicator {
            padding: 0.4rem 0.8rem;
            font-size: 0.8rem;
        }
        
        .d-flex.gap-2 {
            flex-direction: column;
            gap: 0.5rem !important;
        }
        
        .btn-outline-primary.btn-sm,
        .btn-outline-success.btn-sm {
            width: 100%;
            text-align: center;
        }
    }

    /* ==========================================================================
       ESTILOS MEJORADOS PARA EL FILTRO
       ========================================================================== */
    
    /* Contenedor del filtro */
    #filtrosClientesCollapse .card-body {
        background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
        border-top: 1px solid var(--border-color);
    }
    
    /* Labels del filtro */
    .form-label-sm.fw-bold.text-primary {
        font-size: 0.85rem;
        font-weight: 600;
        color: var(--primary-color) !important;
        margin-bottom: 0.5rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .form-label-sm.fw-bold.text-primary i {
        font-size: 0.9rem;
        opacity: 0.8;
    }
    
    /* Campos del filtro */
    #filtrosClientesCollapse .form-control,
    #filtrosClientesCollapse .form-select {
        border: 2px solid #e9ecef;
        border-radius: 0.75rem;
        padding: 0.6rem 0.8rem;
        font-size: 0.9rem;
        transition: all 0.3s ease;
        background: #ffffff;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    }
    
    #filtrosClientesCollapse .form-control:focus,
    #filtrosClientesCollapse .form-select:focus {
        border-color: var(--secondary-color);
        box-shadow: 0 0 0 0.2rem rgba(37, 117, 252, 0.15);
        transform: translateY(-1px);
        background: #ffffff;
    }
    
    /* Botones del filtro */
    #filtrosClientesCollapse .btn {
        border-radius: 0.75rem;
        font-weight: 600;
        font-size: 0.85rem;
        padding: 0.6rem 1rem;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
    
    #filtrosClientesCollapse .btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
    }
    
    #filtrosClientesCollapse .btn-primary {
        background: var(--primary-gradient);
        border: none;
    }
    
    #filtrosClientesCollapse .btn-outline-secondary {
        border: 2px solid #6c757d;
        color: #6c757d;
    }
    
    #filtrosClientesCollapse .btn-outline-secondary:hover {
        background: #6c757d;
        border-color: #6c757d;
        color: #ffffff;
    }
    
    /* Texto de ayuda */
    #filtrosClientesCollapse .form-text {
        font-size: 0.75rem;
        color: #6c757d;
        margin-top: 0.25rem;
        font-style: italic;
    }
    
    #filtrosClientesCollapse .form-text i {
        color: var(--primary-color);
        opacity: 0.7;
    }
    
    /* Responsive del filtro */
    @media (max-width: 768px) {
        #filtrosClientesCollapse .form-label-sm.fw-bold.text-primary {
            font-size: 0.8rem;
        }
        
        #filtrosClientesCollapse .form-control,
        #filtrosClientesCollapse .form-select {
            padding: 0.5rem 0.7rem;
            font-size: 0.85rem;
        }
        
        #filtrosClientesCollapse .btn {
            padding: 0.5rem 0.8rem;
            font-size: 0.8rem;
        }
    }
</style>

<div class="container-fluid px-4">
    <header class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="h3 text-dark"><i class="fas fa-users me-2"></i>Gestión de Clientes</h1>
        <button type="button" class="btn btn-primary shadow-sm" data-bs-toggle="modal" data-bs-target="#modalAgregarCliente" style="background: var(--primary-gradient); border: none; border-radius: 50px; padding: 0.6rem 1.2rem; font-weight: 600;">
            <i class="fas fa-user-plus me-1"></i> Agregar Cliente
        </button>
    </header>

    <?php if (isset($_GET['mensaje'])): ?>
    <div class="alert alert-<?php echo htmlspecialchars($_GET['tipo'] ?? 'info'); ?> alert-dismissible fade show" role="alert"><?php echo htmlspecialchars(urldecode($_GET['mensaje'])); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
    <?php endif; ?>

    <!-- Mensaje informativo sobre la búsqueda -->
    <div class="alert alert-info border-0 mb-3" style="border-radius: var(--card-border-radius); background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%); border-left: 4px solid #2196f3;">
        <div class="d-flex align-items-center">
            <i class="fas fa-info-circle fa-2x text-primary me-3"></i>
            <div>
                <h6 class="mb-1 fw-bold text-primary">💡 Búsqueda Inteligente</h6>
                <p class="mb-0 text-dark">
                    <strong>En el campo "Nombre o Teléfono" puedes buscar:</strong><br>
                    • <strong>Por nombre:</strong> "Juan", "María", "Pérez"<br>
                    • <strong>Por número:</strong> "987", "519", "654" (funciona con cualquier parte del número)<br>
                    • <strong>Combinado:</strong> Los resultados mostrarán coincidencias en ambos campos
                </p>
            </div>
        </div>
    </div>

    <div class="card mb-4" style="border-radius: var(--card-border-radius);">
        <div class="card-header py-3">
              <a href="#filtrosClientesCollapse" data-bs-toggle="collapse" class="text-decoration-none text-dark fw-bold d-block">
                  <i class="fas fa-filter me-1"></i> Filtros de Búsqueda <i class="fas fa-chevron-down indicador-colapso ms-1 float-end"></i>
              </a>
        </div>
        <div class="collapse <?php echo $filtros_aplicados ? 'show' : ''; ?>" id="filtrosClientesCollapse">
            <div class="card-body p-3">
                  <form action="" method="GET" class="row g-3">
                      <div class="col-lg-4 col-md-6">
                          <label class="form-label-sm fw-bold text-primary mb-2">
                              <i class="fas fa-search me-1"></i>Nombre o Teléfono
                          </label>
                          <input type="text" 
                                 name="filtro_nombre_cliente" 
                                 class="form-control form-control-sm" 
                                 placeholder="Buscar por nombre o número..."
                                 value="<?php echo htmlspecialchars($_GET['filtro_nombre_cliente'] ?? ''); ?>">
                          <small class="text-muted form-text">
                              <i class="fas fa-info-circle me-1"></i>Busca en nombre del cliente o número de teléfono
                          </small>
                      </div>
                      
                      <div class="col-lg-3 col-md-6">
                          <label class="form-label-sm fw-bold text-primary mb-2">
                              <i class="fas fa-toggle-on me-1"></i>Estado
                          </label>
                          <select name="filtro_estado_cliente" class="form-select form-select-sm">
                              <option value="">Todos los estados</option>
                              <?php foreach ($estados_cliente_filtro as $val => $texto): ?>
                                  <option value="<?php echo $val; ?>" 
                                          <?php echo (isset($_GET['filtro_estado_cliente']) && $_GET['filtro_estado_cliente'] !== '' && $_GET['filtro_estado_cliente'] == $val) ? 'selected' : ''; ?>>
                                      <?php echo $texto; ?>
                                  </option>
                              <?php endforeach; ?>
                          </select>
                      </div>
                      
                      <div class="col-lg-2 col-md-6">
                          <label class="form-label-sm fw-bold text-primary mb-2">
                              <i class="fas fa-cog me-1"></i>Acciones
                          </label>
                          <div class="d-grid gap-2">
                              <button type="submit" class="btn btn-primary btn-sm">
                                  <i class="fas fa-search me-1"></i> Filtrar
                              </button>
                          </div>
                      </div>
                      
                      <div class="col-lg-2 col-md-6">
                          <label class="form-label-sm fw-bold text-primary mb-2">
                              <i class="fas fa-broom me-1"></i>Limpiar
                          </label>
                          <div class="d-grid gap-2">
                              <a href="clientes.php" class="btn btn-outline-secondary btn-sm">
                                  <i class="fas fa-eraser me-1"></i> Limpiar
                              </a>
                          </div>
                      </div>
                  </form>
            </div>
        </div>
    </div>
    
    <!-- Indicador de Rendimiento y Controles de Carga -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center gap-3">
                            <div class="performance-indicator">
                                <i class="fas fa-tachometer-alt text-primary me-2"></i>
                                <span class="text-muted">Mostrando <strong><?php echo count($clientes); ?></strong> de <strong><?php echo $total_clientes; ?></strong> clientes</span>
                            </div>
                            <?php if (!$filtros_aplicados && $total_clientes > $registros_por_carga): ?>
                                <div class="text-muted small">
                                    <i class="fas fa-lightbulb text-warning me-1"></i>
                                    <strong>Consejo:</strong> Usa los filtros para encontrar clientes específicos más rápido
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <?php if (!$filtros_aplicados && $total_clientes > $registros_por_carga): ?>
                            <div class="d-flex gap-2">
                                <?php if ($registros_cargados < $total_clientes): ?>
                                    <a href="<?php echo buildUrlWithParams(['cargar_mas' => min($registros_cargados + $registros_por_carga, $total_clientes)]); ?>" 
                                       class="btn btn-outline-primary btn-sm">
                                        <i class="fas fa-plus me-1"></i>
                                        Cargar más clientes (<?php echo min($registros_cargados + $registros_por_carga, $total_clientes); ?>)
                                    </a>
                                <?php endif; ?>
                                
                                <?php if ($registros_cargados < $total_clientes): ?>
                                    <a href="<?php echo buildUrlWithParams(['cargar_mas' => $total_clientes]); ?>" 
                                       class="btn btn-outline-success btn-sm">
                                        <i class="fas fa-list me-1"></i>
                                        Mostrar todos (<?php echo $total_clientes; ?>)
                                    </a>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="client-grid">
        <?php if (empty($clientes)): ?>
            <div class="card p-5 text-center" style="grid-column: 1 / -1; border-radius: var(--card-border-radius);">
                <h5 class="text-muted">No se encontraron clientes</h5>
                <p class="text-muted"><?php echo ($filtros_aplicados) ? 'Prueba con otros filtros o límpialos.' : '¡Agrega tu primer cliente para empezar!'; ?></p>
            </div>
        <?php elseif (!$filtros_aplicados && $total_clientes > $registros_por_carga && count($clientes) < $total_clientes): ?>
            <div class="card p-4 text-center" style="grid-column: 1 / -1; border-radius: var(--card-border-radius); background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);">
                <i class="fas fa-users fa-2x text-muted mb-3"></i>
                <h6 class="text-muted">Hay más clientes disponibles</h6>
                <p class="text-muted mb-3">Actualmente se muestran <?php echo count($clientes); ?> de <?php echo $total_clientes; ?> clientes registrados.</p>
                <div class="d-flex gap-2 justify-content-center">
                    <a href="<?php echo buildUrlWithParams(['cargar_mas' => min($registros_cargados + $registros_por_carga, $total_clientes)]); ?>" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus me-1"></i>Cargar más clientes
                    </a>
                    <a href="<?php echo buildUrlWithParams(['cargar_mas' => $total_clientes]); ?>" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-list me-1"></i>Mostrar todos
                    </a>
                </div>
            </div>
        <?php endif; ?>
        
        <!-- LISTA DE CLIENTES - SIEMPRE SE MUESTRA SI HAY CLIENTES -->
        <?php if (!empty($clientes)): ?>
                                    <?php foreach ($clientes as $cliente): 
                            // Calcular ganancia estimada (asumiendo un margen del 30% por defecto)
                            $costo_estimado = $cliente['total_gastado'] * 0.7; // 70% del precio de venta como costo estimado
                            $ganancia = $cliente['total_gastado'] - $costo_estimado;
                            $ganancia_class = $ganancia >= 0 ? 'positive' : 'negative';
                        ?>
                <div class="client-card">
                    <div class="card-header-custom">
                        <div class="client-avatar"><?php echo strtoupper(substr($cliente['nombre_completo'], 0, 1)); ?></div>
                        <div style="min-width: 0;">
                            <div class="client-name text-truncate"><?php echo htmlspecialchars($cliente['nombre_completo']); ?></div>
                            <div class="client-contact">
                                <?php if (!empty($cliente['telefono'])): ?>
                                    <div class="d-flex align-items-center">
                                        <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $cliente['telefono']); ?>" target="_blank">
                                            <i class="fab fa-whatsapp"></i> <?php echo htmlspecialchars($cliente['telefono']); ?>
                                        </a>
                                        <button class="btn-copy-phone ms-2" data-copy-text="<?php echo htmlspecialchars($cliente['telefono']); ?>" title="Copiar número">
                                            <i class="far fa-copy"></i>
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <span class="status-badge"><?php echo ($cliente['estado_cliente'] == 1) ? 'Activo' : 'Inactivo'; ?></span>
                    </div>

                    <div class="card-body-custom">
                        <div class="info-block">
                            <div class="info-block-main">
                                <div class="info-label">Plataformas Activas (<?php echo $cliente['total_suscripciones']; ?>)</div>
                                <div class="platforms-list mt-1">
                                    <?php if(!empty($cliente['plataformas_activas']) && trim($cliente['plataformas_activas']) !== ''): 
                                        $plataformas_lista = explode(',', $cliente['plataformas_activas']);
                                        $plataformas_conteo = array_count_values($plataformas_lista);
                                        
                                        foreach($plataformas_conteo as $nombre => $cantidad): 
                                            if(trim($nombre) !== ''): ?>
                                                <span class="platform-tag">
                                                    <span><?php echo htmlspecialchars(trim($nombre)); ?></span>
                                                    <span class="count"><?php echo $cantidad; ?></span>
                                                </span>
                                            <?php endif; 
                                        endforeach; ?>
                                    <?php else: ?>
                                        <span class="info-value text-muted">Ninguna</span>
                                    <?php endif; ?>

                                </div>
                            </div>
                            <?php if(isset($cliente['proximo_vencimiento']) && $cliente['proximo_vencimiento'] && $cliente['proximo_vencimiento'] !== '0000-00-00'): ?>
                            <div class="vencimiento-block">
                                <div class="info-label"><i class="far fa-calendar-times me-1"></i> Próximo Vencimiento</div>
                                <span class="info-value fw-bold text-danger"><?php echo date("d/m/Y", strtotime($cliente['proximo_vencimiento'])); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <?php if (!empty(trim($cliente['notas_cliente'] ?? ''))): ?>
                        <div class="notes-section">
                            <div class="notes-toggle" data-bs-toggle="collapse" data-bs-target="#notes-<?php echo $cliente['id_cliente']; ?>" aria-expanded="false" aria-controls="notes-<?php echo $cliente['id_cliente']; ?>">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-sticky-note me-2"></i> 
                                    <span>Ver Notas del Cliente</span>
                                </div>
                                <i class="fas fa-chevron-down transition-transform"></i>
                            </div>
                            <div class="collapse" id="notes-<?php echo $cliente['id_cliente']; ?>">
                                <div class="notes-content">
                                    <div class="notes-header">
                                        <i class="fas fa-info-circle me-1 text-primary"></i>
                                        <strong>Notas del Cliente:</strong>
                                    </div>
                                    <div class="notes-text">
                                        <?php echo htmlspecialchars($cliente['notas_cliente']); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>

                        <div>
                            <div class="info-label mb-2">Resumen Financiero</div>
                            <div class="financial-summary">
                                <div class="financial-item">
                                    <small class="text-muted">GASTADO</small>
                                    <span class="amount">S/<?php echo number_format($cliente['total_gastado'], 2); ?></span>
                                </div>
                                <div class="financial-item">
                                    <small class="text-muted">GANANCIA</small>
                                    <span class="amount <?php echo $ganancia_class; ?>">S/<?php echo number_format($ganancia, 2); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-footer-custom">
                        <div class="btn-group w-100">
                            <a href="/digitalpremium/pages/perfiles_vendidos.php?cliente=<?php echo (int)$cliente['id_cliente']; ?>" class="btn btn-sm btn-primary" style="background: var(--primary-gradient); border:none;">
                                <i class="fas fa-list-check me-1"></i> Suscripciones
                            </a>
                            <button type="button" class="btn btn-sm btn-outline-secondary btn-edit"
                                    data-bs-toggle="modal" data-bs-target="#modalEditarCliente"
                                    data-id="<?php echo $cliente['id_cliente']; ?>"
                                    data-nombre="<?php echo htmlspecialchars($cliente['nombre_completo']); ?>"
                                    data-telefono="<?php echo htmlspecialchars($cliente['telefono'] ?? ''); ?>"
                                    data-email="<?php echo htmlspecialchars($cliente['email'] ?? ''); ?>"
                                    data-notas="<?php echo htmlspecialchars($cliente['notas_cliente'] ?? ''); ?>"
                                    data-estado="<?php echo $cliente['estado_cliente']; ?>">
                                <i class="fas fa-edit me-1"></i>Editar
                            </button>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<div class="modal fade" id="modalAgregarCliente" tabindex="-1" aria-hidden="true"> <div class="modal-dialog modal-lg modal-dialog-centered"> <div class="modal-content"><div class="modal-header"><h5 class="modal-title"><i class="fas fa-user-plus me-2"></i>Agregar Nuevo Cliente</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><form action="/digitalpremium/actions/clientes_controlador.php" method="POST"> <div class="modal-body"> <input type="hidden" name="accion" value="agregar"> <div class="mb-3"><label class="form-label">Nombre Completo <span class="text-danger">*</span></label><input type="text" class="form-control" name="nombre_completo" required></div><div class="row"> <div class="col-md-6 mb-3"><label class="form-label">Teléfono (WhatsApp)</label>
<input type="tel" class="form-control" name="telefono" placeholder="Ej: 51987654321" required pattern="^\d{9,15}$" inputmode="numeric">
</div><div class="col-md-6 mb-3"><label class="form-label">Email (Opcional)</label><input type="email" class="form-control" name="email"></div></div><div class="mb-3"><label class="form-label">Notas Adicionales</label><textarea class="form-control" name="notas_cliente" rows="3"></textarea></div></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="submit" class="btn btn-primary" style="background: var(--primary-gradient); border: none;"><i class="fas fa-save me-1"></i>Guardar Cliente</button></div></form> </div></div></div>
<div class="modal fade" id="modalEditarCliente" tabindex="-1" aria-hidden="true"> <div class="modal-dialog modal-lg modal-dialog-centered"> <div class="modal-content"><div class="modal-header bg-warning text-dark"><h5 class="modal-title"><i class="fas fa-edit me-1"></i>Editar Cliente</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><form action="/digitalpremium/actions/clientes_controlador.php" method="POST"> <div class="modal-body"> <input type="hidden" name="accion" value="editar"><input type="hidden" name="id_cliente" id="id_cliente_edit"> <div class="mb-3"><label class="form-label">Nombre Completo <span class="text-danger">*</span></label><input type="text" class="form-control" id="nombre_completo_edit" name="nombre_completo" required></div><div class="row"> <div class="col-md-6 mb-3"><label class="form-label">Teléfono (WhatsApp)</label><input type="tel" class="form-control" id="telefono_edit" name="telefono" required pattern="^\d{9,15}$" inputmode="numeric">
</div><div class="col-md-6 mb-3"><label class="form-label">Email (Opcional)</label><input type="email" class="form-control" id="email_edit" name="email"></div></div><div class="mb-3"><label class="form-label">Notas Adicionales</label><textarea class="form-control" id="notas_cliente_edit" name="notas_cliente" rows="3"></textarea></div><div class="mb-3"><label class="form-label">Estado</label><select class="form-select" id="estado_cliente_edit" name="estado_cliente"><option value="1">Activo</option><option value="0">Inactivo</option></select></div></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="submit" class="btn btn-warning"><i class="fas fa-save me-1"></i>Actualizar Cliente</button></div></form> </div></div></div>
<div class="modal fade" id="modalCambiarEstadoCliente" tabindex="-1" aria-hidden="true"> <div class="modal-dialog modal-dialog-centered"> <div class="modal-content"><div class="modal-header" id="headerCambiarEstadoCliente_cli"><h5 class="modal-title" id="modalCambiarEstadoClienteLabel"><i class="fas fa-exchange-alt me-1"></i>Cambiar Estado</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><form action="/digitalpremium/actions/clientes_controlador.php" method="POST"> <div class="modal-body"><input type="hidden" name="accion" value="cambiar_estado"><input type="hidden" name="id_cliente" id="id_cliente_estado_js_cli"><input type="hidden" name="nuevo_estado" id="nuevo_estado_cliente_js_cli"><p class="fs-5 text-center">¿Estás seguro de que deseas cambiar el estado del cliente "<strong id="nombre_cliente_estado_js_cli"></strong>" a <strong id="texto_nuevo_estado_js_cli"></strong>?</p></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="submit" class="btn" id="btnConfirmarCambioEstadoCliente_cli">Sí, Cambiar</button></div></form> </div></div></div>

<?php include_once '../includes/footer.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const modalEditarCliente = document.getElementById('modalEditarCliente');
    if(modalEditarCliente) {
        modalEditarCliente.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            document.getElementById('id_cliente_edit').value = button.dataset.id;
            document.getElementById('nombre_completo_edit').value = button.dataset.nombre;
            document.getElementById('telefono_edit').value = button.dataset.telefono;
            document.getElementById('email_edit').value = button.dataset.email;
            document.getElementById('notas_cliente_edit').value = button.dataset.notas;
            document.getElementById('estado_cliente_edit').value = button.dataset.estado;
        });
    }

    const modalCambiarEstadoCliente = document.getElementById('modalCambiarEstadoCliente');
    if(modalCambiarEstadoCliente) {
        modalCambiarEstadoCliente.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            const id = button.dataset.id;
            const nombre = button.dataset.nombre;
            const estadoActual = button.dataset.estado_actual;
            const nuevoEstado = (estadoActual == '1' ? '0' : '1');
            const textoNuevoEstado = (nuevoEstado == '1' ? 'Activo' : 'Inactivo');
            document.getElementById('id_cliente_estado_js_cli').value = id;
            document.getElementById('nombre_cliente_estado_js_cli').textContent = nombre;
            document.getElementById('nuevo_estado_cliente_js_cli').value = nuevoEstado;
            document.getElementById('texto_nuevo_estado_js_cli').textContent = textoNuevoEstado;
            const modalHeader = document.getElementById('headerCambiarEstadoCliente_cli');
            const btnConfirmar = document.getElementById('btnConfirmarCambioEstadoCliente_cli');
            modalHeader.className = 'modal-header'; 
            btnConfirmar.className = 'btn';
            if (nuevoEstado == '1') {
                modalHeader.classList.add('bg-success', 'text-white');
                btnConfirmar.classList.add('btn-success');
                btnConfirmar.innerHTML = '<i class="fas fa-user-check me-1"></i>Sí, Activar';
            } else {
                modalHeader.classList.add('bg-danger', 'text-white');
                btnConfirmar.classList.add('btn-danger');
                btnConfirmar.innerHTML = '<i class="fas fa-user-slash me-1"></i>Sí, Inactivar';
            }
        });
    }

    const filtrosCollapseElement = document.getElementById('filtrosClientesCollapse');
    const toggleFiltrosButton = document.querySelector('[data-bs-target="#filtrosClientesCollapse"]');
    if (filtrosCollapseElement && toggleFiltrosButton) {
        const indicadorIcono = toggleFiltrosButton.querySelector('.indicador-colapso');
        const updateIcono = () => {
            if (filtrosCollapseElement.classList.contains('show')) {
                indicadorIcono.classList.remove('fa-chevron-down');
                indicadorIcono.classList.add('fa-chevron-up');
            } else {
                indicadorIcono.classList.remove('fa-chevron-up');
                indicadorIcono.classList.add('fa-chevron-down');
            }
        };
        updateIcono();
        filtrosCollapseElement.addEventListener('shown.bs.collapse', updateIcono);
        filtrosCollapseElement.addEventListener('hidden.bs.collapse', updateIcono);
    }

    if (window.location.search.includes('mensaje=')) {
        setTimeout(function() {
            const currentUrl = new URL(window.location.href);
            window.history.replaceState({}, '', currentUrl.pathname + '?' + currentUrl.searchParams.toString().replace(/&?mensaje=[^&]*&?tipo=[^&]*/, '').replace(/^&|&$/, ''));
        }, 5000);
    }

    // Mejorar la interacción con las notas
    document.querySelectorAll('.notes-toggle').forEach(toggle => {
        toggle.addEventListener('click', function(e) {
            const icon = this.querySelector('.transition-transform');
            if (icon) {
                setTimeout(() => {
                    const isExpanded = this.getAttribute('aria-expanded') === 'true';
                    icon.style.transform = isExpanded ? 'rotate(180deg)' : 'rotate(0deg)';
                }, 50);
            }
        });
    });
    
    document.addEventListener('click', function(event) {
        const copyBtn = event.target.closest('.btn-copy-phone');
        if (copyBtn) {
            const textToCopy = copyBtn.dataset.copyText;
            if (textToCopy) {
                navigator.clipboard.writeText(textToCopy).then(() => {
                    const originalIconHTML = copyBtn.innerHTML;
                    copyBtn.innerHTML = '<i class="fas fa-check"></i>';
                    copyBtn.disabled = true;

                    setTimeout(() => {
                        copyBtn.innerHTML = originalIconHTML;
                        copyBtn.disabled = false;
                    }, 2000);
                }).catch(err => {
                    console.error('Error al copiar el texto: ', err);
                });
            }
        }
    });
});

const telefonosExistentes = new Set([
  <?php
    $telList = [];
    foreach ($clientes as $c) {
        if (!empty($c['telefono'])) { $telList[] = "'" . preg_replace('/\D+/', '', $c['telefono']) . "'"; }
    }
    echo implode(',', array_unique($telList));
  ?>
]);

function normalizaTel(v){ return (v || '').replace(/\D+/g,''); }

const formAdd = document.querySelector('#modalAgregarCliente form');
if (formAdd) {
  formAdd.addEventListener('submit', function(e){
    const tel = normalizaTel(formAdd.querySelector('[name="telefono"]').value);
    if (telefonosExistentes.has(tel)) {
        e.preventDefault();
        alert('Ya existe un cliente con ese número de teléfono.');
    }
  });
}

const formEdit = document.querySelector('#modalEditarCliente form');
if (formEdit) {
  formEdit.addEventListener('submit', function(e){
    const id = formEdit.querySelector('[name="id_cliente"]').value;
    const tel = normalizaTel(formEdit.querySelector('[name="telefono"]').value);
    const triggerBtn = document.querySelector(`[data-bs-target="#modalEditarCliente"][data-id="${id}"]`);
    const telOriginal = normalizaTel(triggerBtn?.dataset?.telefono || '');
    if (tel !== telOriginal && telefonosExistentes.has(tel)) {
        e.preventDefault();
        alert('Ya existe otro cliente con ese número de teléfono.');
    }
      });

    // Búsqueda en tiempo real para el campo nombre/teléfono
    const campoNombreTelefono = document.querySelector('input[name="filtro_nombre_cliente"]');
    if (campoNombreTelefono) {
        let timeoutId;
        campoNombreTelefono.addEventListener('input', function() {
            clearTimeout(timeoutId);
            timeoutId = setTimeout(() => {
                if (this.value.length >= 2) {
                    console.log('Buscando por nombre o teléfono:', this.value);
                    this.form.submit();
                }
            }, 600); // Búsqueda automática después de 600ms
        });
    }
    
    // Mejorar la experiencia de carga diferida
    document.addEventListener('DOMContentLoaded', function() {
        // Agregar indicador de carga a los botones
        const botonesCarga = document.querySelectorAll('.btn-outline-primary, .btn-outline-success');
        botonesCarga.forEach(boton => {
            boton.addEventListener('click', function() {
                const originalHTML = this.innerHTML;
                this.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Cargando...';
                this.disabled = true;
                
                // Restaurar después de un tiempo (por si hay error)
                setTimeout(() => {
                    this.innerHTML = originalHTML;
                    this.disabled = false;
                }, 5000);
            });
        });
        
        // Mostrar mensaje cuando se cargan más clientes
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.has('cargar_mas')) {
            const cargarMas = parseInt(urlParams.get('cargar_mas'));
            const mensaje = document.createElement('div');
            mensaje.className = 'alert alert-success alert-dismissible fade show';
            
            if (cargarMas >= 999999) {
                mensaje.innerHTML = `
                    <i class="fas fa-list me-2"></i>
                    <strong>¡Todos los clientes cargados!</strong> Se han cargado todos los clientes disponibles.
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                `;
            } else {
                mensaje.innerHTML = `
                    <i class="fas fa-plus me-2"></i>
                    <strong>¡Clientes cargados exitosamente!</strong> Se han cargado ${cargarMas} clientes de un total disponible.
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                `;
            }
            
            const contenedor = document.querySelector('.client-grid');
            if (contenedor) {
                contenedor.parentNode.insertBefore(mensaje, contenedor);
            }
        }
    });
  }
  </script>