<?php
// /pages/membresia_expirada.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }

// Si por alguna razón un usuario activo o un superadmin llega aquí, lo redirigimos al dashboard.
if (isset($_SESSION['dias_restantes']) && $_SESSION['dias_restantes'] >= 0 || (isset($_SESSION['rol']) && $_SESSION['rol'] === 'superadmin')) {
    header("Location: /digitalpremium/pages/dashboard.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Membresía Expirada - DigitalPremium</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }
        .lock-container {
            max-width: 600px;
            text-align: center;
            padding: 40px;
            background-color: white;
            border-radius: 1rem;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        .lock-icon {
            font-size: 5rem;
            color: var(--bs-danger);
            margin-bottom: 1rem;
        }
        .whatsapp-button {
            font-size: 1.2rem;
            font-weight: bold;
            padding: 12px 30px;
            background-color: #25d366;
            border-color: #25d366;
            transition: all 0.3s;
        }
        .whatsapp-button:hover {
            transform: scale(1.05);
            background-color: #1da851;
            border-color: #1da851;
        }
    </style>
</head>
<body>
    <div class="lock-container">
        <i class="fas fa-lock lock-icon"></i>
        <h1 class="display-5 fw-bold">Tu Acceso ha Finalizado</h1>
        <p class="lead text-muted">Tu membresía para usar la plataforma DigitalPremium ha expirado.</p>
        <hr class="my-4">
        <h4>¿Cómo reactivar tu cuenta?</h4>
        <p>Es muy sencillo. Ponte en contacto con nosotros para coordinar la renovación de tu plan y reactivaremos tu acceso de inmediato.</p>
        
        <a href="https://wa.me/51931368643" target="_blank" class="btn btn-success whatsapp-button">
            <i class="fab fa-whatsapp me-2"></i>Contactar para Reactivar
        </a>

        <div class="mt-4">
            <a href="/digitalpremium/auth/logout.php" class="text-secondary small">Cerrar Sesión</a>
        </div>
    </div>
</body>
</html>