<?php
// /pages/pedidos_clientes.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }

// Seguridad: Solo el Super Admin puede acceder
if (!isset($_SESSION['id_usuario']) || $_SESSION['rol'] !== 'superadmin') {
    header("Location: /digitalpremium/pages/dashboard.php?error=acceso_denegado");
    exit();
}

require_once '../config/db.php';
include_once '../includes/header.php';

$filtro_estado = $_GET['filtro'] ?? 'en_revision'; // Por defecto muestra los que necesitan atención

$sql = "SELECT ped.*, prod.nombre_producto, u.nombre_completo AS nombre_cliente 
        FROM pedidos_mayorista ped
        JOIN productos_mayorista prod ON ped.id_producto = prod.id_producto
        JOIN usuarios u ON ped.id_usuario_cliente = u.id_usuario";

if ($filtro_estado !== 'todos') {
    $sql .= " WHERE ped.estado_pedido = ?";
    $stmt = $pdo->prepare($sql . " ORDER BY ped.fecha_pedido ASC");
    $stmt->execute([$filtro_estado]);
} else {
    $stmt = $pdo->query($sql . " ORDER BY ped.fecha_pedido DESC");
}
$pedidos = $stmt->fetchAll(PDO::FETCH_ASSOC);

function getBadgeClass($estado) {
    switch ($estado) {
        case 'en_revision': return 'bg-warning text-dark';
        case 'completado': return 'bg-success';
        case 'rechazado': return 'bg-danger';
        case 'pendiente': default: return 'bg-secondary';
    }
}
?>

<div class="container-fluid px-4">
    <h1 class="mt-4">Gestionar Pedidos de Clientes</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
        <li class="breadcrumb-item active">Pedidos de Clientes</li>
    </ol>

    <div class="mb-3">
        <a href="?filtro=en_revision" class="btn btn-sm <?php echo $filtro_estado === 'en_revision' ? 'btn-warning' : 'btn-outline-warning'; ?>">En Revisión</a>
        <a href="?filtro=completado" class="btn btn-sm <?php echo $filtro_estado === 'completado' ? 'btn-success' : 'btn-outline-success'; ?>">Completados</a>
        <a href="?filtro=rechazado" class="btn btn-sm <?php echo $filtro_estado === 'rechazado' ? 'btn-danger' : 'btn-outline-danger'; ?>">Rechazados</a>
        <a href="?filtro=todos" class="btn btn-sm <?php echo $filtro_estado === 'todos' ? 'btn-info' : 'btn-outline-info'; ?>">Todos</a>
    </div>

    <div class="card shadow-sm mb-4">
        <div class="card-header"><i class="fas fa-tasks me-1"></i>Listado de Pedidos</div>
        <div class="card-body">
             <?php if (isset($_GET['mensaje'])): ?>
                <div class="alert alert-<?php echo htmlspecialchars($_GET['tipo']); ?>"><?php echo htmlspecialchars(urldecode($_GET['mensaje'])); ?></div>
            <?php endif; ?>
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Cliente</th>
                            <th>Producto</th>
                            <th>Fecha</th>
                            <th>Comprobante</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($pedidos)): ?>
                            <tr><td colspan="7" class="text-center">No hay pedidos en esta categoría.</td></tr>
                        <?php else: ?>
                            <?php foreach ($pedidos as $pedido): ?>
                                <tr>
                                    <td>#<?php echo $pedido['id_pedido']; ?></td>
                                    <td><?php echo htmlspecialchars($pedido['nombre_cliente']); ?></td>
                                    <td><?php echo htmlspecialchars($pedido['nombre_producto']); ?></td>
                                    <td><?php echo date("d/m/Y h:i A", strtotime($pedido['fecha_pedido'])); ?></td>
                                    <td class="text-center">
                                        <a href="<?php echo htmlspecialchars($pedido['comprobante_url']); ?>" target="_blank" class="btn btn-info btn-sm">Ver</a>
                                    </td>
                                    <td><span class="badge <?php echo getBadgeClass($pedido['estado_pedido']); ?>"><?php echo ucfirst(str_replace('_', ' ', $pedido['estado_pedido'])); ?></span></td>
                                    <td class="text-center">
                                        <?php if ($pedido['estado_pedido'] === 'en_revision'): ?>
                                            <a href="provisionar_pedido.php?id_pedido=<?php echo $pedido['id_pedido']; ?>" class="btn btn-primary btn-sm">Gestionar</a>
                                        <?php else: ?>
                                            <button class="btn btn-secondary btn-sm" disabled>Gestionado</button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include_once '../includes/footer.php'; ?>