<?php
// FILE: /digitalpremium/pages/perfiles_vendidos_crear.php (Diseño COMPLETAMENTE Mejorado e Intuitivo)

// --- MODO DEPURACIÓN: Activar la visualización de errores ---
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// --- FIN MODO DEPURACIÓN ---

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['id_usuario'])) {
    header("Location: /digitalpremium/login.php");
    exit();
}
// Dueño de la data (propietario o el mismo usuario si no hay subcuenta)
// Usar directamente el id_usuario_sesion para las ventas

require_once '../config/db.php'; // Incluye la conexión PDO ($pdo)
// Asegúrate de que message_helper.php contenga getConfigValue, limpiarNumeroWhatsApp y generarMensajeParaCliente
require_once '../includes/message_helper.php';

// --- 1. OBTENER DATOS DE SESIÓN ---
$id_usuario_sesion = $_SESSION['id_usuario'];
$rol_usuario_sesion = $_SESSION['rol'];

// Definir OWNER_ID para multi-tenancy
require_once '../includes/tenant_helper.php';
$OWNER_ID = get_data_owner_id($pdo);

// --- 2. GESTIÓN DEL MODO EDICIÓN ---
$modo_edicion = false;
$suscripcion_a_editar = null; // Almacenará los datos de la suscripción si estamos editando
$id_perfil_vendido_editar = null; // ID del perfil si estamos en modo edición

// Inicializar la variable para evitar errores
if (!isset($suscripcion_a_editar)) {
    $suscripcion_a_editar = null;
}

if (isset($_GET['editar_id'])) {
    $id_perfil_vendido_editar = filter_var($_GET['editar_id'], FILTER_VALIDATE_INT);
    if ($id_perfil_vendido_editar) {
        $sql_editar = "SELECT pv.*, cm.id_plataforma, cm.email_cuenta, cm.password_cuenta, cm.perfiles_total, cm.perfiles_disponibles, cm.estado_cuenta AS estado_cuenta_maestra, p.nombre_plataforma, c.nombre_completo AS cliente_nombre, c.telefono AS cliente_telefono
                         FROM perfiles_vendidos pv
                         JOIN cuentas_maestras cm ON pv.id_cuenta_maestra = cm.id_cuenta_maestra
                         JOIN plataformas p ON cm.id_plataforma = p.id_plataforma
                         JOIN clientes c ON pv.id_cliente = c.id_cliente
                         WHERE pv.id_perfil_vendido = :id_perfil_vendido";
        
        $params_editar = [':id_perfil_vendido' => $id_perfil_vendido_editar];

        // Para Ventas, permitir editar perfiles de otros usuarios (solo verificar que existan)
        if ($rol_usuario_sesion !== 'superadmin' && $rol_usuario_sesion !== 'admin' && $rol_usuario_sesion !== 'ventas' && $rol_usuario_sesion !== 'Ventas' && strtolower($rol_usuario_sesion) !== 'ventas') {
            $sql_editar .= " AND pv.id_usuario = :owner_id";
            $params_editar[':owner_id'] = $id_usuario_sesion;
        }


        $stmt_editar = $pdo->prepare($sql_editar);
        $stmt_editar->execute($params_editar);
        $suscripcion_a_editar = $stmt_editar->fetch(PDO::FETCH_ASSOC);
        
        if ($suscripcion_a_editar) {
            $modo_edicion = true;
            // Calcular duración en días
            $fecha_inicio_dt = new DateTime($suscripcion_a_editar['fecha_inicio_servicio']);
            $fecha_fin_dt = new DateTime($suscripcion_a_editar['fecha_fin_servicio']);
            $intervalo = $fecha_inicio_dt->diff($fecha_fin_dt);
            $suscripcion_a_editar['duracion_dias'] = $intervalo->days;
        } else {
            // Si no se encuentra la suscripción o no tiene permisos
            header("Location: /digitalpremium/pages/perfiles_vendidos.php?mensaje=" . urlencode("Suscripción no encontrada o acceso denegado.") . "&tipo=danger");
            exit();
        }
    }
}

$page_title = $modo_edicion ? "Editar Suscripción - DigitalPremium" : "Nueva Venta - DigitalPremium";
// Se asume que includes/header.php ya maneja el DOCTYPE, html, head, y apertura de body
include_once '../includes/header.php';


// --- 3. CARGAR DATOS PARA LOS MENÚS DESPLEGABLES ---

// Clientes activos (del usuario logueado o todos si es superadmin)
// Clientes activos (si es superadmin o ventas ve todos, si no solo los suyos)
// NOTA: La búsqueda de clientes es flexible y maneja teléfonos con espacios, guiones, etc.
if ($rol_usuario_sesion === 'superadmin' || $rol_usuario_sesion === 'admin' || $rol_usuario_sesion === 'ventas' || $rol_usuario_sesion === 'Ventas' || strtolower($rol_usuario_sesion) === 'ventas') {
    $sql_clientes = "SELECT id_cliente, nombre_completo, telefono
                     FROM clientes
                     WHERE estado_cliente = 1
                     ORDER BY nombre_completo ASC";
    $params_clientes = [];
} else {
    $sql_clientes = "SELECT id_cliente, nombre_completo, telefono
                     FROM clientes
                     WHERE estado_cliente = 1
                       AND id_usuario = :owner_id
                     ORDER BY nombre_completo ASC";
    $params_clientes = [':owner_id' => $OWNER_ID];
}

$stmt_clientes = $pdo->prepare($sql_clientes);
$stmt_clientes->execute($params_clientes);
$clientes_activos = $stmt_clientes->fetchAll(PDO::FETCH_ASSOC);

// Plataformas activas (son globales, no dependen del usuario)
$stmt_plataformas = $pdo->query("SELECT id_plataforma, nombre_plataforma, max_perfiles_cuenta FROM plataformas WHERE estado = 1 ORDER BY nombre_plataforma ASC");
$plataformas_activas = $stmt_plataformas->fetchAll(PDO::FETCH_ASSOC);
$plataformas_data_js = json_encode($plataformas_activas); // Para JS: conocer max_perfiles_cuenta

// Debug: Verificar variables antes de la consulta
error_log("DEBUG: modo_edicion = " . ($modo_edicion ? 'true' : 'false'));
error_log("DEBUG: suscripcion_a_editar = " . json_encode($suscripcion_a_editar ?? 'null'));
error_log("DEBUG: rol_usuario_sesion = " . $rol_usuario_sesion);

// Preparar array JS de TODAS las cuentas maestras activas para el usuario (o todas para superadmin)
// Esto permite que JS filtre dinámicamente.
// Preparar array JS de cuentas maestras para selección
// Tanto en creación como en edición: solo cuentas activas con perfiles disponibles
// (excepto la cuenta original del perfil que se está editando)
if ($rol_usuario_sesion === 'superadmin' || $rol_usuario_sesion === 'admin' || $rol_usuario_sesion === 'ventas' || $rol_usuario_sesion === 'Ventas' || strtolower($rol_usuario_sesion) === 'ventas') {
    if ($modo_edicion && isset($suscripcion_a_editar['id_cuenta_maestra']) && $suscripcion_a_editar['id_cuenta_maestra']) {
        // En modo edición, incluir la cuenta original (cualquier estado) + cuentas activas con perfiles disponibles
        $sql_cuentas_maestras = "SELECT id_cuenta_maestra, id_plataforma, email_cuenta, password_cuenta,
                                        perfiles_total, perfiles_disponibles, estado_cuenta
                                 FROM cuentas_maestras
                                 WHERE (estado_cuenta = 1 AND perfiles_disponibles > 0) 
                                    OR id_cuenta_maestra = :id_cuenta_original
                                 ORDER BY 
                                   CASE WHEN id_cuenta_maestra = :id_cuenta_original2 THEN 0 ELSE 1 END,
                                   email_cuenta ASC";
        $params_cuentas_maestras = [
            ':id_cuenta_original' => $suscripcion_a_editar['id_cuenta_maestra'],
            ':id_cuenta_original2' => $suscripcion_a_editar['id_cuenta_maestra']
        ];
    } else {
        // En modo creación, solo cuentas activas con perfiles disponibles
        $sql_cuentas_maestras = "SELECT id_cuenta_maestra, id_plataforma, email_cuenta, password_cuenta,
                                        perfiles_total, perfiles_disponibles, estado_cuenta
                                 FROM cuentas_maestras
                                 WHERE estado_cuenta = 1 
                                   AND perfiles_disponibles > 0
                                 ORDER BY email_cuenta ASC";
        $params_cuentas_maestras = [];
    }
} else {
    if ($modo_edicion && isset($suscripcion_a_editar['id_cuenta_maestra']) && $suscripcion_a_editar['id_cuenta_maestra']) {
        // En modo edición, incluir la cuenta original (cualquier estado) + cuentas activas con perfiles disponibles
        $sql_cuentas_maestras = "SELECT id_cuenta_maestra, id_plataforma, email_cuenta, password_cuenta,
                                        perfiles_total, perfiles_disponibles, estado_cuenta
                                 FROM cuentas_maestras
                                 WHERE ((estado_cuenta = 1 AND perfiles_disponibles > 0) 
                                    OR id_cuenta_maestra = :id_cuenta_original)
                                   AND id_usuario = :owner_id
                                 ORDER BY 
                                   CASE WHEN id_cuenta_maestra = :id_cuenta_original2 THEN 0 ELSE 1 END,
                                   email_cuenta ASC";
        $params_cuentas_maestras = [
            ':id_cuenta_original' => $suscripcion_a_editar['id_cuenta_maestra'],
            ':id_cuenta_original2' => $suscripcion_a_editar['id_cuenta_maestra'],
            ':owner_id' => $OWNER_ID
        ];
    } else {
        // En modo creación, solo cuentas activas con perfiles disponibles
        $sql_cuentas_maestras = "SELECT id_cuenta_maestra, id_plataforma, email_cuenta, password_cuenta,
                                        perfiles_total, perfiles_disponibles, estado_cuenta
                                 FROM cuentas_maestras
                                 WHERE estado_cuenta = 1 
                                   AND perfiles_disponibles > 0
                                   AND id_usuario = :owner_id
                                 ORDER BY email_cuenta ASC";
        $params_cuentas_maestras = [':owner_id' => $OWNER_ID];
    }
}

// Debug: Verificar que los parámetros estén correctos
if (empty($params_cuentas_maestras)) {
    error_log("DEBUG: Parámetros vacíos para consulta de cuentas maestras");
} else {
    error_log("DEBUG: Parámetros para consulta de cuentas maestras: " . json_encode($params_cuentas_maestras));
}

$stmt_cuentas_maestras = $pdo->prepare($sql_cuentas_maestras);
$stmt_cuentas_maestras->execute($params_cuentas_maestras);
$cuentas_maestras_js_array = $stmt_cuentas_maestras->fetchAll(PDO::FETCH_ASSOC);


// --- 4. CARGAR CONFIGURACIÓN DE MONEDA y TIPOS DE MENSAJE ---
    $moneda_simbolo = (string)getConfigValue('moneda_simbolo', $OWNER_ID, 'S/');


// Opciones personalizadas para el tipo de mensaje de activación
// Usamos las claves internas que ya están siendo manejadas en message_helper.php
$opciones_tipo_mensaje = [
    "perfil_con_pass" => "Activación con Credenciales (Email/Pass/PIN)",
    "perfil_solo_tv" => "Activación a TV (Sin Credenciales)"
];

// Valor por defecto para el selector de tipo de mensaje (ajusta si es necesario)
// Asegurarse de que el valor por defecto esté en las nuevas opciones.
$default_tipo_mensaje_activacion = getConfigValue('tipo_mensaje_activacion_default', $id_usuario_sesion, 'perfil_con_pass');
if (!array_key_exists($default_tipo_mensaje_activacion, $opciones_tipo_mensaje)) {
    $default_tipo_mensaje_activacion = array_key_first($opciones_tipo_mensaje); // Si el valor guardado no existe, usa la primera opción.
}
?>

<style>
    /* --- ESTILOS GENERALES Y DE DISEÑO PROFESIONAL --- */
    .container-fluid {
        max-width: 1200px;
    }

    /* FIX: Estilo para las etiquetas de los campos del formulario */
    .form-label {
        font-weight: 600;
        color: var(--text-muted);
        font-size: 0.9rem;
        margin-bottom: 0.5rem;
    }

    .form-step-card {
        background-color: var(--content-bg);
        border: 1px solid var(--border-color);
        border-radius: var(--border-radius-lg);
        margin-bottom: 2rem;
        box-shadow: var(--box-shadow-sm);
        transition: var(--transition-base);
        /* SOLUCIÓN: Permite que los elementos hijos (dropdowns) se muestren fuera de la tarjeta */
        overflow: visible;
        position: relative; /* Necesario para que z-index funcione */
    }

    /* Cuando un buscador dentro de la tarjeta está activo, la traemos al frente */
    .form-step-card.is-focused {
        z-index: 10;
        box-shadow: var(--box-shadow-md);
        border-color: var(--primary-color);
    }

    .form-step-header {
        padding: 1rem 1.5rem;
        background-color: var(--primary-bg-subtle);
        border-bottom: 1px solid var(--border-color);
        display: flex;
        align-items: center;
    }

    .form-step-header .step-number {
        background-color: var(--primary-color);
        color: white;
        border-radius: 50%;
        width: 32px;
        height: 32px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        margin-right: 1rem;
        flex-shrink: 0;
    }

    .form-step-header .step-title {
        font-size: 1.2rem;
        font-weight: 600;
        color: var(--primary-text-emphasis);
        margin: 0;
    }

    .form-step-card .card-body {
        padding: 2rem;
    }

    /* --- ESTILOS PARA BUSCADORES (SELECTS) --- */
    .searchable-select-container {
        position: relative;
    }
    .searchable-select-container .form-control {
        background-color: var(--content-bg);
    }
    .searchable-select-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        z-index: 1055; /* Por encima de modales y otros elementos */
        background-color: var(--content-bg);
        border: 1px solid var(--border-color);
        border-radius: var(--border-radius-md);
        max-height: 250px;
        overflow-y: auto;
        box-shadow: var(--box-shadow-lg);
        display: none;
        margin-top: 4px;
    }
    .searchable-select-item {
        padding: 0.6rem 1.2rem;
        cursor: pointer;
        transition: background-color 0.2s ease;
        border-bottom: 1px solid var(--border-color);
    }
    .searchable-select-item:last-child { border-bottom: none; }
    .searchable-select-item:hover, .searchable-select-item.highlighted {
        background-color: var(--primary-bg-subtle);
    }
    .searchable-select-item .item-text-primary {
        font-weight: 500;
        color: var(--text-dark);
    }
    .searchable-select-item .item-text-secondary {
        font-size: 0.85rem;
        color: var(--text-muted);
        display: block;
    }
    .searchable-select-item mark { background-color: var(--warning-color); padding: 0; border-radius: 2px; }
    .no-results-message { padding: 0.75rem 1.25rem; color: var(--text-muted); font-style: italic; }

    /* Tabla de Perfiles Añadidos (Modo Creación) */
    .added-profiles-table-container {
        max-height: 300px; /* Altura máxima para la tabla */
        overflow-y: auto; /* Scroll si el contenido excede la altura */
        border: 1px solid var(--border-color);
        border-radius: var(--border-radius-md);
    }

    .added-profiles-table thead th {
        background-color: var(--light-bg);
        position: sticky;
        top: 0;
        z-index: 1;
        font-weight: 600;
        color: var(--text-muted);
        padding: 1rem;
        border-bottom: 2px solid var(--border-color);
        text-transform: uppercase;
        font-size: 0.8rem;
        letter-spacing: 0.05em;
    }
    .added-profiles-table tbody td {
        vertical-align: middle;
        padding: 0.75rem 1rem;
    }
    .added-profiles-table tbody tr:hover {
        background-color: var(--primary-bg-subtle);
    }
    .added-profiles-table .btn-sm {
        padding: 0.3rem 0.6rem;
        font-size: 0.8rem;
        border-radius: var(--border-radius-sm);
    }
    .no-profiles-message td {
        font-style: italic;
        color: #6c757d;
        padding: 2rem !important;
    }

    /* Selector de Tipo de Mensaje con Botones */
    .message-type-selector .btn {
        border-color: var(--border-color);
        background-color: var(--content-bg);
        color: var(--text-muted);
        flex-grow: 1;
    }
    .message-type-selector .btn-check:checked + .btn {
        background-color: var(--primary-color);
        border-color: var(--primary-color);
        color: white;
        box-shadow: var(--box-shadow-sm);
    }

    /* Clases para ocultar/mostrar en modo edición/creación */
    .create-mode-section {
        <?php echo $modo_edicion ? 'display: none;' : ''; ?>
    }

    .edit-mode-section {
        <?php echo !$modo_edicion ? 'display: none;' : ''; ?>
    }

    /* Botones de acción finales */
    .form-actions {
        padding-top: 1.5rem;
        margin-top: 1.5rem;
        border-top: 1px solid var(--border-color);
    }
</style>

<div class="container-fluid px-4">
    <header class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="h3 text-primary">
            <i class="fas fa-<?php echo $modo_edicion ? 'edit' : 'cart-plus'; ?> me-2"></i>
            <?php echo htmlspecialchars($page_title); ?>
        </h1>
    </header>
    
    <?php if (isset($_SESSION['form_error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo htmlspecialchars((string)$_SESSION['form_error']); unset($_SESSION['form_error']); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <form action="/digitalpremium/actions/perfiles_vendidos_controlador.php" method="POST" id="formSuscripcion">
        <input type="hidden" name="accion" value="<?php echo $modo_edicion ? 'editar_perfil_vendido' : 'agregar_multiples_perfiles'; ?>">
        <?php if ($modo_edicion): ?>
            <input type="hidden" name="id_perfil_vendido" value="<?php echo htmlspecialchars((string)($suscripcion_a_editar['id_perfil_vendido'] ?? '')); ?>">
            <input type="hidden" name="id_cuenta_maestra_original" value="<?php echo htmlspecialchars((string)($suscripcion_a_editar['id_cuenta_maestra'] ?? '')); ?>">
            
            <!-- PRESERVAR FILTROS DE LA PÁGINA ANTERIOR -->
            <?php
            // Parámetros de filtro a preservar
            $filtros_preservar = [
                'buscar', 'filtro_estado', 'filtro_estado_cm', 'filtro_tipo_cuenta', 
                'filtro_vendedor', 'filtro_fecha_inicio', 'filtro_fecha_fin', 
                'filtro_precio_min', 'filtro_precio_max', 'ordenar_por', 'orden'
            ];
            
            // Estrategia de preservación de filtros más robusta
            $filtros_a_enviar = [];
            
            // 1. Prioridad: Filtros en la URL actual (GET)
            foreach ($filtros_preservar as $filtro) {
                if (isset($_GET[$filtro]) && $_GET[$filtro] !== '') {
                    $filtros_a_enviar[$filtro] = $_GET[$filtro];
                }
            }
            
            // 2. Si no hay filtros en GET, intentar desde HTTP_REFERER
            if (empty($filtros_a_enviar)) {
                $referer = $_SERVER['HTTP_REFERER'] ?? '';
                if (strpos($referer, 'perfiles_vendidos.php') !== false) {
                    $url_parts = parse_url($referer);
                    if (isset($url_parts['query'])) {
                        parse_str($url_parts['query'], $query_params);
                        
                        foreach ($filtros_preservar as $filtro) {
                            if (isset($query_params[$filtro]) && $query_params[$filtro] !== '') {
                                $filtros_a_enviar[$filtro] = $query_params[$filtro];
                            }
                        }
                    }
                }
            }
            
            // 3. Si aún no hay filtros, intentar desde SESSION (para mantener filtros entre ediciones)
            if (empty($filtros_a_enviar) && isset($_SESSION['filtros_perfiles_vendidos'])) {
                $filtros_a_enviar = $_SESSION['filtros_perfiles_vendidos'];
            }
            
            // 4. Enviar todos los filtros encontrados como campos ocultos
            foreach ($filtros_a_enviar as $filtro => $valor) {
                echo '<input type="hidden" name="' . htmlspecialchars($filtro) . '" value="' . htmlspecialchars($valor) . '">';
            }
            
            // 5. Debug: Mostrar qué filtros se están preservando
            if (!empty($filtros_a_enviar)) {
                echo '<!-- DEBUG: Filtros preservados: ' . json_encode($filtros_a_enviar) . ' -->';
            } else {
                echo '<!-- DEBUG: No se encontraron filtros para preservar -->';
            }
            ?>
        <?php endif; ?>

        <!-- Paso 1: Seleccionar Cliente -->
        <div class="card form-step-card">
            <div class="form-step-header">
                <span class="step-number">1</span>
                <h5 class="step-title">Seleccionar Cliente</h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-lg-12">
                        <label for="id_cliente" class="form-label">Cliente <span class="text-danger">*</span></label>
                        <div class="input-group" id="cliente_search_container">
                            <span class="input-group-text"><i class="fas fa-search"></i></span>
                            <input type="text" class="form-control" id="cliente_search_input" placeholder="Buscar por nombre o teléfono..." autocomplete="off" <?php echo $modo_edicion ? 'disabled' : ''; ?>>
                            <input type="hidden" name="id_cliente" id="id_cliente_hidden" required>
                            <div class="searchable-select-dropdown" id="cliente_search_dropdown"></div>
                            <?php if (!$modo_edicion): ?>
                            <button class="btn btn-outline-primary" type="button" data-bs-toggle="modal" data-bs-target="#modalNuevoCliente" title="Agregar Nuevo Cliente">
                                <i class="fas fa-plus"></i>
                            </button>
                            <?php else: ?>
                                <input type="hidden" name="id_cliente" value="<?php echo htmlspecialchars((string)($suscripcion_a_editar['id_cliente'] ?? '')); ?>">
                            <?php endif; ?>
                        </div>
                        <small class="form-text text-muted">
                            <i class="fas fa-info-circle me-1"></i>
                            La búsqueda es flexible: puedes buscar por nombre completo o teléfono (con o sin espacios, guiones, paréntesis).
                        </small>
                    </div>
                </div>
            </div>
        </div>

        <?php if (!$modo_edicion): // Esta sección solo para Modo Creación (Múltiples Ventas) ?>
        <!-- Paso 2: Configurar y Añadir Perfiles (Modo Creación) -->
        <div class="card form-step-card create-mode-section">
            <div class="form-step-header">
                <span class="step-number">2</span>
                <h5 class="step-title">Configurar y Añadir Perfiles</h5>
            </div>
            <div class="card-body">
                    <h5 class="mb-4 text-primary"><i class="fas fa-plus-square me-2"></i>Añadir Nuevo Perfil a la Venta</h5>
                    <div class="row g-3 profile-item-form">
                        <div class="col-md-6">
                            <label for="profile_add_platform" class="form-label">Plataforma del Perfil <span class="text-danger">*</span></label>
                            <div class="input-group" id="platform_search_container">
                                <span class="input-group-text"><i class="fas fa-search"></i></span>
                                <input type="text" class="form-control" id="platform_search_input" placeholder="Buscar plataforma..." autocomplete="off" required>
                                <input type="hidden" id="profile_add_platform_hidden">
                                <div class="searchable-select-dropdown" id="platform_search_dropdown"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label for="profile_add_account" class="form-label">Cuenta Maestra del Perfil <span class="text-danger">*</span></label>
                            <div class="input-group" id="account_search_container">
                                <span class="input-group-text"><i class="fas fa-search"></i></span>
                                <input type="text" class="form-control" id="account_search_input" placeholder="Seleccione una plataforma primero..." autocomplete="off" required disabled>
                                <input type="hidden" id="profile_add_account_hidden">
                                <div class="searchable-select-dropdown" id="account_search_dropdown"></div>
                                <button class="btn btn-outline-primary" type="button" data-bs-toggle="modal" data-bs-target="#modalNuevaCuentaMaestra" title="Agregar Nueva Cuenta Maestra" id="btnNuevaCuentaMaestraDynamic" disabled>
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                            <small class="form-text text-muted" id="current_cm_available_profiles">Perfiles disponibles: 0</small>
                        </div>
                        <div class="col-md-6">
                            <label for="profile_add_name" class="form-label">Nombre del Perfil <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-user-tag"></i></span>
                                <input type="text" class="form-control" id="profile_add_name" placeholder="Ej: Perfil de María" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label for="profile_add_pin" class="form-label">PIN del Perfil (Opcional)</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-lock"></i></span>
                                <input type="text" class="form-control" id="profile_add_pin" placeholder="Ej: 1234" maxlength="10">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label for="profile_add_fecha_inicio" class="form-label">Fecha Inicio <span class="text-danger">*</span></label>
                             <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
                                <input type="date" class="form-control" id="profile_add_fecha_inicio" value="<?php echo date('Y-m-d'); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label for="profile_add_duracion_dias" class="form-label">Duración (días) <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-hourglass-half"></i></span>
                                <input type="number" class="form-control" id="profile_add_duracion_dias" value="30" min="1" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label for="profile_add_fecha_fin" class="form-label">Fecha Fin (calculada)</label>
                             <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-calendar-check"></i></span>
                                <input type="date" class="form-control" id="profile_add_fecha_fin" readonly style="background-color: #e9ecef;">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label for="profile_add_precio_venta" class="form-label">Precio de Venta (<?php echo htmlspecialchars($moneda_simbolo); ?>) <span class="text-danger">*</span></label>
                            <div class="input-group">
                                 <span class="input-group-text"><?php echo htmlspecialchars($moneda_simbolo); ?></span>
                                <input type="number" step="0.01" class="form-control" id="profile_add_precio_venta" placeholder="0.00" value="" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label for="profile_add_estado_suscripcion" class="form-label">Estado Suscripción <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-toggle-on"></i></span>
                                <select class="form-select" id="profile_add_estado_suscripcion" required>
                                    <option value="1" selected>Activa</option>
                                    <option value="0">Vencida</option>
                                    <option value="2">Cancelada</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12 mt-4 text-center">
                            <button type="button" class="btn btn-info" id="btn-add-profile-to-list">
                                <i class="fas fa-plus-circle me-2"></i> Añadir Perfil a la Lista
                            </button>
                        </div>
                    </div>

                <h5 class="mb-3 border-bottom pb-2 mt-4"><i class="fas fa-clipboard-list me-2"></i>Perfiles Añadidos a esta Venta</h5>
                <div class="added-profiles-table-container">
                    <table class="table table-hover table-striped added-profiles-table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Plataforma</th>
                                <th>Cuenta Maestra</th>
                                <th>Perfil</th>
                                <th>Vence</th>
                                <th>Precio</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="added-profiles-list-tbody">
                            <tr class="no-profiles-message"><td colspan="7" class="text-center text-muted py-4">No hay perfiles añadidos aún.</td></tr>
                        </tbody>
                    </table>
                    <input type="hidden" name="perfiles_json" id="perfiles_json_input">
                </div>
            </div>
        </div>
        <?php else: // MODO EDICIÓN: La estructura original del formulario para un solo perfil ?>
        <!-- Detalles del Perfil Existente (Modo Edición) -->
        <div class="card form-step-card edit-mode-section">
             <div class="form-step-header">
                <span class="step-number">2</span>
                <h5 class="step-title">Detalles del Perfil Existente</h5>
            </div>
            <div class="card-body">
                 <div class="row mb-4">
  <div class="col-md-6">
    <label for="platform_search_input_edit" class="form-label">Plataforma <span class="text-danger">*</span></label>
    <div class="input-group" id="platform_search_container_edit">
        <span class="input-group-text"><i class="fas fa-search"></i></span>
        <input type="text" class="form-control" id="platform_search_input_edit" placeholder="Buscar plataforma..." autocomplete="off" required>
        <input type="hidden" id="id_plataforma_edit_hidden">
        <div class="searchable-select-dropdown" id="platform_search_dropdown_edit"></div>
    </div>
    <small class="form-text text-muted">Puedes cambiar la plataforma del perfil.</small>
  </div>

  <div class="col-md-6">
    <label for="account_search_input_edit" class="form-label">Cuenta Maestra <span class="text-danger">*</span></label>
    <div class="input-group" id="account_search_container_edit">
        <span class="input-group-text"><i class="fas fa-search"></i></span>
        <input type="text" class="form-control" id="account_search_input_edit" placeholder="Buscar cuenta maestra..." autocomplete="off" required>
        <input type="hidden" name="id_cuenta_maestra" id="id_cuenta_maestra_hidden">
        <div class="searchable-select-dropdown" id="account_search_dropdown_edit"></div>
      <button class="btn btn-outline-primary" type="button" id="btnNuevaCuentaMaestraEdit"
              data-bs-toggle="modal" data-bs-target="#modalNuevaCuentaMaestra"
              title="Agregar Nueva Cuenta Maestra">
        <i class="fas fa-plus"></i>
      </button>
    </div>
    <small id="cuentaMaestraHelp" class="form-text text-muted">
      <strong>En modo edición:</strong> Se muestra la cuenta actual (incluso si está inactiva o con problemas) + cuentas activas con perfiles disponibles para poder cambiar de cuenta.
      <br><strong>En modo creación:</strong> Solo se muestran cuentas activas con perfiles disponibles.
      <br>Si no hay cuentas disponibles, crea una nueva con el botón "+".
    </small>
  </div>
</div>

                <h5 class="mb-3 border-bottom pb-2">Datos del Perfil para el Cliente</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="nombre_perfil_cliente" class="form-label">Nombre del Perfil <span class="text-danger">*</span></label>
                         <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-id-badge"></i></span>
                            <input type="text" class="form-control" id="nombre_perfil_cliente" name="nombre_perfil_cliente" placeholder="Ej: Perfil de Juan, Sala TV" value="<?php echo htmlspecialchars((string)($suscripcion_a_editar['nombre_perfil_cliente'] ?? '')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label for="pin_perfil_cliente" class="form-label">PIN del Perfil (Opcional)</label>
                         <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-key"></i></span>
                            <input type="text" class="form-control" id="pin_perfil_cliente" name="pin_perfil_cliente" placeholder="Ej: 1234" maxlength="10" value="<?php echo htmlspecialchars((string)($suscripcion_a_editar['pin_perfil_cliente'] ?? '')); ?>">
                        </div>
                    </div>
                </div>
                <div class="row g-3 mt-3">
                    <div class="col-md-4">
                        <label for="fecha_inicio_servicio" class="form-label">Fecha Inicio <span class="text-danger">*</span></label>
                         <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
                            <input type="date" class="form-control" id="fecha_inicio_servicio" name="fecha_inicio_servicio" value="<?php echo htmlspecialchars((string)($suscripcion_a_editar['fecha_inicio_servicio'] ?? date('Y-m-d'))); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label for="duracion_dias" class="form-label">Duración (días) <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-hourglass-half"></i></span>
                            <input type="number" class="form-control" id="duracion_dias" name="duracion_dias" value="<?php echo htmlspecialchars((string)($suscripcion_a_editar['duracion_dias'] ?? '30')); ?>" min="1" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label for="fecha_fin_servicio" class="form-label">Fecha Fin (calculada)</label>
                         <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-calendar-check"></i></span>
                            <input type="date" class="form-control" id="fecha_fin_servicio" name="fecha_fin_servicio" value="<?php echo htmlspecialchars((string)($suscripcion_a_editar['fecha_fin_servicio'] ?? '')); ?>" readonly style="background-color: #e9ecef;">
                        </div>
                    </div>
                </div>
                <div class="row g-3 mt-3">
                    <div class="col-md-6">
                        <label for="precio_venta" class="form-label">Precio de Venta (<?php echo htmlspecialchars($moneda_simbolo); ?>) <span class="text-danger">*</span></label>
                        <div class="input-group">
                             <span class="input-group-text"><?php echo htmlspecialchars($moneda_simbolo); ?></span>
                            <input type="number" step="0.01" class="form-control" id="precio_venta" name="precio_venta" placeholder="0.00" value="<?php echo htmlspecialchars((string)($suscripcion_a_editar['precio_venta'] ?? '')); ?>" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label for="estado_suscripcion" class="form-label">Estado Suscripción <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-toggle-on"></i></span>
                            <select class="form-select" id="estado_suscripcion" name="estado_suscripcion" required>
                                <option value="1" <?php echo ($suscripcion_a_editar['estado_suscripcion'] ?? null) == 1 ? 'selected' : ''; ?>>Activa</option>
                                <option value="0" <?php echo ($suscripcion_a_editar['estado_suscripcion'] ?? null) == 0 ? 'selected' : ''; ?>>Vencida</option>
                                <option value="2" <?php echo ($suscripcion_a_editar['estado_suscripcion'] ?? null) == 2 ? 'selected' : ''; ?>>Cancelada</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-12 mt-3">
                    <?php if (isset($suscripcion_a_editar['estado_cuenta_maestra']) && $suscripcion_a_editar['estado_cuenta_maestra'] != 1): ?>
                        <div class="alert alert-warning d-flex align-items-center mb-3" role="alert">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <div>
                                <strong>Cuenta Maestra <?php echo $suscripcion_a_editar['estado_cuenta_maestra'] == 0 ? 'Inactiva' : 'Con Problemas'; ?></strong>
                                <br>
                                <small class="text-muted">
                                    La cuenta maestra asociada está <?php echo $suscripcion_a_editar['estado_cuenta_maestra'] == 0 ? 'inactiva' : 'con problemas'; ?>, 
                                    pero puedes editar la nota de suscripción. Para activar perfiles, mueve la venta a una cuenta maestra activa.
                                </small>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <label for="notas_suscripcion" class="form-label">Notas Adicionales (Opcional)</label>
                     <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-sticky-note"></i></span>
                        <textarea class="form-control" id="notas_suscripcion" name="notas_suscripcion" rows="3" placeholder="Anotaciones internas sobre la venta o el cliente..."><?php echo htmlspecialchars((string)($suscripcion_a_editar['notas_suscripcion'] ?? '')); ?></textarea>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; // Fin MODO EDICIÓN ?>

        <!-- Paso 3: Opciones Finales y Notas -->
        <div class="card form-step-card">
            <div class="form-step-header">
                <span class="step-number">3</span>
                <h5 class="step-title">Opciones Finales y Notas</h5>
            </div>
            <div class="card-body">
                <div class="mb-4">
                    <label for="tipo_mensaje_activacion" class="form-label">Tipo de Mensaje de Activación <span class="text-danger">*</span></label>
                    <div class="btn-group d-flex flex-wrap message-type-selector" role="group" aria-label="Tipo de Mensaje">
                        <?php foreach ($opciones_tipo_mensaje as $value => $label): ?>
                            <input type="radio" class="btn-check" name="tipo_mensaje_activacion" id="msg_type_<?php echo htmlspecialchars($value); ?>" value="<?php echo htmlspecialchars($value); ?>" autocomplete="off" <?php echo ($default_tipo_mensaje_activacion == $value) ? 'checked' : ''; ?>>
                            <label class="btn btn-outline-primary" for="msg_type_<?php echo htmlspecialchars($value); ?>">
                                <?php echo htmlspecialchars($label); ?>
                            </label>
                        <?php endforeach; ?>
                    </div>
                    <small class="form-text text-muted">Seleccione el formato del mensaje que se generará para el cliente (ej. si incluye contraseña o solo pide código de TV).</small>
                </div>
                
                <div class="col-12">
                    <label for="notas_suscripcion_general" class="form-label">Notas Adicionales Generales (Opcional)</label>
                     <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-sticky-note"></i></span>
                        <textarea class="form-control" id="notas_suscripcion_general" name="notas_suscripcion_general" rows="3" placeholder="Anotaciones internas sobre la venta o el cliente..."></textarea>
                    </div>
                </div>
            </div>
        </div>

        <div class="d-flex justify-content-end form-actions">
            <a href="/digitalpremium/pages/perfiles_vendidos.php" class="btn btn-outline-secondary me-2">
                <i class="fas fa-times me-1"></i>Cancelar
            </a>
            <button type="submit" class="btn btn-<?php echo $modo_edicion ? 'warning' : 'success'; ?>" id="submit-button">
                <i class="fas fa-<?php echo $modo_edicion ? 'save' : 'check-circle'; ?> me-1"></i>
                <?php echo $modo_edicion ? 'Actualizar Suscripción' : 'Guardar Venta(s)'; ?>
            </button>
        </div>
    </form>
</div>

<!-- Modal para Agregar Nuevo Cliente -->
<div class="modal fade" id="modalNuevoCliente" tabindex="-1" aria-labelledby="modalNuevoClienteLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalNuevoClienteLabel"><i class="fas fa-user-plus me-2"></i>Agregar Nuevo Cliente</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="error-container-cliente" class="alert alert-danger d-none"></div>
                <form id="formNuevoCliente">
                    <input type="hidden" name="accion" value="agregar">
                    <input type="hidden" name="ajax_request" value="1">
                    <input type="hidden" name="estado_cliente" value="1">
                    <div class="mb-3">
                        <label for="modal_nombre_completo" class="form-label">Nombre Completo <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="modal_nombre_completo" name="nombre_completo" required>
                    </div>
                    <div class="mb-3">
                        <label for="modal_telefono" class="form-label">Teléfono (WhatsApp) <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="modal_telefono" name="telefono" required>
                    </div>
                    <div class="mb-3">
                        <label for="modal_email" class="form-label">Email (Opcional)</label>
                        <input type="email" class="form-control" id="modal_email" name="email">
                    </div>
                    <div class="mb-3">
                        <label for="modal_notas_cliente" class="form-label">Notas (Opcional)</label>
                        <textarea class="form-control" id="modal_notas_cliente" name="notas_cliente" rows="2"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="btnGuardarCliente">Guardar Cliente</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal para Agregar Nueva Cuenta Maestra -->
<div class="modal fade" id="modalNuevaCuentaMaestra" tabindex="-1" aria-labelledby="modalNuevaCuentaMaestraLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalNuevaCuentaMaestraLabel"><i class="fas fa-plus-circle me-2"></i>Agregar Nueva Cuenta Maestra</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="error-container-cuenta" class="alert alert-danger d-none"></div>
                <form id="formNuevaCuentaMaestra">
                    <input type="hidden" name="accion" value="agregar">
                    <input type="hidden" name="ajax_request" value="1">
                    <input type="hidden" name="estado_cuenta" value="1">
                    <input type="hidden" id="modal_id_plataforma" name="id_plataforma">
                    
                    <div class="mb-3 bg-light p-3 rounded">
                        <label class="form-label">Plataforma</label>
                        <input type="text" class="form-control-plaintext fw-bold" id="modal_nombre_plataforma" readonly>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="modal_email_cuenta" class="form-label">Email de la Cuenta <span class="text-danger">*</span></label>
                            <input type="email" class="form-control" id="modal_email_cuenta" name="email_cuenta" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="modal_password_cuenta" class="form-label">Contraseña de la Cuenta <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="modal_password_cuenta" name="password_cuenta" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="modal_fecha_compra_proveedor" class="form-label">Fecha de Compra Proveedor <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="modal_fecha_compra_proveedor" name="fecha_compra_proveedor" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="modal_dias_membresia" class="form-label">Duración (días) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="modal_dias_membresia" value="30" min="1" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="modal_fecha_vencimiento" class="form-label">Fecha de Vencimiento (calculada) <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="modal_fecha_vencimiento" name="fecha_vencimiento_proveedor" required>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="modal_costo_compra" class="form-label">Costo de Compra (<?php echo htmlspecialchars($moneda_simbolo); ?>) <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" class="form-control" id="modal_costo_compra" name="costo_compra" placeholder="0.00" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="modal_nombre_proveedor" class="form-label">Nombre del Proveedor <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="modal_nombre_proveedor" name="nombre_proveedor" placeholder="Ej: Proveedor X" required>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3"><label for="modal_perfiles_total" class="form-label">Perfiles Totales <span class="text-danger">*</span></label><input type="number" class="form-control" id="modal_perfiles_total" name="perfiles_total" value="5" min="1" required></div>
                        <div class="col-md-6 mb-3"><label for="modal_notas_cuenta" class="form-label">Notas (Opcional)</label><input type="text" class="form-control" id="modal_notas_cuenta" name="notas_cuenta"></div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="btnGuardarCuentaMaestra">Guardar Cuenta</button>
            </div>
        </div>
    </div>
</div>

<?php include_once '../includes/footer.php'; ?>

<script>
// --- ALMACENAMIENTO DE DATOS INICIALES ---
const todasLasCuentasMaestras = <?php echo json_encode($cuentas_maestras_js_array); ?>;
const todosLosClientes = <?php echo json_encode($clientes_activos); ?>;
const todasLasPlataformas = <?php echo json_encode($plataformas_activas); ?>; 
const modoEdicion = <?php echo $modo_edicion ? 'true' : 'false'; ?>;

// Para modo edición: datos del perfil a editar
const idPerfilVendidoEdit = modoEdicion ? parseInt('<?php echo (int)($suscripcion_a_editar['id_perfil_vendido'] ?? 0); ?>', 10) : null;
const idCuentaMaestraOriginal = modoEdicion ? parseInt('<?php echo (int)($suscripcion_a_editar['id_cuenta_maestra'] ?? 0); ?>', 10) : null;
const idPlataformaOriginal = modoEdicion ? parseInt('<?php echo (int)($suscripcion_a_editar['id_plataforma'] ?? 0); ?>', 10) : null;

let addedProfilesData = []; // Array para almacenar los perfiles que se van añadiendo


// --- INICIO: LÓGICA PARA SELECTORES CON BÚSQUEDA ---
// Función mejorada que incluye búsqueda flexible de teléfonos para clientes
function createSearchableSelect(config) {
    const container = document.getElementById(config.containerId);
    if (!container) return;

    const searchInput = container.querySelector('input[type="text"]');
    const hiddenInput = container.querySelector('input[type="hidden"]');
    const dropdown = container.querySelector('.searchable-select-dropdown');

    let data = config.data || [];
    let highlightedIndex = -1;

    // Función para normalizar teléfonos (eliminar espacios, guiones, etc.)
    function normalizarTelefono(telefono) {
        if (!telefono) return '';
        let telefonoLimpio = telefono.toString().replace(/[\s\-\(\)\+\.]/g, '');
        
        // Si empieza con código de país 51 (Perú) y tiene más de 9 dígitos, remover el código
        if (telefonoLimpio.startsWith('51') && telefonoLimpio.length > 9) {
            telefonoLimpio = telefonoLimpio.substring(2);
        }
        
        return telefonoLimpio;
    }

    function filterData(searchTerm) {
        if (!searchTerm) return data;
        const lowerCaseSearchTerm = searchTerm.toLowerCase();
        const searchTermNormalizado = normalizarTelefono(searchTerm);
        
        // Debug para búsqueda de clientes
        if (config.containerId === 'cliente_search_container') {
            console.log('🔍 Búsqueda de cliente:', {
                terminoOriginal: searchTerm,
                terminoNormalizado: searchTermNormalizado,
                terminoMinusculas: lowerCaseSearchTerm
            });
        }
        
        return data.filter(item => {
            // Búsqueda normal en campos de texto
            const textMatch = config.searchFields.some(field => {
                if (!item[field]) return false;
                const fieldValue = item[field].toString().toLowerCase();
                return fieldValue.includes(lowerCaseSearchTerm);
            });
            
            // Si es búsqueda de cliente, también buscar por teléfono normalizado
            if (config.containerId === 'cliente_search_container' && item.telefono) {
                const telefonoNormalizado = normalizarTelefono(item.telefono);
                
                // Debug para teléfonos
                console.log('📞 Comparando teléfonos:', {
                    cliente: item.nombre_completo,
                    telefonoOriginal: item.telefono,
                    telefonoNormalizado: telefonoNormalizado,
                    terminoBusqueda: searchTermNormalizado,
                    coincidenciaDirecta: telefonoNormalizado.includes(searchTermNormalizado)
                });
                
                // Búsqueda directa con el término normalizado
                if (telefonoNormalizado.includes(searchTermNormalizado)) {
                    console.log('✅ Coincidencia directa encontrada');
                    return true;
                }
                
                // Búsqueda inversa: si el término de búsqueda es más largo, buscar si contiene el teléfono
                if (searchTermNormalizado.length > telefonoNormalizado.length && 
                    searchTermNormalizado.includes(telefonoNormalizado)) {
                    console.log('✅ Coincidencia inversa encontrada');
                    return true;
                }
                
                // Búsqueda por coincidencia parcial (últimos 6-9 dígitos)
                if (telefonoNormalizado.length >= 6 && searchTermNormalizado.length >= 6) {
                    const ultimosDigitos = telefonoNormalizado.slice(-6);
                    const ultimosDigitosBusqueda = searchTermNormalizado.slice(-6);
                    if (ultimosDigitos === ultimosDigitosBusqueda) {
                        console.log('✅ Coincidencia parcial encontrada');
                        return true;
                    }
                }
            }
            
            return textMatch;
        });
    }

    function renderDropdown(items, searchTerm = '') {
        dropdown.innerHTML = '';
        highlightedIndex = -1;
        if (items.length === 0) {
            dropdown.innerHTML = `<div class="no-results-message">${config.noResultsText || 'No se encontraron resultados.'}</div>`;
        } else {
            items.forEach((item, index) => {
                const el = document.createElement('div');
                el.classList.add('searchable-select-item');
                el.dataset.value = item[config.valueField];
                
                let primaryText = item[config.primaryTextField] || '';
                let secondaryText = config.secondaryTextField ? (item[config.secondaryTextField] || '') : '';

                if (searchTerm) {
                    // Resaltar coincidencias en texto normal
                    const regex = new RegExp(`(${searchTerm.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&')})`, 'gi');
                    primaryText = primaryText.replace(regex, '<mark>$1</mark>');
                    if(secondaryText) secondaryText = secondaryText.replace(regex, '<mark>$1</mark>');
                    
                    // Si es búsqueda de cliente y hay teléfono, también resaltar coincidencias en teléfono normalizado
                    if (config.containerId === 'cliente_search_container' && item.telefono) {
                        const telefonoNormalizado = normalizarTelefono(item.telefono);
                        const searchTermNormalizado = normalizarTelefono(searchTerm);
                        if (telefonoNormalizado.includes(searchTermNormalizado)) {
                            // Agregar indicador visual de que se encontró por teléfono
                            secondaryText = `<span class="text-success"><i class="fas fa-phone me-1"></i>${secondaryText}</span>`;
                        }
                    }
                }

                el.innerHTML = `<span class="item-text-primary">${primaryText}</span>` + 
                               (secondaryText ? `<span class="item-text-secondary">${secondaryText}</span>` : '');

                el.addEventListener('mousedown', (e) => {
                    e.preventDefault();
                    selectItem(item);
                });
                dropdown.appendChild(el);
            });
        }
        dropdown.style.display = 'block';
    }

    function selectItem(item) {
        searchInput.value = item[config.primaryTextField];
        hiddenInput.value = item[config.valueField];
        dropdown.style.display = 'none';
        if (config.onSelect) {
            config.onSelect(item[config.valueField], item);
        }
        // Disparar un evento 'change' en el input oculto para compatibilidad
        hiddenInput.dispatchEvent(new Event('change'));
    }

    searchInput.addEventListener('focus', () => {
        // Cerrar otros dropdowns y quitar foco de otras tarjetas
        document.querySelectorAll('.searchable-select-dropdown').forEach(d => {
            if (d !== dropdown) {
                d.style.display = 'none';
            }
        });
        document.querySelectorAll('.form-step-card.is-focused').forEach(card => {
            card.classList.remove('is-focused');
        });

        // Abrir este dropdown y poner foco en su tarjeta
        container.closest('.form-step-card')?.classList.add('is-focused');
        renderDropdown(filterData(searchInput.value), searchInput.value);
    });
    function updateHighlight() {
        Array.from(dropdown.children).forEach((child, index) => {
            child.classList.toggle('highlighted', index === highlightedIndex);
        });
    }

    searchInput.addEventListener('input', () => {
        renderDropdown(filterData(searchInput.value), searchInput.value);
    });

    searchInput.addEventListener('keydown', (e) => {
        const items = dropdown.querySelectorAll('.searchable-select-item');
        if (items.length === 0) return;

        if (e.key === 'ArrowDown') {
            e.preventDefault();
            highlightedIndex = (highlightedIndex + 1) % items.length;
            updateHighlight();
        } else if (e.key === 'ArrowUp') {
            e.preventDefault();
            highlightedIndex = (highlightedIndex - 1 + items.length) % items.length;
            updateHighlight();
        } else if (e.key === 'Enter') {
            e.preventDefault();
            if (highlightedIndex > -1) {
                const selectedValue = items[highlightedIndex].dataset.value;
                const selectedItem = data.find(d => d[config.valueField].toString() === selectedValue);
                if (selectedItem) selectItem(selectedItem);
            }
        } else if (e.key === 'Escape') {
            dropdown.style.display = 'none';
        }
    });

    // Public method to update data
    container.updateData = (newData) => {
        data = newData;
        // Optionally, re-render if dropdown is visible
        if (dropdown.style.display === 'block') {
            renderDropdown(filterData(searchInput.value), searchInput.value);
        }
    };

    // Public method to set value
    container.setValue = (value) => {
        const selectedItem = data.find(d => d[config.valueField].toString() === value.toString());
        if (selectedItem) {
            selectItem(selectedItem);
        } else {
            searchInput.value = '';
            hiddenInput.value = '';
        }
    };

    // Public method to clear value
    container.clear = () => {
        searchInput.value = '';
        hiddenInput.value = '';
        if (config.onSelect) config.onSelect('', null);
        hiddenInput.dispatchEvent(new Event('change'));
    };
}
// --- FIN: LÓGICA PARA SELECTORES CON BÚSQUEDA ---


document.addEventListener('click', function(e) {
    // Cierra cualquier dropdown abierto si se hace clic fuera de su contenedor
    const openDropdown = document.querySelector('.searchable-select-dropdown[style*="display: block"]');
    if (openDropdown) {
        const container = openDropdown.closest('.searchable-select-container');
        if (container && !container.contains(e.target)) {
            openDropdown.style.display = 'none';
            // También quita el foco de la tarjeta contenedora
            const focusedCard = container.closest('.form-step-card.is-focused');
            if (focusedCard) {
                focusedCard.classList.remove('is-focused');
            }
        }
    }
});

document.addEventListener('DOMContentLoaded', function() {
    // --- REFERENCIAS A ELEMENTOS DEL DOM (Modo Creación) ---
    const formSuscripcion = document.getElementById('formSuscripcion');
    
    // Paso 1: Cliente
    const clienteContainer = document.getElementById('cliente_search_container');

    // Paso 2: Añadir Perfil (campos temporales para un solo perfil)
    const platformHiddenInput = document.getElementById('profile_add_platform_hidden');
    const accountHiddenInput = document.getElementById('profile_add_account_hidden');
    const inputAddProfileName = document.getElementById('profile_add_name');
    const inputAddProfilePin = document.getElementById('profile_add_pin');
    const inputAddFechaInicio = document.getElementById('profile_add_fecha_inicio');
    const inputAddDuracionDias = document.getElementById('profile_add_duracion_dias');
    const inputAddFechaFin = document.getElementById('profile_add_fecha_fin');
    const inputAddPrecioVenta = document.getElementById('profile_add_precio_venta');
    const selectAddEstadoSuscripcion = document.getElementById('profile_add_estado_suscripcion');

    const btnAddProfileToList = document.getElementById('btn-add-profile-to-list');
    const addedProfilesListTbody = document.getElementById('added-profiles-list-tbody');
    const perfilesJsonInput = document.getElementById('perfiles_json_input');
    const currentCMAvailableProfilesSpan = document.getElementById('current_cm_available_profiles');
    const btnNuevaCuentaMaestraDynamic = document.getElementById('btnNuevaCuentaMaestraDynamic');

    // Referencias a todos los campos del "Añadir Nuevo Perfil" que tienen 'required'
    const addProfileFields = [
        document.getElementById('platform_search_input'),
        document.getElementById('account_search_input'),
        inputAddProfileName,
        inputAddFechaInicio,
        inputAddDuracionDias,
        inputAddPrecioVenta,
        selectAddEstadoSuscripcion
    ];

    // Paso 3: Opciones Finales
    const submitButton = document.getElementById('submit-button');


    // --- INICIALIZACIÓN DE SELECTORES CON BÚSQUEDA ---
    if (!modoEdicion) {
        createSearchableSelect({
            containerId: 'cliente_search_container',
            data: todosLosClientes,
            valueField: 'id_cliente',
            primaryTextField: 'nombre_completo',
            secondaryTextField: 'telefono',
            searchFields: ['nombre_completo', 'telefono'],
            noResultsText: 'Cliente no encontrado. La búsqueda es flexible con teléfonos. ¿Desea agregarlo?'
        });

        createSearchableSelect({
            containerId: 'platform_search_container',
            data: todasLasPlataformas,
            valueField: 'id_plataforma',
            primaryTextField: 'nombre_plataforma',
            searchFields: ['nombre_plataforma'],
            onSelect: (value) => {
                poblarAddAccountSelect(value);
                toggleAddProfileFormRequirements(true);
            }
        });

        createSearchableSelect({
            containerId: 'account_search_container',
            data: [], // Se poblará dinámicamente
            valueField: 'id_cuenta_maestra',
            primaryTextField: 'email_cuenta',
            secondaryTextField: 'disponibles_texto',
            searchFields: ['email_cuenta'],
            onSelect: (value, item) => {
                // Validar si la cuenta tiene perfiles disponibles
                if (item && item.disponibles_reales <= 0) {
                    alert(`La cuenta maestra ${item.email_cuenta} no tiene más perfiles disponibles.`);
                    // Limpiar la selección si no hay perfiles
                    document.getElementById('account_search_container').clear();
                    return;
                }

                if (item) {
                    currentCMAvailableProfilesSpan.textContent = `Perfiles disponibles: ${item.disponibles_reales}`;
                } else {
                    currentCMAvailableProfilesSpan.textContent = 'Perfiles disponibles: 0';
                }
            }
        });
    }



    // --- FUNCIONES Y LÓGICA PRINCIPAL (Modo Creación) ---

    // Función para calcular Fecha Fin para UN perfil (en Paso 2)
    function calcularFechaFinPerfilIndividual() {
        if (!inputAddFechaInicio.value || !inputAddDuracionDias.value) {
            inputAddFechaFin.value = '';
            return;
        }
        const fechaInicio = new Date(inputAddFechaInicio.value + 'T00:00:00');
        const duracion = parseInt(inputAddDuracionDias.value, 10);

        if (!isNaN(duracion) && duracion >= 0) {
            const fechaFin = new Date(fechaInicio);
            fechaFin.setDate(fechaInicio.getDate() + duracion);
            inputAddFechaFin.value = fechaFin.toISOString().split('T')[0];
        } else {
            inputAddFechaFin.value = '';
        }
    }
    
    if (!modoEdicion) { // Solo si estamos en modo creación
        // Eventos para calcular fecha fin en el Paso 2
        inputAddFechaInicio.addEventListener('change', calcularFechaFinPerfilIndividual);
        inputAddDuracionDias.addEventListener('input', calcularFechaFinPerfilIndividual);
        calcularFechaFinPerfilIndividual(); // Calcular al cargar
    }


    /**
     * Puebla el select de Cuentas Maestras (para añadir perfiles) basado en la plataforma seleccionada.
     * @param {string} plataformaId - El ID de la plataforma.
     * @param {number|null} preselectedAccountId - ID de la cuenta a pre-seleccionar (ej. al añadir nueva CM).
     */
    function poblarAddAccountSelect(plataformaId, preselectedAccountId = null) {
        const accountContainer = document.getElementById('account_search_container');
        const accountSearchInput = document.getElementById('account_search_input');
        accountSearchInput.value = '';
        accountSearchInput.disabled = true;
        accountContainer.clear();
        btnNuevaCuentaMaestraDynamic.disabled = true;
        currentCMAvailableProfilesSpan.textContent = 'Perfiles disponibles: 0';

        if (!plataformaId) {
            accountSearchInput.placeholder = 'Seleccione una plataforma primero...';
            return;
        }

        const cuentasFiltradas = todasLasCuentasMaestras.filter(cuenta => 
            parseInt(cuenta.id_plataforma, 10) === parseInt(plataformaId, 10)
        ).map(cuenta => {

            const perfilesDisp = parseInt(cuenta.perfiles_disponibles, 10);
            
            // Contar cuántos perfiles de ESTA cuenta maestra ya se han añadido a la tabla
            const currentAddedProfilesForThisCM = addedProfilesData.filter(
                p => parseInt(p.id_cuenta_maestra, 10) === parseInt(cuenta.id_cuenta_maestra, 10)
            ).length;
            
            const actualAvailable = perfilesDisp - currentAddedProfilesForThisCM;

            return {
                ...cuenta,
                disponibles_reales: actualAvailable,
                disponibles_texto: `Disp: ${actualAvailable}`
            };
        }).filter(cuenta => cuenta.disponibles_reales > 0 || (preselectedAccountId && parseInt(cuenta.id_cuenta_maestra, 10) === preselectedAccountId));

        accountContainer.updateData(cuentasFiltradas);

        if (cuentasFiltradas.length > 0) {
            accountSearchInput.disabled = false;
            accountSearchInput.placeholder = 'Buscar cuenta maestra...';
        } else {
            accountSearchInput.placeholder = 'No hay cuentas disponibles.';
        }

        btnNuevaCuentaMaestraDynamic.disabled = !plataformaId;

        if (preselectedAccountId) {
            accountContainer.setValue(preselectedAccountId);
        }
    }

    // Función para activar o desactivar los requisitos de los campos de "Añadir Nuevo Perfil"
    function toggleAddProfileFormRequirements(enable) {
        addProfileFields.forEach(field => {
            if (enable) {
                field.setAttribute('required', 'required');
                // Re-enable if it was disabled (e.g., selectAddAccount)
                if (field.id === 'account_search_input' && !platformHiddenInput.value) {
                    field.disabled = true; // Mantener deshabilitado si no hay plataforma
                } else {
                    field.disabled = false;
                }
            } else {
                field.removeAttribute('required');
                // Optionally disable fields to prevent user input after adding to list
                // field.disabled = true; // Consider if you want to completely disable or just remove required
            }
        });
        // Special handling for the dynamic new account button
        btnNuevaCuentaMaestraDynamic.disabled = !enable;
    }


    if (!modoEdicion) { // Lógica solo para modo creación
        btnAddProfileToList.addEventListener('click', function() {
            const platformId = platformHiddenInput.value;
            const accountId = accountHiddenInput.value;
            const profileName = inputAddProfileName.value.trim();
            const profilePin = inputAddProfilePin.value.trim();
            const fechaInicio = inputAddFechaInicio.value;
            const duracionDias = inputAddDuracionDias.value;
            const fechaFin = inputAddFechaFin.value;
            const precioVenta = inputAddPrecioVenta.value;
            const estadoSuscripcion = selectAddEstadoSuscripcion.value;

            if (!platformId || !accountId || !profileName || !fechaInicio || !duracionDias || !fechaFin || isNaN(parseFloat(precioVenta))) {
                // Instead of alert, you might want to show a more user-friendly message in the UI
                alert('Por favor, complete todos los campos obligatorios del perfil (Plataforma, Cuenta Maestra, Nombre, Fechas, Duración, Precio).');
                return;
            }

            const selectedPlatform = todasLasPlataformas.find(p => parseInt(p.id_plataforma, 10) === parseInt(platformId, 10));
            const selectedAccount = todasLasCuentasMaestras.find(cm => parseInt(cm.id_cuenta_maestra, 10) === parseInt(accountId, 10));

            if (!selectedPlatform || !selectedAccount) {
                alert('Error al encontrar datos de la plataforma o cuenta maestra seleccionada.');
                return;
            }

            // Validar límite de perfiles de la plataforma
            const maxPerfilesCuenta = parseInt(selectedAccount.perfiles_total, 10);
            const currentAddedProfilesForThisCM = addedProfilesData.filter(
                p => parseInt(p.id_cuenta_maestra, 10) === parseInt(accountId, 10)
            ).length;

            if (currentAddedProfilesForThisCM >= maxPerfilesCuenta) {
                alert(`La plataforma ${selectedPlatform.nombre_plataforma} permite un máximo de ${maxPerfilesCuenta} perfiles por cuenta maestra. Ya has añadido el máximo para esta cuenta.`);
                return;
            }
            
            // Validar perfiles disponibles en la cuenta maestra real
            const actualAvailableSlots = parseInt(selectedAccount.perfiles_disponibles, 10) - currentAddedProfilesForThisCM;
            if (actualAvailableSlots <= 0) {
                 alert(`La cuenta maestra ${selectedAccount.email_cuenta} no tiene más perfiles disponibles.`);
                 return;
            }

            // Añadir el perfil al array `addedProfilesData`
            const newProfile = {
                id_temp: Date.now() + Math.random(), // ID temporal para eliminar de la lista
                id_plataforma: platformId,
                nombre_plataforma: selectedPlatform.nombre_plataforma,
                id_cuenta_maestra: accountId,
                email_cuenta: selectedAccount.email_cuenta,
                nombre_perfil_cliente: profileName,
                pin_perfil_cliente: profilePin || null, // Usar null si está vacío
                fecha_inicio_servicio: fechaInicio,
                duracion_dias: duracionDias,
                fecha_fin_servicio: fechaFin,
                precio_venta: precioVenta,
                estado_suscripcion: estadoSuscripcion
            };
            addedProfilesData.push(newProfile);
            updateProfilesListTable();
            
            // Limpiar campos para el siguiente perfil
            inputAddProfileName.value = '';
            inputAddProfilePin.value = '';
            inputAddFechaInicio.value = (new Date()).toISOString().split('T')[0]; // Reset a hoy
            inputAddDuracionDias.value = '30';
            calcularFechaFinPerfilIndividual(); // Recalcular fecha fin
            inputAddPrecioVenta.value = '';
            selectAddEstadoSuscripcion.value = '1';
            
            // Limpiar solo los campos del perfil, mantener plataforma y cuenta maestra seleccionadas
            // document.getElementById('platform_search_container').clear(); // NO limpiar plataforma
            // document.getElementById('account_search_container').clear(); // NO limpiar cuenta maestra
            // poblarAddAccountSelect(''); // NO resetear cuentas maestras
            
            // Actualizar la lista de cuentas maestras para reflejar los perfiles disponibles actualizados
            poblarAddAccountSelect(platformHiddenInput.value);
            
            document.getElementById('profile_add_name').focus(); // Enfocar en el nombre del perfil
            
            // Remove required from add profile fields as there are now items in the list
            toggleAddProfileFormRequirements(false);
        });
    }


    /**
     * Actualiza la tabla de perfiles añadidos.
     */
    function updateProfilesListTable() {
        if (addedProfilesData.length === 0) {
            addedProfilesListTbody.innerHTML = '<tr class="no-profiles-message"><td colspan="7" class="text-center text-muted py-4">No hay perfiles añadidos aún.</td></tr>';
            submitButton.disabled = true; // Deshabilitar botón de guardar si no hay perfiles
            toggleAddProfileFormRequirements(true); // Re-enable requirements if list is empty
            return;
        }

        addedProfilesListTbody.innerHTML = '';
        addedProfilesData.forEach((profile, index) => {
            const row = document.createElement('tr');
            row.innerHTML = `
                <td>${index + 1}</td>
                <td>${profile.nombre_plataforma}</td>
                <td><span title="${profile.email_cuenta}">${profile.email_cuenta.substring(0,20)}...</span></td>
                <td>${profile.nombre_perfil_cliente}</td>
                <td>${profile.fecha_fin_servicio}</td>
                <td>${profile.precio_venta}</td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm" data-id-temp="${profile.id_temp}">
                        <i class="fas fa-trash-alt"></i>
                    </button>
                </td>
            `;
            addedProfilesListTbody.appendChild(row);

            // Adjuntar evento de eliminar a los nuevos botones
            row.querySelector('.btn-danger').addEventListener('click', function() {
                removeProfileFromList(this.getAttribute('data-id-temp'));
            });
        });

        // Actualizar el input oculto con el JSON de perfiles
        perfilesJsonInput.value = JSON.stringify(addedProfilesData);
        submitButton.disabled = false; // Habilitar botón de guardar si hay perfiles
        toggleAddProfileFormRequirements(false); // Remove requirements if list is NOT empty
    }

    /**
     * Elimina un perfil de la lista de la tabla y del array `addedProfilesData`.
     * @param {string} idTemp - ID temporal del perfil a eliminar.
     */
    function removeProfileFromList(idTemp) {
        addedProfilesData = addedProfilesData.filter(profile => String(profile.id_temp) !== String(idTemp));
        updateProfilesListTable();

        // Re-evaluar perfiles disponibles para la CM afectada si el perfil eliminado era de esa CM
        // Esto es importante para que el dropdown muestre la cantidad correcta.
        poblarAddAccountSelect(platformHiddenInput.value);
    }


 // --- LÓGICA ESPECÍFICA PARA EL MODO EDICIÓN (UN SOLO PERFIL) ---
if (modoEdicion) {
    const inputFechaInicioEdit      = document.getElementById('fecha_inicio_servicio');
    const inputDuracionDiasEdit     = document.getElementById('duracion_dias');
    const inputFechaFinEdit         = document.getElementById('fecha_fin_servicio');
    const clienteContainerEdit      = document.getElementById('cliente_search_container');
    const platformContainerEdit     = document.getElementById('platform_search_container_edit');
    const accountContainerEdit      = document.getElementById('account_search_container_edit');

    // Inicializar selector de cliente (deshabilitado) con búsqueda mejorada
    createSearchableSelect({ 
        containerId: 'cliente_search_container', 
        data: todosLosClientes, 
        valueField: 'id_cliente', 
        primaryTextField: 'nombre_completo', 
        secondaryTextField: 'telefono', 
        searchFields: ['nombre_completo', 'telefono'],
        noResultsText: 'Cliente no encontrado. La búsqueda es flexible con teléfonos.'
    });
    clienteContainerEdit.setValue('<?php echo (int)($suscripcion_a_editar['id_cliente'] ?? 0); ?>');
    document.getElementById('cliente_search_input').value = '<?php echo htmlspecialchars(addslashes($suscripcion_a_editar['cliente_nombre'] ?? '')); ?>';

    // Hacemos accesible la función desde otros handlers (ej. tras crear una CM)
    window.poblarAddAccountSelectForEdit = function(plataformaId, preselectedAccountId = null) {
        const accountSearchInput = document.getElementById('account_search_input_edit');
        accountContainerEdit.clear();
        accountSearchInput.disabled = true;

        if (!plataformaId) {
            accountSearchInput.placeholder = 'Seleccione una plataforma…';
            return;
        }

        // Filtrar cuentas de la plataforma seleccionada
        // Ahora incluye TODAS las cuentas activas con perfiles disponibles + la cuenta original
        let cuentasFiltradas = todasLasCuentasMaestras
            .filter(c => parseInt(c.id_plataforma, 10) === parseInt(plataformaId, 10))
            .filter(c => parseInt(c.estado_cuenta, 10) === 1)
            .map(cuenta => {
                let disp = parseInt(cuenta.perfiles_disponibles, 10);
                let disponibles_reales = disp;
                let disponibles_texto = `Disp: ${disp}`;
                
                // Si es la cuenta original del perfil que se está editando, permitirla aunque esté llena
                if (parseInt(cuenta.id_cuenta_maestra, 10) === idCuentaMaestraOriginal) {
                    disponibles_reales = Math.max(disp, 1); // Mínimo 1 perfil disponible para la cuenta original
                    disponibles_texto = `Disp: ${disponibles_reales} (Cuenta Original)`;
                }
                
                return { 
                    ...cuenta, 
                    disponibles_reales: disponibles_reales, 
                    disponibles_texto: disponibles_texto 
                };
            });

        // Asegurar que la cuenta original siempre esté incluida si existe
        // Esto es crucial para que el usuario pueda mantener la cuenta maestra original del perfil
        // NOTA: Ahora cuentasFiltradas ya incluye TODAS las cuentas activas con perfiles disponibles
        // + la cuenta original, gracias a la consulta SQL mejorada del backend
        if (idCuentaMaestraOriginal && !cuentasFiltradas.some(c => parseInt(c.id_cuenta_maestra, 10) === idCuentaMaestraOriginal)) {
            // Buscar la cuenta original en todasLasCuentasMaestras
            const cuentaOriginal = todasLasCuentasMaestras.find(c => parseInt(c.id_cuenta_maestra, 10) === idCuentaMaestraOriginal);
            if (cuentaOriginal && parseInt(cuentaOriginal.id_plataforma, 10) === parseInt(plataformaId, 10)) {
                cuentasFiltradas.push({
                    ...cuentaOriginal,
                    disponibles_reales: 1,
                    disponibles_texto: 'Disp: 1 (Cuenta Original)'
                });
            }
        }

        accountContainerEdit.updateData(cuentasFiltradas);
        accountSearchInput.disabled = false;
        accountSearchInput.placeholder = 'Buscar cuenta...';

        if (preselectedAccountId) {
            accountContainerEdit.setValue(preselectedAccountId);
        }
    };

    // Inicializar selector de plataforma (modo edición)
    createSearchableSelect({
        containerId: 'platform_search_container_edit',
        data: todasLasPlataformas,
        valueField: 'id_plataforma',
        primaryTextField: 'nombre_plataforma',
        searchFields: ['nombre_plataforma'],
        onSelect: (value) => {
            // Al cambiar plataforma, recargar cuentas maestras
            // Si la cuenta original es de la nueva plataforma, aparecerá en la lista
            window.poblarAddAccountSelectForEdit(value, null);
        }
    });

    // Inicializar selector de cuenta (modo edición)
    createSearchableSelect({
        containerId: 'account_search_container_edit',
        data: [], // Se poblará dinámicamente
        valueField: 'id_cuenta_maestra',
        primaryTextField: 'email_cuenta',
        secondaryTextField: 'disponibles_texto',
        searchFields: ['email_cuenta']
    });

    // Carga inicial para modo edición
    platformContainerEdit.setValue(idPlataformaOriginal);
    window.poblarAddAccountSelectForEdit(idPlataformaOriginal, idCuentaMaestraOriginal);

  // Cálculo de fecha fin en edición
  function calcularFechaFinEdit() {
    if (!inputFechaInicioEdit.value || !inputDuracionDiasEdit.value) {
      inputFechaFinEdit.value = '';
      return;
    }
    const inicio = new Date(inputFechaInicioEdit.value + 'T00:00:00');
    const dur    = parseInt(inputDuracionDiasEdit.value, 10);
    if (!isNaN(dur) && dur >= 0) {
      const fin = new Date(inicio);
      fin.setDate(inicio.getDate() + dur);
      inputFechaFinEdit.value = fin.toISOString().split('T')[0];
    } else {
      inputFechaFinEdit.value = '';
    }
  }
  calcularFechaFinEdit();
  inputFechaInicioEdit.addEventListener('change', calcularFechaFinEdit);
  inputDuracionDiasEdit.addEventListener('input',  calcularFechaFinEdit);
}
 // --- LÓGICA PARA MODALES (AJAX) ---

    // Modal de Nuevo Cliente
    const modalNuevoCliente = new bootstrap.Modal(document.getElementById('modalNuevoCliente'));
    const formNuevoCliente = document.getElementById('formNuevoCliente');
    const btnGuardarCliente = document.getElementById('btnGuardarCliente');
    const errorContainerCliente = document.getElementById('error-container-cliente');

    if(btnGuardarCliente) {
        btnGuardarCliente.addEventListener('click', function() {
            const formData = new FormData(formNuevoCliente);

            // Validación básica
            if (!formData.get('nombre_completo').trim() || !formData.get('telefono').trim()) {
                errorContainerCliente.textContent = 'Nombre Completo y Teléfono son requeridos.';
                errorContainerCliente.classList.remove('d-none');
                return;
            }
            errorContainerCliente.classList.add('d-none'); // Oculta errores previos

            // Envío AJAX al controlador de clientes
            fetch('/digitalpremium/actions/clientes_controlador.php', { 
                method: 'POST', 
                body: formData 
            })
            .then(response => response.json())
            .then(data => {
                if (data.success && data.cliente) {
                    // Éxito: Cliente guardado
                    todosLosClientes.push(data.cliente);
                    // Actualizar y seleccionar en el nuevo selector
                    clienteContainer.updateData(todosLosClientes);
                    clienteContainer.setValue(data.cliente.id_cliente);
                    formNuevoCliente.reset(); // Limpia el formulario del modal
                    modalNuevoCliente.hide(); // Cierra el modal

                    // Solución para el 'backdrop' persistente (velo gris) y scroll
                    setTimeout(() => {
                        const backdrops = document.querySelectorAll('.modal-backdrop');
                        backdrops.forEach(backdrop => backdrop.remove());
                        document.body.classList.remove('modal-open');
                        document.body.style.overflow = ''; // Restaurar scroll
                        document.body.style.paddingRight = '';
                    }, 500); 

                } else {
                    // Error desde el servidor
                    errorContainerCliente.textContent = data.message || 'Ocurrió un error inesperado al guardar el cliente.';
                    errorContainerCliente.classList.remove('d-none');
                }
            })
            .catch(error => {
                console.error('Error en fetch al guardar cliente:', error);
                errorContainerCliente.textContent = 'Error de conexión. Intente de nuevo.';
                errorContainerCliente.classList.remove('d-none');
            });
        });
    }

    // Modal de Nueva Cuenta Maestra
    const modalNuevaCuentaMaestra = new bootstrap.Modal(document.getElementById('modalNuevaCuentaMaestra'));
    const formNuevaCuentaMaestra = document.getElementById('formNuevaCuentaMaestra');
    const btnGuardarCuentaMaestra = document.getElementById('btnGuardarCuentaMaestra');
    const errorContainerCuenta = document.getElementById('error-container-cuenta');
    const modalIdPlataforma = document.getElementById('modal_id_plataforma');
    const modalNombrePlataforma = document.getElementById('modal_nombre_plataforma');
    const modalFechaCompra = document.getElementById('modal_fecha_compra_proveedor');
    const modalDias = document.getElementById('modal_dias_membresia');
    const modalFechaVencimiento = document.getElementById('modal_fecha_vencimiento');

    function calcularVencimientoModal() { if (modalFechaCompra.value && !isNaN(parseInt(modalDias.value, 10))) { const d = new Date(modalFechaCompra.value + 'T00:00:00'); d.setDate(d.getDate() + parseInt(modalDias.value, 10)); modalFechaVencimiento.value = d.toISOString().split('T')[0]; } }
    function calcularDiasModal() { if (modalFechaCompra.value && modalFechaVencimiento.value) { const s = new Date(modalFechaCompra.value + 'T00:00:00'), e = new Date(modalFechaVencimiento.value + 'T00:00:00'); if (e >= s) { modalDias.value = Math.ceil(Math.abs(e - s) / (1000 * 60 * 60 * 24)); } } }
    modalFechaCompra.addEventListener('change', calcularVencimientoModal);
    modalDias.addEventListener('input', calcularVencimientoModal);
    modalFechaVencimiento.addEventListener('change', calcularDiasModal);

    if(btnGuardarCuentaMaestra){
        document.getElementById('modalNuevaCuentaMaestra').addEventListener('show.bs.modal', function (event) {
  const idPlataforma = modoEdicion
    ? (document.getElementById('id_plataforma_edit_hidden')?.value || '')
    : (document.getElementById('profile_add_platform_hidden')?.value || '');

  if (!idPlataforma) {
    alert('Por favor, seleccione una plataforma para la cuenta maestra.');
    event.preventDefault();
    return;
  }
  
  const plataformaSeleccionada = todasLasPlataformas.find(p => p.id_plataforma == idPlataforma);
  const nombrePlataforma = plataformaSeleccionada ? plataformaSeleccionada.nombre_plataforma : 'Desconocida';
  const perfilesSugeridos = plataformaSeleccionada ? (plataformaSeleccionada.max_perfiles_cuenta || 5) : 5;

  modalIdPlataforma.value     = idPlataforma;
  modalNombrePlataforma.value = nombrePlataforma;
  document.getElementById('modal_perfiles_total').value = perfilesSugeridos;

  const hoy = new Date();
  modalFechaCompra.value = hoy.toISOString().split('T')[0];
  calcularVencimientoModal();
});

        btnGuardarCuentaMaestra.addEventListener('click', function() {
            const formData = new FormData(formNuevaCuentaMaestra);
            
            // Validación básica para campos de la cuenta maestra, ahora todos obligatorios
            const emailCuenta = formData.get('email_cuenta').trim();
            const passwordCuenta = formData.get('password_cuenta').trim();
            const fechaVencimiento = formData.get('fecha_vencimiento_proveedor').trim();
            const fechaCompra = formData.get('fecha_compra_proveedor').trim();
            const costoCompra = formData.get('costo_compra'); // Ya es number, no trim
            const nombreProveedor = formData.get('nombre_proveedor').trim();

            if (!emailCuenta || !passwordCuenta || !fechaVencimiento || !fechaCompra || isNaN(parseFloat(costoCompra)) || !nombreProveedor) {
                errorContainerCuenta.textContent = 'Email, Contraseña, Fecha de Vencimiento, Fecha de Compra, Costo de Compra y Nombre del Proveedor son requeridos.';
                errorContainerCuenta.classList.remove('d-none');
                return;
            }
            errorContainerCuenta.classList.add('d-none'); // Oculta errores previos

            // Envío AJAX al controlador de cuentas maestras
            fetch('/digitalpremium/actions/ajax_agregar_cuenta_maestra.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success && data.cuenta) {
  const cuentaRecibida = data.cuenta;
  const platId = parseInt(modalIdPlataforma.value, 10);

  // Suma la nueva CM al array en memoria
  todasLasCuentasMaestras.push({
    id_cuenta_maestra: parseInt(cuentaRecibida.id_cuenta_maestra, 10),
    id_plataforma: platId,
    email_cuenta: cuentaRecibida.email_cuenta,
    password_cuenta: cuentaRecibida.password_cuenta || '',
    perfiles_total: parseInt(cuentaRecibida.perfiles_total || 0, 10),
    perfiles_disponibles: parseInt(cuentaRecibida.perfiles_disponibles || 0, 10)
  });

  if (modoEdicion) {
    // Repoblar y preseleccionar la nueva CM en edición
    window.poblarAddAccountSelectForEdit(platId, parseInt(cuentaRecibida.id_cuenta_maestra, 10));
  } else {
    // Repoblar y preseleccionar en creación
    poblarAddAccountSelect(document.getElementById('profile_add_platform_hidden').value, cuentaRecibida.id_cuenta_maestra);
  }

  formNuevaCuentaMaestra.reset();
  modalNuevaCuentaMaestra.hide();

  setTimeout(() => {
    document.querySelectorAll('.modal-backdrop').forEach(b => b.remove());
    document.body.classList.remove('modal-open');
    document.body.style.overflow = '';
    document.body.style.paddingRight = '';
  }, 500);
} else {
  errorContainerCuenta.textContent = data.message || 'Ocurrió un error inesperado al guardar la cuenta maestra.';
  errorContainerCuenta.classList.remove('d-none');
}

            })
            .catch(error => {
                console.error('Error en fetch al guardar cuenta maestra:', error);
                errorContainerCuenta.textContent = 'Error de conexión o respuesta inválida del servidor.';
                errorContainerCuenta.classList.remove('d-none');
            });
        });
    }

    // Initial call to set requirements based on initial state (empty list)
    if (!modoEdicion) {
        updateProfilesListTable(); // This will call toggleAddProfileFormRequirements(true) initially
    }
});
</script>
