<?php
// /pages/producto_form.php (VERSIÓN 2 - MEJORADA)
if (session_status() == PHP_SESSION_NONE) { session_start(); }

if (!isset($_SESSION['id_usuario']) || $_SESSION['rol'] !== 'superadmin') {
    header("Location: /digitalpremium/pages/dashboard.php?error=acceso_denegado");
    exit();
}

require_once '../config/db.php';
include_once '../includes/header.php';

$modo_edicion = false;
$producto = ['tipo_producto' => 'simple']; // Por defecto es 'simple'
$detalles_paquete = [];

if (isset($_GET['editar_id'])) {
    $modo_edicion = true;
    $id_producto = filter_var($_GET['editar_id'], FILTER_VALIDATE_INT);
    $stmt = $pdo->prepare("SELECT * FROM productos_mayorista WHERE id_producto = ?");
    $stmt->execute([$id_producto]);
    $producto = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$producto) {
        header("Location: productos_mayorista.php?mensaje=" . urlencode("Producto no encontrado.") . "&tipo=danger");
        exit();
    }
    // Determinar el tipo de producto para la UI
    $producto['tipo_producto'] = !empty($producto['id_plataforma']) ? 'simple' : 'combo';

    if ($producto['tipo_producto'] === 'combo' && !empty($producto['detalles_json'])) {
        $decoded_json = json_decode($producto['detalles_json'], true);
        if (isset($decoded_json['cuentas'])) {
            $detalles_paquete = $decoded_json['cuentas'];
        }
    }
}

$plataformas_disponibles = $pdo->query("SELECT id_plataforma, nombre_plataforma FROM plataformas WHERE estado = 1 ORDER BY nombre_plataforma")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid px-4">
    <h1 class="mt-4"><?php echo $modo_edicion ? 'Editar' : 'Crear'; ?> Producto por Mayor</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
        <li class="breadcrumb-item"><a href="productos_mayorista.php">Productos por Mayor</a></li>
        <li class="breadcrumb-item active"><?php echo $modo_edicion ? 'Editar' : 'Crear'; ?></li>
    </ol>

    <div class="card shadow-sm">
        <div class="card-header"><i class="fas fa-box me-1"></i> Datos del Producto</div>
        <div class="card-body">
            <form action="/digitalpremium/actions/productos_mayorista_controlador.php" method="POST">
                <input type="hidden" name="accion" value="<?php echo $modo_edicion ? 'editar' : 'crear'; ?>">
                <?php if ($modo_edicion) echo "<input type='hidden' name='id_producto' value='{$producto['id_producto']}'>"; ?>

                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="nombre_producto" class="form-label">Nombre del Producto <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="nombre_producto" name="nombre_producto" value="<?php echo htmlspecialchars($producto['nombre_producto'] ?? ''); ?>" required>
                    </div>
                    <div class="col-md-6">
                        <label for="precio" class="form-label">Precio de Venta (S/) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="precio" name="precio" step="0.01" value="<?php echo htmlspecialchars($producto['precio'] ?? ''); ?>" required>
                    </div>

                    <div class="col-12">
                        <label class="form-label">Tipo de Producto</label>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="tipo_producto" id="tipo_simple" value="simple" <?php echo ($producto['tipo_producto'] === 'simple') ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="tipo_simple">Producto Simple (Una cuenta completa de una plataforma)</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="tipo_producto" id="tipo_combo" value="combo" <?php echo ($producto['tipo_producto'] === 'combo') ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="tipo_combo">Producto Combo / Personalizado</label>
                        </div>
                    </div>

                    <div id="contenedor-simple" class="col-12">
                        <label for="id_plataforma_simple" class="form-label">Seleccionar Plataforma <span class="text-danger">*</span></label>
                        <select class="form-select" id="id_plataforma_simple" name="id_plataforma_simple">
                            <option value="">-- Seleccione una plataforma --</option>
                            <?php foreach ($plataformas_disponibles as $plataforma): ?>
                                <option value="<?php echo $plataforma['id_plataforma']; ?>" <?php echo (isset($producto['id_plataforma']) && $producto['id_plataforma'] == $plataforma['id_plataforma']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($plataforma['nombre_plataforma']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div id="contenedor-combo" class="col-12">
                        <fieldset class="border p-3 rounded">
                            <legend class="float-none w-auto px-2 h6">Contenido del Paquete Combo</legend>
                            <div id="contenedor-detalles-paquete">
                                <?php if (!empty($detalles_paquete)): ?>
                                    <?php foreach ($detalles_paquete as $detalle): ?>
                                        <div class="row g-3 align-items-center mb-2 detalle-fila">
                                            <div class="col-md-6">
                                                <select class="form-select" name="detalle_plataforma_id[]" required>
                                                    <option value="">Seleccione...</option>
                                                    <?php foreach ($plataformas_disponibles as $plataforma): ?>
                                                        <option value="<?php echo $plataforma['id_plataforma']; ?>" <?php echo ($detalle['plataforma_id'] == $plataforma['id_plataforma']) ? 'selected' : ''; ?>>
                                                            <?php echo htmlspecialchars($plataforma['nombre_plataforma']); ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <div class="col-md-4"><input type="number" class="form-control" name="detalle_cantidad[]" value="<?php echo htmlspecialchars($detalle['cantidad']); ?>" min="1" required></div>
                                            <div class="col-md-2 d-flex"><button type="button" class="btn btn-danger w-100 btn-remover-detalle">Quitar</button></div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                            <button type="button" id="btn-agregar-detalle" class="btn btn-success mt-2"><i class="fas fa-plus me-1"></i> Añadir Fila</button>
                        </fieldset>
                    </div>
                    
                    <div class="col-12">
                        <label for="descripcion" class="form-label">Descripción</label>
                        <textarea class="form-control" id="descripcion" name="descripcion" rows="3"><?php echo htmlspecialchars($producto['descripcion'] ?? ''); ?></textarea>
                    </div>
                    <div class="col-12">
                        <label for="info_pago_html" class="form-label">Información de Pago (HTML)</label>
                        <textarea class="form-control" id="info_pago_html" name="info_pago_html" rows="5"><?php echo htmlspecialchars($producto['info_pago_html'] ?? ''); ?></textarea>
                    </div>
                     <div class="col-md-6">
                        <label for="imagen_url" class="form-label">URL de Imagen</label>
                        <input type="url" class="form-control" id="imagen_url" name="imagen_url" value="<?php echo htmlspecialchars($producto['imagen_url'] ?? ''); ?>">
                    </div>
                    <div class="col-md-6">
                        <label for="estado" class="form-label">Estado</label>
                        <select class="form-select" id="estado" name="estado">
                            <option value="1" <?php echo (!isset($producto['estado']) || $producto['estado'] == 1) ? 'selected' : ''; ?>>Activo</option>
                            <option value="0" <?php echo (isset($producto['estado']) && $producto['estado'] == 0) ? 'selected' : ''; ?>>Inactivo</option>
                        </select>
                    </div>
                </div>

                <div class="mt-4 text-end">
                    <a href="productos_mayorista.php" class="btn btn-secondary">Cancelar</a>
                    <button type="submit" class="btn btn-primary"><?php echo $modo_edicion ? 'Actualizar' : 'Guardar'; ?> Producto</button>
                </div>
            </form>
        </div>
    </div>
</div>

<template id="plantilla-detalle-fila">
    <div class="row g-3 align-items-center mb-2 detalle-fila">
        <div class="col-md-6"><select class="form-select" name="detalle_plataforma_id[]" required><option value="">Seleccione...</option><?php foreach ($plataformas_disponibles as $p) echo "<option value='{$p['id_plataforma']}'>".htmlspecialchars($p['nombre_plataforma'])."</option>"; ?></select></div>
        <div class="col-md-4"><input type="number" class="form-control" name="detalle_cantidad[]" placeholder="Cantidad" min="1" required></div>
        <div class="col-md-2 d-flex"><button type="button" class="btn btn-danger w-100 btn-remover-detalle">Quitar</button></div>
    </div>
</template>

<?php include_once '../includes/footer.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const radios = document.querySelectorAll('input[name="tipo_producto"]');
    const contSimple = document.getElementById('contenedor-simple');
    const contCombo = document.getElementById('contenedor-combo');
    const selSimple = document.getElementById('id_plataforma_simple');
    const primerDetallePlataforma = document.querySelector('select[name="detalle_plataforma_id[]"]');
    const primerDetalleCantidad = document.querySelector('input[name="detalle_cantidad[]"]');

    function toggleTipoProducto() {
        if (document.getElementById('tipo_simple').checked) {
            contSimple.style.display = 'block';
            selSimple.required = true;
            contCombo.style.display = 'none';
            if(primerDetallePlataforma) primerDetallePlataforma.required = false;
            if(primerDetalleCantidad) primerDetalleCantidad.required = false;
        } else {
            contSimple.style.display = 'none';
            selSimple.required = false;
            contCombo.style.display = 'block';
            if(primerDetallePlataforma) primerDetallePlataforma.required = true;
            if(primerDetalleCantidad) primerDetalleCantidad.required = true;
        }
    }

    radios.forEach(radio => radio.addEventListener('change', toggleTipoProducto));
    toggleTipoProducto(); // Ejecutar al cargar la página para establecer el estado inicial

    // Lógica para añadir/quitar filas del combo
    const btnAgregar = document.getElementById('btn-agregar-detalle');
    const contenedorCombo = document.getElementById('contenedor-detalles-paquete');
    const plantilla = document.getElementById('plantilla-detalle-fila');

    btnAgregar.addEventListener('click', () => contenedorCombo.appendChild(plantilla.content.cloneNode(true)));
    contenedorCombo.addEventListener('click', e => {
        if (e.target && e.target.classList.contains('btn-remover-detalle')) {
            e.target.closest('.detalle-fila').remove();
        }
    });
});
</script>