<?php
// /pages/productos_mayorista.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }

// Seguridad: Solo el Super Admin puede acceder
if (!isset($_SESSION['id_usuario']) || $_SESSION['rol'] !== 'superadmin') {
    header("Location: /digitalpremium/pages/dashboard.php?error=acceso_denegado");
    exit();
}

require_once '../config/db.php';
include_once '../includes/header.php';

// Obtener todos los productos para listarlos
$stmt = $pdo->query("SELECT p.*, plat.nombre_plataforma 
                     FROM productos_mayorista p 
                     LEFT JOIN plataformas plat ON p.id_plataforma = plat.id_plataforma
                     ORDER BY p.id_producto DESC");
$productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid px-4">
    <h1 class="mt-4">Gestionar Productos por Mayor</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="/digitalpremium/pages/dashboard.php">Dashboard</a></li>
        <li class="breadcrumb-item active">Productos por Mayor</li>
    </ol>

    <div class="card shadow-sm mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span><i class="fas fa-box-open me-1"></i>Listado de Productos</span>
            <a href="producto_form.php" class="btn btn-primary btn-sm"><i class="fas fa-plus me-1"></i> Crear Nuevo Producto</a>
        </div>
        <div class="card-body">
            <?php if (isset($_GET['mensaje'])): ?>
                <div class="alert alert-<?php echo htmlspecialchars($_GET['tipo']); ?> alert-dismissible fade show" role="alert">
                    <?php echo htmlspecialchars(urldecode($_GET['mensaje'])); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Nombre del Producto</th>
                            <th>Precio</th>
                            <th>Plataforma Base</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($productos)): ?>
                            <tr>
                                <td colspan="6" class="text-center">No hay productos creados todavía.</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($productos as $producto): ?>
                                <tr>
                                    <td><?php echo $producto['id_producto']; ?></td>
                                    <td><?php echo htmlspecialchars($producto['nombre_producto']); ?></td>
                                    <td>S/ <?php echo number_format($producto['precio'], 2); ?></td>
                                    <td><?php echo htmlspecialchars($producto['nombre_plataforma'] ?? 'Varios/Combo'); ?></td>
                                    <td>
                                        <?php if ($producto['estado'] == 1): ?>
                                            <span class="badge bg-success">Activo</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Inactivo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="producto_form.php?editar_id=<?php echo $producto['id_producto']; ?>" class="btn btn-warning btn-sm" title="Editar">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="/digitalpremium/actions/productos_mayorista_controlador.php" method="POST" onsubmit="return confirm('¿Estás seguro de que quieres eliminar este producto?');" style="display:inline;">
                                            <input type="hidden" name="id_producto" value="<?php echo $producto['id_producto']; ?>">
                                            <input type="hidden" name="accion" value="eliminar">
                                            <button type="submit" class="btn btn-danger btn-sm" title="Eliminar">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include_once '../includes/footer.php'; ?>