<?php
// /pages/provisionar_pedido.php (VERSIÓN FINAL Y ROBUSTA)
if (session_status() == PHP_SESSION_NONE) { session_start(); }

if (!isset($_SESSION['id_usuario']) || $_SESSION['rol'] !== 'superadmin') {
    header("Location: /digitalpremium/pages/dashboard.php?error=acceso_denegado");
    exit();
}

require_once '../config/db.php';

$id_pedido = filter_input(INPUT_GET, 'id_pedido', FILTER_VALIDATE_INT);
if (!$id_pedido) { header("Location: pedidos_clientes.php?mensaje=ID inválido"); exit(); }

$sql = "SELECT ped.*, prod.id_producto, prod.nombre_producto, prod.detalles_json, u.nombre_completo AS nombre_cliente 
        FROM pedidos_mayorista ped
        JOIN productos_mayorista prod ON ped.id_producto = prod.id_producto
        JOIN usuarios u ON ped.id_usuario_cliente = u.id_usuario
        WHERE ped.id_pedido = ? AND ped.estado_pedido = 'en_revision'";
$stmt = $pdo->prepare($sql);
$stmt->execute([$id_pedido]);
$pedido = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$pedido) {
    header("Location: pedidos_clientes.php?mensaje=" . urlencode("Pedido no encontrado o ya fue gestionado.") . "&tipo=warning");
    exit();
}

// Decodificación y validación de los detalles del paquete
$detalles_paquete = [];
if (!empty($pedido['detalles_json'])) {
    $decoded_json = json_decode($pedido['detalles_json'], true);
    if (isset($decoded_json['cuentas']) && is_array($decoded_json['cuentas']) && !empty($decoded_json['cuentas'])) {
        $detalles_paquete = $decoded_json['cuentas'];
    }
}

$plataformas_disponibles = $pdo->query("SELECT id_plataforma, nombre_plataforma FROM plataformas")->fetchAll(PDO::FETCH_KEY_PAIR);

include_once '../includes/header.php';
?>

<div class="container-fluid px-4">
    <h1 class="mt-4">Provisionar Pedido #<?php echo $pedido['id_pedido']; ?></h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
        <li class="breadcrumb-item"><a href="pedidos_clientes.php">Pedidos de Clientes</a></li>
        <li class="breadcrumb-item active">Provisionar Pedido</li>
    </ol>

    <div class="row">
        <div class="col-lg-5">
            <div class="card shadow-sm mb-4">
                <div class="card-header"><i class="fas fa-receipt me-1"></i>Verificar Pago</div>
                <div class="card-body">
                    <h5>Detalles del Pedido</h5>
                    <p><strong>Cliente:</strong> <?php echo htmlspecialchars($pedido['nombre_cliente']); ?></p>
                    <p><strong>Producto:</strong> <?php echo htmlspecialchars($pedido['nombre_producto']); ?></p>
                    <p><strong>Fecha:</strong> <?php echo date("d/m/Y h:i A", strtotime($pedido['fecha_pedido'])); ?></p>
                    <hr>
                    <h5>Comprobante de Pago</h5>
                    <a href="<?php echo htmlspecialchars($pedido['comprobante_url']); ?>" target="_blank">
                        <img src="<?php echo htmlspecialchars($pedido['comprobante_url']); ?>" class="img-fluid rounded" alt="Comprobante de pago">
                    </a>
                </div>
            </div>
             <div class="card shadow-sm">
                <div class="card-header"><i class="fas fa-times-circle me-1"></i>Rechazar Pedido</div>
                <div class="card-body">
                    <form action="/digitalpremium/actions/pedidos_mayorista_controlador.php" method="POST" onsubmit="return confirm('¿Estás seguro de que quieres RECHAZAR este pedido?');">
                        <input type="hidden" name="id_pedido" value="<?php echo $pedido['id_pedido']; ?>">
                        <div class="mb-3"><label for="notas_admin" class="form-label">Motivo del Rechazo</label><textarea class="form-control" name="notas_admin" id="notas_admin" rows="2"></textarea></div>
                        <button type="submit" name="accion" value="rechazar_pedido" class="btn btn-danger w-100">Rechazar Pedido</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-7">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-primary text-white"><i class="fas fa-dolly-flatbed me-1"></i>Cargar Cuentas para el Cliente</div>
                <div class="card-body">

                    <?php if (empty($detalles_paquete)): ?>
                        <div class="alert alert-danger">
                            <h4 class="alert-heading">¡Error de Configuración!</h4>
                            <p>Este producto no tiene detalles de cuentas configurados (el campo `detalles_json` está vacío o es incorrecto).</p>
                            <hr>
                            <p class="mb-0">
                                <strong>Solución:</strong> Ve a "Gestionar Productos por Mayor", busca el producto "<strong><?php echo htmlspecialchars($pedido['nombre_producto']); ?></strong>" (ID: <?php echo $pedido['id_producto']; ?>), haz clic en "Editar" y vuelve a guardarlo usando la nueva interfaz de "Producto Simple" o "Combo". Esto generará las instrucciones correctas.
                            </p>
                        </div>
                    <?php else: ?>
                        <form action="/digitalpremium/actions/pedidos_mayorista_controlador.php" method="POST" onsubmit="return confirm('¿Estás seguro de que los datos son correctos?');">
                            <input type="hidden" name="id_pedido" value="<?php echo $pedido['id_pedido']; ?>">
                            
                            <?php $cuenta_index = 0; ?>
                            <?php foreach ($detalles_paquete as $item): ?>
                                <?php for ($i = 0; $i < $item['cantidad']; $i++): ?>
                                    <fieldset class="border rounded p-3 mb-3">
                                        <legend class="float-none w-auto px-2 h6">
                                            <span class="badge bg-info"><?php echo htmlspecialchars($plataformas_disponibles[$item['plataforma_id']] ?? 'Desconocida'); ?></span> - Cuenta #<?php echo $i + 1; ?>
                                        </legend>
                                        <input type="hidden" name="cuentas[<?php echo $cuenta_index; ?>][id_plataforma]" value="<?php echo $item['plataforma_id']; ?>">
                                        <div class="row g-3">
                                            <div class="col-md-6"><label class="form-label">Email de la Cuenta <span class="text-danger">*</span></label><input type="email" name="cuentas[<?php echo $cuenta_index; ?>][email_cuenta]" class="form-control" required></div>
                                            <div class="col-md-6"><label class="form-label">Contraseña <span class="text-danger">*</span></label><input type="text" name="cuentas[<?php echo $cuenta_index; ?>][password_cuenta]" class="form-control" required></div>
                                            <div class="col-md-6"><label class="form-label">Perfiles Totales <span class="text-danger">*</span></label><input type="number" name="cuentas[<?php echo $cuenta_index; ?>][perfiles_total]" class="form-control" value="5" required></div>
                                            <div class="col-md-6"><label class="form-label">Vencimiento <span class="text-danger">*</span></label><input type="date" name="cuentas[<?php echo $cuenta_index; ?>][fecha_vencimiento_proveedor]" class="form-control" required></div>
                                        </div>
                                    </fieldset>
                                    <?php $cuenta_index++; ?>
                                <?php endfor; ?>
                            <?php endforeach; ?>

                            <div class="d-grid">
                                <button type="submit" name="accion" value="aprobar_pedido" class="btn btn-primary btn-lg">Aprobar y Provisionar Cuentas</button>
                            </div>
                        </form>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include_once '../includes/footer.php'; ?>