<?php
// /pages/prueba_fechas.php
$resultado = '';
$fecha_ingresada = '';

if (isset($_POST['fecha_fin'])) {
    $fecha_ingresada = $_POST['fecha_fin'];
    if (!empty($fecha_ingresada)) {
        try {
            $zona_horaria_peru = new DateTimeZone('America/Lima');
            $fecha_fin = new DateTime($fecha_ingresada, $zona_horaria_peru);
            $hoy = new DateTime('now', $zona_horaria_peru);

            $hoy_str = $hoy->format('Y-m-d');
            $fin_str = $fecha_fin->format('Y-m-d');

            $resultado .= "<ul>";
            $resultado .= "<li><strong>Fecha de Hoy (Perú):</strong> " . $hoy->format('Y-m-d H:i:s') . "</li>";
            $resultado .= "<li><strong>Fecha de Vencimiento Ingresada:</strong> " . $fecha_fin->format('Y-m-d H:i:s') . "</li>";
            
            $es_vencido = $hoy->format('Y-m-d') > $fecha_fin->format('Y-m-d');
            
            if ($es_vencido) {
                $diff_obj = $hoy->diff($fecha_fin);
                $dias_restantes = (int)$diff_obj->format('%r%a');
                $resultado .= "<li><strong>Cálculo de Días:</strong> El sistema calcula " . $dias_restantes . " días.</li>";
                $resultado .= "<li style='color:red; font-weight:bold;'>RESULTADO: La fecha de hoy ({$hoy_str}) es MAYOR que la fecha de fin ({$fin_str}). El sistema BLOQUEARÍA al usuario.</li>";
            } else {
                $diff_obj = $hoy->diff($fecha_fin);
                $dias_restantes = (int)$diff_obj->format('%a');
                $resultado .= "<li><strong>Cálculo de Días:</strong> El sistema calcula " . $dias_restantes . " días restantes.</li>";
                $resultado .= "<li style='color:green; font-weight:bold;'>RESULTADO: La fecha de hoy ({$hoy_str}) NO es mayor que la fecha de fin ({$fin_str}). El sistema PERMITIRÍA el acceso.</li>";
            }
            $resultado .= "</ul>";

        } catch (Exception $e) {
            $resultado = "<p class='text-danger'>Error al procesar la fecha: " . $e->getMessage() . "</p>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Diagnóstico de Fechas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="card">
            <div class="card-header">
                <h3>Herramienta de Diagnóstico de Vencimiento</h3>
            </div>
            <div class="card-body">
                <p>Ingresa la fecha de vencimiento de un cliente que está siendo bloqueado incorrectamente.</p>
                <form method="POST" action="">
                    <div class="input-group mb-3">
                        <input type="date" name="fecha_fin" class="form-control" value="<?php echo htmlspecialchars($fecha_ingresada); ?>" required>
                        <button class="btn btn-primary" type="submit">Calcular Días Restantes</button>
                    </div>
                </form>
                <?php if ($resultado): ?>
                    <hr>
                    <h4>Análisis del Cálculo:</h4>
                    <div class="alert alert-info">
                        <?php echo $resultado; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>