<?php
// FILE: /digitalpremium/pages/test_perfiles.php - PARA DEPURAR ERRORES EN PERFILES_VENDIDOS

// Activar visualización de errores (CRÍTICO para la depuración)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>Iniciando Prueba de Depuración para Perfiles Vendidos</h1>";
echo "<p>Ruta actual: " . __FILE__ . "</p>";

// Iniciar sesión y verificar usuario
echo "<h2>1. Probando sesión...</h2>";
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['id_usuario'])) {
    echo "<p style='color: orange;'>Advertencia: Usuario no logueado. Redirigiendo a login (si esta prueba fuera parte del flujo normal).</p>";
    // Si no quieres la redirección real para la prueba, coméntala
    // header("Location: /digitalpremium/login.php"); 
    // exit();
} else {
    echo "<p style='color: green;'>✅ Sesión iniciada y usuario logueado. ID de usuario: " . htmlspecialchars($_SESSION['id_usuario']) . "</p>";
}

// Incluir db.php
echo "<h2>2. Probando inclusión de db.php...</h2>";
try {
    require_once '../config/db.php';
    if (isset($pdo) && $pdo instanceof PDO) {
        echo "<p style='color: green;'>✅ db.php cargado exitosamente. Conexión PDO establecida.</p>";
    } else {
        echo "<p style='color: red;'>❌ ERROR: \$pdo no es una instancia de PDO después de cargar db.php.</p>";
    }
} catch (Throwable $e) {
    echo "<p style='color: red;'>❌ ERROR FATAL al cargar db.php: " . htmlspecialchars($e->getMessage()) . "</p>";
    exit(); // Detener la ejecución si db.php falla
}

// Incluir message_helper.php
echo "<h2>3. Probando inclusión de message_helper.php...</h2>";
try {
    require_once '../includes/message_helper.php';
    if (function_exists('limpiarNumeroWhatsApp') && function_exists('generarMensajeParaCliente')) {
        echo "<p style='color: green;'>✅ message_helper.php cargado exitosamente. Funciones encontradas.</p>";
    } else {
        echo "<p style='color: red;'>❌ ERROR: Funciones de message_helper.php NO encontradas.</p>";
    }
} catch (Throwable $e) {
    echo "<p style='color: red;'>❌ ERROR FATAL al cargar message_helper.php: " . htmlspecialchars($e->getMessage()) . "</p>";
    exit();
}

// Probar getConfigValue (asumiendo que se carga con db.php)
echo "<h2>4. Probando getConfigValue()...</h2>";
try {
    if (function_exists('getConfigValue')) {
        $test_moneda = getConfigValue('moneda_simbolo', $_SESSION['id_usuario'] ?? 1, 'S/');
        echo "<p style='color: green;'>✅ getConfigValue() encontrada y funcionando. Símbolo de moneda: " . htmlspecialchars($test_moneda) . "</p>";
    } else {
        echo "<p style='color: red;'>❌ ERROR: Función getConfigValue() NO encontrada.</p>";
    }
} catch (Throwable $e) {
    echo "<p style='color: red;'>❌ ERROR FATAL al probar getConfigValue(): " . htmlspecialchars($e->getMessage()) . "</p>";
    exit();
}

// Probar una consulta simple de perfiles
echo "<h2>5. Probando consulta SQL de perfiles...</h2>";
try {
    $test_id_usuario_sesion = $_SESSION['id_usuario'] ?? 1; // Usar ID de sesión o 1 como fallback
    $test_rol_usuario_sesion = $_SESSION['rol'] ?? 'superadmin';

    $test_where_clause = "";
    $test_params = [];
    if ($test_rol_usuario_sesion !== 'superadmin') {
        $test_where_clause = " WHERE pv.id_usuario = :id_usuario_sesion";
        $test_params[':id_usuario_sesion'] = $test_id_usuario_sesion;
    }

    $sql_test_perfiles = "SELECT pv.id_perfil_vendido, c.nombre_completo, p.nombre_plataforma
                            FROM perfiles_vendidos pv
                            JOIN clientes c ON pv.id_cliente = c.id_cliente
                            JOIN cuentas_maestras cm ON pv.id_cuenta_maestra = cm.id_cuenta_maestra
                            JOIN plataformas p ON cm.id_plataforma = p.id_plataforma
                            " . $test_where_clause . " LIMIT 1"; // Limitar a 1 para que sea rápido

    $stmt_test_perfiles = $pdo->prepare($sql_test_perfiles);
    $stmt_test_perfiles->execute($test_params);
    $test_perfil_data = $stmt_test_perfiles->fetch(PDO::FETCH_ASSOC);

    if ($test_perfil_data) {
        echo "<p style='color: green;'>✅ Consulta de perfiles exitosa. Primer perfil: " . htmlspecialchars($test_perfil_data['nombre_completo'] . ' - ' . $test_perfil_data['nombre_plataforma']) . "</p>";
    } else {
        echo "<p style='color: orange;'>Advertencia: No se encontraron perfiles en la base de datos para la prueba.</p>";
    }
} catch (Throwable $e) {
    echo "<p style='color: red;'>❌ ERROR FATAL en consulta SQL de perfiles: " . htmlspecialchars($e->getMessage()) . "</p>";
    exit();
}

echo "<h1>Prueba de Depuración Finalizada. Si no hubo errores FATAL y estás logueado, tu entorno está listo.</h1>";
?>