<?php
// Script de prueba para verificar la preservación de filtros
// Simula los parámetros que se enviarían desde el controlador

echo "<h2>🧪 Prueba de Preservación de Filtros</h2>";

// Simular parámetros de filtro
$filtros_simulados = [
    'buscar' => 'Netflix',
    'filtro_estado' => '1',
    'filtro_estado_cm' => '1',
    'filtro_tipo_cuenta' => 'PERFIL',
    'filtro_vendedor' => '5',
    'filtro_fecha_inicio' => '2024-01-01',
    'filtro_fecha_fin' => '2024-12-31',
    'filtro_precio_min' => '10.00',
    'filtro_precio_max' => '50.00',
    'ordenar_por' => 'precio_venta',
    'orden' => 'ASC'
];

echo "<h3>📋 Filtros Simulados:</h3>";
echo "<pre>" . print_r($filtros_simulados, true) . "</pre>";

// Función helper (copiada del controlador)
function preservarFiltrosEnRedireccion($filtros): string {
    $filtros_preservar = [];
    $parametros_filtro = [
        'buscar', 'filtro_estado', 'filtro_estado_cm', 'filtro_tipo_cuenta', 
        'filtro_vendedor', 'filtro_fecha_inicio', 'filtro_fecha_fin', 'filtro_precio_min', 
        'filtro_precio_max', 'ordenar_por', 'orden', 'cargar_mas'
    ];
    
    foreach ($parametros_filtro as $param) {
        if (isset($filtros[$param]) && $filtros[$param] !== '') {
            $filtros_preservar[$param] = $filtros[$param];
        }
    }
    
    if (!empty($filtros_preservar)) {
        return "?" . http_build_query($filtros_preservar);
    }
    
    return "";
}

// Probar la función
$query_string = preservarFiltrosEnRedireccion($filtros_simulados);

echo "<h3>🔗 Query String Generado:</h3>";
echo "<code>$query_string</code>";

echo "<h3>🌐 URL Completa:</h3>";
$url_completa = "/digitalpremium/pages/perfiles_vendidos.php" . $query_string;
echo "<code>$url_completa</code>";

echo "<h3>📝 Parámetros Parseados:</h3>";
$parametros_parseados = [];
parse_str(ltrim($query_string, '?'), $parametros_parseados);
echo "<pre>" . print_r($parametros_parseados, true) . "</pre>";

echo "<h3>✅ Verificación:</h3>";
$todos_preservados = true;
foreach ($filtros_simulados as $clave => $valor) {
    if (isset($parametros_parseados[$clave])) {
        if ($parametros_parseados[$clave] === $valor) {
            echo "✅ <strong>$clave</strong>: $valor<br>";
        } else {
            echo "❌ <strong>$clave</strong>: Esperado '$valor', Obtenido '{$parametros_parseados[$clave]}'<br>";
            $todos_preservados = false;
        }
    } else {
        echo "❌ <strong>$clave</strong>: No encontrado<br>";
        $todos_preservados = false;
    }
}

echo "<br><h3>🎯 Resultado Final:</h3>";
if ($todos_preservados) {
    echo "🎉 <strong>TODOS LOS FILTROS SE PRESERVARON CORRECTAMENTE</strong>";
} else {
    echo "⚠️ <strong>ALGUNOS FILTROS NO SE PRESERVARON CORRECTAMENTE</strong>";
}

echo "<br><br><a href='$url_completa' target='_blank'>🔗 Probar URL Generada</a>";
?>
